--
-- Zetor5211Rotation
-- Specialization for all the user-controlled rotating parts on a vehicle
--
-- @author  Templaer
-- @date  19/11/09
--

Zetor5211Rotation = {};

function Zetor5211Rotation.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Zetor5211Rotation:load(xmlFile)
	self.doRotate = SpecializationUtil.callSpecializationsFunction("doRotate");

    self.rotatingParts = {};
    local rotatingPartsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rotatingParts#count"), 0);	
	for i=1, rotatingPartsCount do
		local namei = string.format("vehicle.rotatingParts.rotatingPart%d", i);
		local rotatingPart = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
		
		self.rotatingParts[i] = {};
		self.rotatingParts[i].node = rotatingPart;
		
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, namei .. "#minRot"));
        self.rotatingParts[i].minRot = {};
        self.rotatingParts[i].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotatingParts[i].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotatingParts[i].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, namei .. "#maxRot"));
		self.rotatingParts[i].maxRot = {};
        self.rotatingParts[i].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotatingParts[i].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotatingParts[i].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		
		self.rotatingParts[i].rotTime = Utils.getNoNil(getXMLString(xmlFile, namei .. "#rotTime"), 2)*1000;
	end;
	
	self.isLeftDoorOpen = false;
	self.isRightDoorOpen = false;
	self.isRearWindowOpen = false;
	
	self.interiorClosed = true;
end;

function Zetor5211Rotation:delete()
end;

function Zetor5211Rotation:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Zetor5211Rotation:keyEvent(unicode, sym, modifier, isDown)
end;

function Zetor5211Rotation:update(dt)	
    if self.isEntered then
		local x, y, z;
		local x1, y1, z1;
		local x2, y2, z2;
		if self.rotatingParts[1] ~= nil then
			if InputBinding.hasEvent(InputBinding.Zetor5211LEFTDOOR) then
				self.isLeftDoorOpen = not self.isLeftDoorOpen;
			end;
			
		    x, y, z = getRotation(self.rotatingParts[1].node);
			self:doRotate(1, self.isLeftDoorOpen, dt);	
		end;
		
		if self.rotatingParts[2] ~= nil then
			if InputBinding.hasEvent(InputBinding.Zetor5211RIGHTDOOR) then	
				self.isRightDoorOpen = not self.isRightDoorOpen;
			end;
			
			x1, y1, z1 = getRotation(self.rotatingParts[2].node);		
			self:doRotate(2, self.isRightDoorOpen, dt);
		end;
		
		if self.rotatingParts[3] ~= nil then		
			if InputBinding.hasEvent(InputBinding.Zetor5211WINDOW) then	
				self.isRearWindowOpen = not self.isRearWindowOpen;
			end;		
			x2, y2, z2 = getRotation(self.rotatingParts[3].node);				
			self:doRotate(3, self.isRearWindowOpen, dt);
		end;
				
		if y == 0 and y1 == 0 and x2 == 0 then
			self.interiorClosed = true;
		else
			self.interiorClosed = false;
		end;
	end;
end;

function Zetor5211Rotation:draw()  
	--[[if self.rotatingParts[4] ~= nil then
		self:addStats(g_i18n:getText("Key").." ".."4, 5, 6, 7:", "Use the doors/windows");
	else
		self:addStats(g_i18n:getText("Key").." ".."4, 5, 6:", "Use the doors/window");
	end;]]--
end;

-- Additional function(s)
function Zetor5211Rotation:doRotate(index, boolean, dt)
	local x, y, z = getRotation(self.rotatingParts[index].node);
	local rot = {x,y,z};
	local newRot = Utils.getMovedLimitedValues(rot, self.rotatingParts[index].maxRot, self.rotatingParts[index].minRot, 3, self.rotatingParts[index].rotTime, dt, not boolean);
	setRotation(self.rotatingParts[index].node, unpack(newRot));
end;
