--
-- mooringblocks
--
-- @author  Geri-G
-- @date  31/07/10
--
-- Copyright (C) Geri-G

mooringblocks = {};

function mooringblocks.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function mooringblocks:load(xmlFile)
	self.disabledBlocks = {};
	self.enabledBlocks = {};
	
	local i = 0;
	while true do
		local baseString = string.format("vehicle.mooringblocks.enabled.mooringblock(%d)",i);
		local nodeStrg = getXMLString(xmlFile,baseString.."#node");
		if nodeStrg == nil then
			break;
		end;
		node = Utils.indexToObject(self.components, nodeStrg);
		table.insert(self.enabledBlocks,node);
		setRigidBodyType(node,"None");
		i = i+1;
	end;	
	local i = 0;
	while true do
		local baseString = string.format("vehicle.mooringblocks.disabled.mooringblock(%d)",i);
		local nodeStrg = getXMLString(xmlFile,baseString.."#node");
		if nodeStrg == nil then
			break;
		end;
		node = Utils.indexToObject(self.components, nodeStrg);
		table.insert(self.disabledBlocks,node);
		i = i+1;
	end;
	self.doJointSearch = false;
	self.changeBlocks = mooringblocks.changeBlocks;
end;

function mooringblocks:delete()

end;

function mooringblocks:mouseEvent(posX, posY, isDown, isUp, button)
end;

function mooringblocks:keyEvent(unicode, sym, modifier, isDown)
end;

function mooringblocks:update(dt)
	if self:getIsActive() then
		if self.doJointSearch then	
			for i,v in pairs(self.attacherVehicle.attachedImplements) do
				if v.object == self then
					local joint = self.attacherVehicle.attacherJoints[v.jointDescIndex];
					self.vehicleJoint = joint;	
					break;
				end;
			end;
			self.doJointSearch = false;
		end;
	end;
end;
function mooringblocks:draw()

end;

function mooringblocks:onAttach(attacherVehicle)
	self:changeBlocks(true);
	self.doJointSearch = true;
	
	local joint = self.componentJoints[3];
	setJointRotationLimit(joint.jointIndex,1,true,math.rad(-10),math.rad(10));
	setRotation(joint.jointNode,math.rad(0),math.rad(180),math.rad(-90));
	setJointFrame(joint.jointIndex, 0, joint.jointNode);
end;

function mooringblocks:onDetach()
	self:changeBlocks(false);
	local joint = self.componentJoints[3];
	
	local ax, ay, az = getWorldTranslation(joint.jointNode);
	local bx, by, bz = getWorldTranslation(self.vehicleJoint.jointTransform);
	local x, y, z = worldDirectionToLocal(getParent(joint.jointNode), bx-ax, by-ay, bz-az);

	--print(string.format("setDirection(node, %0.3f,%0.3f,%0.3f,1,0,0);",x, y, z ));
	setDirection(joint.jointNode, x, y, z, 1,0,0);	 
	self.vehicleJoint = nil;
	
	setJointFrame(joint.jointIndex, 0, joint.jointNode);
	setJointRotationLimit(joint.jointIndex,1,true,0,0);
	self:setHydraulicDirection();
end;
function mooringblocks:changeBlocks(enabled)

	if enabled == false then
		for k,v in pairs(self.disabledBlocks) do
			setVisibility(v, false);
		end;	
		for k,v in pairs(self.enabledBlocks) do
			setVisibility(v, true);
		end;
	elseif enabled == true then
		for k,v in pairs(self.disabledBlocks) do
			setVisibility(v, true);
		end;	
		for k,v in pairs(self.enabledBlocks) do
			setVisibility(v, false);
		end;
	end;
end;