--
-- Wizzy_Sprayer
-- Class for the attachable PTO for sprayers
--
-- @author  LS_UK Modteam
-- @date  04/08/11
--
 
Wizzy_Sprayer = {};


function Wizzy_Sprayer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Sprayer, specializations) and SpecializationUtil.hasSpecialization(PowerShaft, specializations);
end;

function Wizzy_Sprayer:load(xmlFile)

      self.sprayValvesWizzy = {};
  
      if self.isClient then
          local psFile = getXMLString(xmlFile, "vehicle.sprayParticleSystemWizzy#file");
          if psFile ~= nil then
              local i=0;
              while true do
                  local baseName = string.format("vehicle.sprayValvesWizzy.sprayValveWizzy(%d)", i);
                  local node = getXMLString(xmlFile, baseName.. "#index");
                  if node == nil then
                      break;
                  end;
                  node = Utils.indexToObject(self.components, node);
                  if node ~= nil then
                      local sprayValveWizzy = {};
                      sprayValveWizzy.particleSystems = {};
                      Utils.loadParticleSystem(xmlFile, sprayValveWizzy.particleSystems, "vehicle.sprayParticleSystemWizzy", node, false, nil, self.baseDirectory);
                      table.insert(self.sprayValvesWizzy, sprayValveWizzy);
                  end;
                  i = i+1;
              end;
          end;
  
          local spraySoundWizzy = getXMLString(xmlFile, "vehicle.spraySoundWizzy#file");
          if spraySoundWizzy ~= nil and spraySoundWizzy ~= "" then
              spraySoundWizzy = Utils.getFilename(spraySoundWizzy, self.baseDirectory);
              self.spraySoundWizzy = createSample("spraySoundWizzy");
              self.sprayWizzySoundEnabled = false;
              loadSample(self.spraySoundWizzy, spraySoundWizzy, false);
              self.spraySoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.spraySoundWizzy#pitchOffset"), 1);
              self.spraySoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.spraySoundWizzy#volume"), 1);
          end;
      end;

      self.printWarningTime = 0;
      self.isTurnedOn = false;
end;
  
function Wizzy_Sprayer:delete()
      for k,sprayValveWizzy in pairs(self.sprayValvesWizzy) do
          Utils.deleteParticleSystem(sprayValveWizzy.particleSystems);
      end;
  
      if self.spraySoundWizzy ~= nil then
          delete(self.spraySoundWizzy);
      end;
end;

function Wizzy_Sprayer:readStream(streamId, connection)

end;

function Wizzy_Sprayer:writeStream(streamId, connection)
	
end;
 
function Wizzy_Sprayer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Wizzy_Sprayer:keyEvent(unicode, sym, modifier, isDown)
 end;

function Wizzy_Sprayer:update(dt)

      if self:getIsActiveForInput() then
			if InputBinding.isPressed(InputBinding.IMPLEMENT_EXTRA) and self.PTOId then
				self.printWarningTime = self.time + 1500;
			end;	
      end;
	
	for i, jointDesc in pairs(self.componentJoints) do
		setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
	end;	
end;

function Wizzy_Sprayer:updateTick(dt)
    if self:getIsActive() then
		if not self.attacherVehicle.isMotorStarted then
			self.isTurnedOn = false;
		end;
		if self.PTOId then
			self.isTurnedOn = false;
		end;
		if self.isTurnedOn and not self.PTOId then
            if self.isClient then
                for k,sprayValveWizzy in pairs(self.sprayValvesWizzy) do
                    Utils.setEmittingState(sprayValveWizzy.particleSystems, true);
				end;
			end;
            if not self.sprayWizzySoundEnabled and self:getIsActiveForSound() then
                playSample(self.spraySoundWizzy, 0, self.spraySoundVolume, 0);
                setSamplePitch(self.spraySoundWizzy, self.spraySoundPitchOffset);
                self.sprayWizzySoundEnabled = true;
			end;

		else
            if self.sprayWizzySoundEnabled then
                 stopSample(self.spraySoundWizzy);
                 self.sprayWizzySoundEnabled = false;
            end;
			if self.isClient then
				for k,sprayValveWizzy in pairs(self.sprayValvesWizzy) do
					 Utils.setEmittingState(sprayValveWizzy.particleSystems, false);
				end;
			end;
		end;	
	end;	

end;

function Wizzy_Sprayer:draw()
	if self.isClient then
		if self.printWarningTime > self.time then
			g_currentMission:addWarning(g_i18n:getText("turnON_Error"), 0.018, 0.033);
		end;
	end;
end;

function Wizzy_Sprayer:onAttach(attacherVehicle)

end;

function Wizzy_Sprayer:onDetach()
    for k,sprayValveWizzy in pairs(self.sprayValvesWizzy) do
          Utils.setEmittingState(sprayValveWizzy.particleSystems, false);
    end;
end;

function Wizzy_Sprayer:onLeave()
	if self.deactivateOnLeave then
		Wizzy_Sprayer.onDeactivate(self);
	else
		Wizzy_Sprayer.onDeactivateSounds(self);
	end;
    for k,sprayValveWizzy in pairs(self.sprayValvesWizzy) do
          Utils.setEmittingState(sprayValveWizzy.particleSystems, false);
    end;
end;

function Wizzy_Sprayer:onDeactivate()

	Wizzy_Sprayer.onDeactivateSounds(self)
    for k,sprayValveWizzy in pairs(self.sprayValvesWizzy) do
          Utils.setEmittingState(sprayValveWizzy.particleSystems, false);
    end;
end;

function Wizzy_Sprayer:onDeactivateSounds()
      if self.sprayWizzySoundEnabled then
          stopSample(self.spraySoundWizzy);
          self.sprayWizzySoundEnabled = false;
      end;
end;