--
-- fertilizer_pallet
-- Specialization for fertilizer_pallet

-- original script by
-- @author Felix "Outlaw" Sorge
-- revised by @author Unimog 411

--


wheat_pallet = {};

function wheat_pallet.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function wheat_pallet:load(xmlFile)

	self.wheatInRange = SpecializationUtil.callSpecializationsFunction("wheatInRange");
	
	self.literPerSecond = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.literPerSecond#value"), 1);
	
	self.chargeTypes = {};
	self.fillTypes[FruitUtil.FRUITTYPE_UNKNOWN] = true;
	local chargeTypes = getXMLString(xmlFile, "vehicle.chargeTypes#chargeTypes");
    if chargeTypes ~= nil then
		self.chargefillNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chargeTypes#fillNode"));
        local types = Utils.splitString(" ", chargeTypes);
        for k,v in pairs(types) do
            local desc = FruitUtil.fruitTypes[v];
            if desc ~= nil then
                self.chargeTypes[desc.index] = true;
            end;
        end;
    end;
	
	
	self.wheatBags = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.wheatBags#count"), 0);
    self.bags = {};
    for i=1, self.wheatBags do
        local bagnamei = string.format("vehicle.wheatBags.bag%d", i);
        self.bags[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, bagnamei .. "#index"));
        setVisibility(self.bags[i], false);
    end;
	
	self.singleBag = 25;

	
	self.keyType = InputBinding.getButtonKeyName;
	self.keyName = "Taste";	
	if g_settingsJoystickEnabled then 
		self.keySet = not self.keySet;
	end; 

	self.wheatpallet = true;
	
	self:setFillLevel(1000, FruitUtil.FRUITTYPE_WHEAT);
	
end;


function wheat_pallet:update(dt)
					
	for chargeTypes,v in pairs(self.chargeTypes) do	
		if chargeTypes == self.currentFillType then
			if self.fillLevel ~= 0 then
				self:wheatInRange(dt);
			end; 
			
		elseif self.fillLevel == 0 then
			self.turnOn = false; 
			self:setFillLevel(0, FruitUtil.FRUITTYPE_WHEAT);
		end; 	
	end;


	if self.bags ~= nil then
		if self.fillLevel > 0 then
			for i = 1, self.wheatBags do
				if i * self.singleBag-24 <= self.fillLevel then
					setVisibility(self.bags[i], true);
				else
				setVisibility(self.bags[i], false);
				end;
			end;
		end;
	end;
end;

	



function wheat_pallet:wheatInRange(dt)
    local nearestDistance = 3.0;
	local px, py, pz = getWorldTranslation(self.chargefillNode);
	for i=1, table.getn(g_currentMission.attachables) do
		local vx, vy, vz = getWorldTranslation(g_currentMission.attachables[i].rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);

		if distance < nearestDistance then
			local attachable = g_currentMission.attachables[i];			
			for fruitType,v in pairs(self.fillTypes) do
				if not attachable.wheatpallet then
					if fruitType == self.currentFillType and attachable.rootNode ~= self.rootNode and attachable.setFillLevel ~= nil then
			
						if attachable.fillLevel == attachable.capacity  or self.filllevel == 0 then
							self.turnOn = false; 
					
						elseif attachable.fillLevel ~= attachable.capacity  and self.fillLevel ~= 0 then
							if self.turnOn then
								g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.fertilizer_pallet_ON).. ": " ..g_i18n:getText("fertilizer_pallet_2")); 
								if InputBinding.hasEvent(InputBinding.FERTILIZER_PALLET_ON) then
								self.turnOn = not self.turnOn; 
								end;
									local percent = self.fillLevel /self.capacity*100;	
									local deltaLevel = self.literPerSecond*dt/1000.0;
									deltaLevel = math.min(deltaLevel, attachable.capacity - attachable.fillLevel);
									self.fillLevel = self.fillLevel-deltaLevel;
									self:setFillLevel(self.fillLevel, self.currentFillType);
									attachable:setFillLevel(attachable.fillLevel + deltaLevel, self.currentFillType);			
							else
								g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.FERTILIZER_PALLET_ON).. ": " ..g_i18n:getText("fertilizer_pallet_1")); 
								if InputBinding.hasEvent(InputBinding.FERTILIZER_PALLET_ON)  then
									self.turnOn = not self.turnOn; 
								end;
							end;
						end;
					end;
				end;
			end;
		end;
    end;
end;


function wheat_pallet:delete()
end;


function wheat_pallet:mouseEvent(posX, posY, isDown, isUp, button)
end;


function wheat_pallet:keyEvent(unicode, sym, modifier, isDown)

end;


function wheat_pallet:draw()
end;


function wheat_pallet:onAttach()
end; 	


function wheat_pallet:onDetach()
end;