--
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Budman81
-- Date 5/10/2012
-- 
--
-- Copyright (c) Budman81. - All Rights Reserved.
--

WhiteShowHelp = {};

function WhiteShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function WhiteShowHelp:load(xmlFile)
	self.WhiteShowHelp = false;
end;

function WhiteShowHelp:delete()
end;

function WhiteShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function WhiteShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function WhiteShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.WhiteShowHelp = not self.WhiteShowHelp;
		end;
	end;
end;



function WhiteShowHelp:updateTick(dt)
end;


function WhiteShowHelp:draw()
	if not self.WhiteShowHelp then
		renderText(0.80, 0.25, 0.02, "Numpad 0: White 2_180 Info  ");
	 else
		renderText(0.80, 0.25, 0.02, "Numpad 0: White 2_180 Info ");
		renderText(0.72, 0.68, 0.025, "- White 2_180 -");			
		renderText(0.72, 0.65, 0.02, "Key Home: Rundumleuchten ");
		renderText(0.72, 0.63, 0.02, "Key KP 1: Blinker Left ");
		renderText(0.72, 0.61, 0.02, "Key KP 2: Warnblinker");
		renderText(0.72, 0.59, 0.02, "Key KP 3: Blinker Right");
		renderText(0.72, 0.57, 0.02, "Key F Main lights ");
		renderText(0.72, 0.55, 0.02, "Key KP 5: Front Worklights ");
		renderText(0.72, 0.53, 0.02, "Key KP 6: Back Worklights");			
		renderText(0.72, 0.51, 0.02, "Key KP 7: Left window");
		renderText(0.72, 0.49, 0.02, "Key KP 8: Back window ");
		renderText(0.72, 0.47, 0.02, "Key KP 9: Right window ");
		renderText(0.72, 0.43, 0.02, "Key 8: Duel Wheels ");
		renderText(0.72, 0.41, 0.02, "Key Page_Up: ESL Limiter ");
		renderText(0.72, 0.39, 0.02, "Key Page_Down: ESL Limiter ");
		renderText(0.72, 0.31, 0.02, "Key 0: Horn");
        renderText(0.72, 0.28, 0.025, "- White 2_180 -");
	end;
end;

function WhiteShowHelp:onLeave()
	self.WhiteShowHelp = false;
end;




