-- mchale
-- Specialization for forks used in the Straw Mod 09.
-- @ Bayn - www.tsforum3.com
-- @ date : 06/09/09


mchale = {};

function mchale.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function mchale:load(xmlFile)
	self.numAttachers = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Attachers#count"), 0);
	self.Attacher = {};
	
	for i=1, self.numAttachers do
	 self.Attacher[i] = {};
	 local partnamei = string.format("vehicle.Attachers.objectAttacher".."%d",i);
	 self.Attacher[i].object = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partnamei .. "#index"));
	 self.Attacher[i].attachedObject = nil;
	 self.Attacher[i].objectInRange = nil;
	end;

end;

function mchale:delete()
			for i=1, self.numAttachers do
			ObjectDetachmchale(self,i)
			end;
end;

function mchale:mouseEvent(posX, posY, isDown, isUp, button)
end;

function mchale:keyEvent(unicode, sym, modifier, isDown)


end;

function mchale:update(dt)

	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.MCHALEDETACH) then
			-- dcrochage
		
			for i=1, self.numAttachers do
			ObjectDetachmchale(self,i)
			end;
		end;

		if InputBinding.hasEvent(InputBinding.MCHALEATTACH) then

			-- dtection ballot
			for i=1, self.numAttachers do
				nearest, index = ObjectInRangemchale(self,i);
				self.Attacher[i].objectInRange = nearest;
			end;
				-- accrochage
				ObjectAttachmchale(self,1)

		end;
	end;



end;

function mchale:draw()

	if self.attacherVehicle ~= nil then
		g_currentMission:addExtraPrintText(string.format("Touche %s/%s: Attach/Detach bales", InputBinding.getButtonKeyName(InputBinding.MCHALEATTACH), InputBinding.getButtonKeyName(InputBinding.MCHALEDETACH)));
	end;
end;
	
function ObjectInRangemchale(self,k)
	local nearestObject
	local itemNode
	local index 
	local nearestDistance = 2;
	local objectCopy = self.Attacher[k].object;	
	local px, py, pz = getWorldTranslation(objectCopy);
	for i=1, table.getn(g_currentMission.itemsToSave) do
	    itemNode = g_currentMission.itemsToSave[i].node;
	    if getParent(g_currentMission.itemsToSave[i].node) == getRootNode() then
			if getUserAttribute(itemNode, "isStrawbale") or getUserAttribute(itemNode, "isHaybale") then
				local vx, vy, vz = getWorldTranslation(itemNode);
				local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
				if distance < nearestDistance then
					index = i
					nearestObject = itemNode
					nearestDistance = distance
					
				end;
			end;
		end;
	end;
	return nearestObject, index
end;

function ObjectAttachmchale(self,k)
	if self.Attacher[k].objectInRange ~= nil then
		if self.Attacher[1].attachedObject == nil then
			setRigidBodyType(self.Attacher[k].objectInRange,"none");
			local x,y,z = getWorldRotation(self.Attacher[1].objectInRange);		
			link(self.Attacher[1].object,self.Attacher[k].objectInRange);
			setRotation(self.Attacher[1].objectInRange, 0,0,0);
			setTranslation(self.Attacher[1].objectInRange, 0,0,0)
			self.Attacher[1].attachedObject = self.Attacher[1].objectInRange;
			self.Attacher[1].objectInRange = nil;
		end;
		
		if self.Attacher[2].attachedObject == nil then
			setRigidBodyType(self.Attacher[2].objectInRange,"none");
			local x,y,z = getWorldRotation(self.Attacher[2].objectInRange);		
			link(self.Attacher[2].object,self.Attacher[2].objectInRange);
			setRotation(self.Attacher[2].objectInRange, 0,0,0);
			setTranslation(self.Attacher[2].objectInRange, 0,0,0)
			self.Attacher[2].attachedObject = self.Attacher[2].objectInRange;
			self.Attacher[2].objectInRange = nil;
		end;
	end;
end;

function ObjectDetachmchale(self,k)
	if self.Attacher[k].attachedObject ~= nil then			
		local x,y,z = getWorldTranslation(self.Attacher[k].attachedObject)
		local rx,ry,rz = getWorldRotation(self.Attacher[k].attachedObject)
		local root = getRootNode()
		setTranslation(self.Attacher[k].attachedObject,x,y,z)
		setRotation(self.Attacher[k].attachedObject,rx,ry,rz)
		link(root,self.Attacher[k].attachedObject)
		setRigidBodyType(self.Attacher[k].attachedObject,"Dynamic")
		self.Attacher[k].attachedObject = nil;
	end;
end;