--
-- motorIgnition2
-- Specialization for Motor Ignition
--
-- @author  Templaer
-- @date  01/05/09
--

SpecializationUtil.registerSpecialization("motorIgnition2", "motorIgnition2", g_modsDirectory.."/zzzz_motorIgnition2/motorIgnition2.lua");
--table.insert(VehicleTypeUtil.vehicleTypes.combine.specializations, SpecializationUtil.getSpecialization("motorIgnition2"));

for k,v in pairs(VehicleTypeUtil.vehicleTypes) do  
  if v~=nil then
    for a=1, table.maxn(v.specializations) do
      local s = v.specializations[a];
      if s ~= nil then
        if s == SpecializationUtil.getSpecialization("motorized") then
          print("Start"..tostring(v.name));
          table.insert(v.specializations, SpecializationUtil.getSpecialization("motorIgnition2"));
        end;
      end;
    end;
  end;
end;

print("motorIgnition2 specialization registred");

motorIgnition2 = {};

function motorIgnition2.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function motorIgnition2:load(xmlFile)
    -- Booleans
    self.ignitionKey = false;
	self.allowedIgnition = false;                                                  
	
	-- Backup Stop Sound volume
    self.motorStopSoundVolume2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#volume"), 1.0);
end;

function motorIgnition2:delete()
end;

function motorIgnition2:mouseEvent(posX, posY, isDown, isUp, button)
end;

function motorIgnition2:keyEvent(unicode, sym, modifier, isDown)
end;

function motorIgnition2:update(dt)
	-- Does not execute when AI is activated
    if not self.isAITractorActivated then
        -- Handles ignition key input
        if self:getIsActiveForInput() then
            if InputBinding.hasEvent(InputBinding.IGNITION2) then
		        self.ignitionKey = not self.ignitionKey;
			    self.allowedIgnition = true;
	        end;
	    end;
		
	    -- Prevents the engine from starting upon entering
	    if not self.allowedIgnition and  not self.ignitionKey then
            self.isMotorStarted = false;
            Motorized.stopSounds(self);
	        self.steeringEnabled = false;
            Utils.setEmittingState(self.exhaustParticleSystems, false)
	    end;
	
	    -- Mutes stop sound when engine is off
	    if not self.ignitionKey then
	        self.motorStopSoundVolume = 0;
        else
	        self.motorStopSoundVolume = self.motorStopSoundVolume2;
	    end;
		
	    -- Starts and stops the engine
	    if self.allowedIgnition then
	        if  not self.ignitionKey then
		        self.motorStopSoundVolume = self.motorStopSoundVolume2;
                self:stopMotor();
			    self.steeringEnabled = false;
                self.allowedIgnition = false;	
		
			    -- Brakes the wheels upon turning off the engine
                for k,wheel in pairs(self.wheels) do
                    setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
                end;
                self:onDeactivateAttachements();
	        elseif self.ignitionKey then
                self:startMotor();
                self.steeringEnabled = true;
                self.allowedIgnition = false;		
       	    end;
	    end;
    -- Prevents the AI from working when engine is off
    elseif not self.ignitionKey and not self.deactivateOnLeave then
		self:stopAITractor();
	end;
end;

function motorIgnition2:onLeave()
    --Leaves the engine on when AI is driving
	if not self.deactivateOnLeave then
	    self.allowedIgnition = false;
	    self.ignitionKey = true; 
    else
	    self.allowedIgnition = false;
	    self.ignitionKey = false;
	end;
end;

function motorIgnition2:draw()
    -- Draws ignition mode and ignition text
    if not self.isMotorStarted and not self.automaticStart then	
        g_currentMission:addHelpButtonText(g_i18n:getText("Start"), InputBinding.IGNITION2);
	end;
end;

