-- HEVA_300_Front_Packer
-- Specialization for HEVA_300_Front_Packer
--
-- @ Autor  Tobias F. (John Deere 6930)
-- @ Last Edit  19/09/2011


HEVA_300_Front_Packer = {};

function HEVA_300_Front_Packer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function HEVA_300_Front_Packer:load(xmlFile)
	self.supportSplint1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.support#splintIndex1"));
	self.supportSplint2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.support#splintIndex2"));
	self.supportSplintBackUp = getVisibility(self.supportSplint1);
	self.doAttacherVehicleJointSearch = false;
	self.attacherVehicleJoint = nil;
	self.attacherVehicleSelf = nil;
end;

function HEVA_300_Front_Packer:delete()
end;

function HEVA_300_Front_Packer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HEVA_300_Front_Packer:keyEvent(unicode, sym, modifier, isDown)
end;

function HEVA_300_Front_Packer:update(dt)
	if self.doAttacherVehicleJointSearch then
		for k,v in pairs(self.attacherVehicle.attachedImplements) do
			if v.object == self then
				local joint = self.attacherVehicle.attacherJoints[v.jointDescIndex];
				self.attacherVehicleJoint = joint;
				self.attacherVehicleSelf = v;
				self.doAttacherVehicleJointSearch = false;
				break;
			end;
		end;
		self.doAttacherVehicleJointSearch = false;
	end;
end;

function HEVA_300_Front_Packer:updateTick(dt)
	if self.supportAnimation ~= nil and self.getRealAnimationTime ~= nil and self.getAnimationDuration ~= nil and self.supportSplint1 ~= nil and self.supportSplint2 ~= nil then
		local state = true;
		if self:getRealAnimationTime(self.supportAnimation) > 0 and self:getRealAnimationTime(self.supportAnimation) < self:getAnimationDuration(self.supportAnimation) then
			state = false;
		else
			state = true;
		end;
		if self.supportSplintBackUp ~= state then
			setVisibility(self.supportSplint1, state);
			setVisibility(self.supportSplint2, state);
			self.supportSplintBackUp = state;
		end;
	end;
	
	if self:getIsActive() then
		if self.isServer then
			local hasGC = false
			for _,wheel in pairs(self.wheels) do
				if wheel.hasGroundContact then
					hasGC = true;
					break;
				end;
			end;
			if hasGC then
				local cuttingAreasSend = {};
				for k,cuttingArea in pairs(self.cuttingAreas) do
					if self:getIsAreaActive(cuttingArea) then
						local x,y,z = getWorldTranslation(cuttingArea.start);
						local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
						local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
						table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
					end;
				end;
				if (table.getn(cuttingAreasSend) > 0) then
					SprayerAreaEvent.runLocally(cuttingAreasSend);
					g_server:broadcastEvent(SprayerAreaEvent:new(cuttingAreasSend));
				end;
			end;
		
			if self.attacherVehicleJoint ~= nil and self.attacherVehicleSelf ~= nil then
				if self.attacherVehicleJoint.moveDown then
					local newRotLimit = {0,0,0};
					for i=1, 3 do
						if math.abs(newRotLimit[i] - self.attacherVehicleSelf.jointRotLimit[i]) > 0.0005 then
							setJointRotationLimit(self.attacherVehicleJoint.jointIndex, i-1, true, -newRotLimit[i], newRotLimit[i]);
						end;
					end;
				end;
			end;
		end;
	end;
end;

function HEVA_300_Front_Packer:draw()
end;

function HEVA_300_Front_Packer:onAttach(attacherVehicle)
	self.doAttacherVehicleJointSearch = true;
end;

function HEVA_300_Front_Packer:onDetach()
	self.attacherVehicleJoint = nil;
	self.attacherVehicleSelf = nil;
end;












