zetor = {};

function zetor:new(configFile, positionX, offsetY, positionZ, rotationY, customMt)

    if zetor_mt == nil then
        zetor_mt = Class(zetor, Vehicle);
    end;

    local mt = customMt;
    if mt == nil then
        mt = zetor_mt;
    end;
    local instance = Vehicle:new(configFile, positionX, offsetY, positionZ, rotationY, mt);

    local xmlFile = loadXMLFile("TempConfig", configFile);
	
	instance.numWorklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    instance.worklights = {};
    for i=1, instance.numWorklights do
        local worklightnamei = string.format("vehicle.worklights.worklight" .. "%d", i);
        instance.worklights[i] = Utils.indexToObject(instance.rootNode, getXMLInt(xmlFile, worklightnamei .. "#index"));
        setVisibility(instance.worklights[i], false);
    end;
	
	instance.numTwinWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.twinWheels#count"), 0);
    instance.twinWheels = {};
    for i=1, instance.numTwinWheels do
        local twinWheelnamei = string.format("vehicle.twinWheels.twinWheel" .. "%d", i);
        instance.twinWheels[i] = Utils.indexToObject(instance.rootNode, getXMLInt(xmlFile, twinWheelnamei .. "#index"));
        setVisibility(instance.twinWheels[i], false);
    end;
	
	instance.numSmallWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.smallWheels#count"), 0);
    instance.smallWheels = {};
    for i=1, instance.numSmallWheels do
        local smallWheelnamei = string.format("vehicle.smallWheels.smallWheel" .. "%d", i);
        instance.smallWheels[i] = Utils.indexToObject(instance.rootNode, getXMLInt(xmlFile, smallWheelnamei .. "#index"));
        setVisibility(instance.smallWheels[i], false);
    end;
	
	instance.numBigWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.bigWheels#count"), 0);
    instance.bigWheels = {};
    for i=1, instance.numBigWheels do
        local bigWheelnamei = string.format("vehicle.bigWheels.bigWheel" .. "%d", i);
        instance.bigWheels[i] = Utils.indexToObject(instance.rootNode, getXMLInt(xmlFile, bigWheelnamei .. "#index"));
        setVisibility(instance.bigWheels[i], true);
    end;
	
	instance.trailerAttacherJoint1 = Utils.indexToObject(instance.rootNode, getXMLString(xmlFile, "vehicle.attacherJoint#index"));
    instance.trailerAttacherJoint2 = Utils.indexToObject(instance.rootNode, getXMLString(xmlFile, "vehicle.frontAttacherJoint#index"));
	
	instance.exhaustParticleSystems2 = {};
    local psName = "vehicle.exhaustParticleSystemExtra1";
    Utils.loadParticleSystem(xmlFile, instance.exhaustParticleSystems2, psName, instance.rootNode, false)
	
	instance.exhaustParticleSystems3 = {};
    local psName = "vehicle.exhaustParticleSystemExtra2";
    Utils.loadParticleSystem(xmlFile, instance.exhaustParticleSystems3, psName, instance.rootNode, false)
	
	instance.exhaustParticleSystems4 = {};
    local psName = "vehicle.exhaustParticleSystemExtra3";
    Utils.loadParticleSystem(xmlFile, instance.exhaustParticleSystems4, psName, instance.rootNode, false)
	
	instance.exhaustParticleSystems5 = {};
    local psName = "vehicle.exhaustParticleSystemExtra4";
    Utils.loadParticleSystem(xmlFile, instance.exhaustParticleSystems5, psName, instance.rootNode, false)
	
	instance.numRoundlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.roundlights#count"), 0);
    instance.roundlights = {};
    for i=1, instance.numRoundlights do
        local roundlightnamei = string.format("vehicle.roundlights.roundlight" .. "%d", i);
        instance.roundlights[i] = Utils.indexToObject(instance.rootNode, getXMLInt(xmlFile, roundlightnamei .. "#index"));
        setVisibility(instance.roundlights[i], false);
    end;
	
	local compressorSound = getXMLString(xmlFile, "vehicle.compressorSound#file");
    if compressorSound ~= nil and compressorSound ~= "" then
        instance.compressorSound = createSample("compressorSound");
        loadSample(instance.compressorSound, compressorSound, false);
    end;
	
	instance.drumNode = Utils.indexToObject(instance.rootNode, getXMLString(xmlFile, "vehicle.rundumleuchte#index"));
    instance.drumRotationScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.rundumleuchte#rotationScale"), 1);
	
	instance.worklightsActive = false;
	instance.roundlightsActive = false;
	instance.twinWheelsActive = false;
	instance.bigWheelsActive = false;
	instance.smallWheelsActive = true;
	instance.compressorSampleRunning = false;
	
	delete(xmlFile);
	return instance;
end;

function zetor:keyEvent(unicode, sym, modifier, isDown)
	zetor:superClass().keyEvent(self, unicode, sym, modifier, isDown);
	
	if isDown and sym == Input.KEY_4 then
		self.worklightsActive = not self.worklightsActive;
	end;
	if not self.worklightsActive then
		if isDown and sym == Input.KEY_5 then
			self.roundlightsActive = not self.roundlightsActive;
		end;
	end;
	if isDown and sym == Input.KEY_6 then
        self.twinWheelsActive = not self.twinWheelsActive;
		self.smallWheelsActive = true;
		self.bigWheelsActive = false;
    end;
	
	if isDown and sym == Input.KEY_7 then
		self.bigWheelsActive = not self.bigWheelsActive;
		self.twinWheelsActive = false;
	    self.smallWheelsActive = not self.smallWheelsActive;
	end;
	
	if isDown and sym == Input.KEY_0 then
		self.helpPanel = not self.helpPanel;
	end;
end;

function zetor:update(dt)

	if self.isEntered then
		if self.attachedTrailer and self.lastSpeed*3600 > 2 and self.lastSpeed*3600 < 20 then
			Utils.setEmittingState(self.exhaustParticleSystems2, true);
		end;
		if not self.attachedTrailer or not self.motor.speedLevel == 0 or self.lastSpeed*3600 < 2 or self.lastSpeed*3600 > 20 then
			Utils.setEmittingState(self.exhaustParticleSystems2, false);
		end;
		if self.attachedTrailer and self.lastSpeed*3600 > 20 then
			Utils.setEmittingState(self.exhaustParticleSystems3, true);
		end;
		if not self.attachedTrailer or self.lastSpeed*3600 < 20 then
			Utils.setEmittingState(self.exhaustParticleSystems3, false);
		end;
		if not self.attachedTrailer and self.lastSpeed*3600 > 2 and self.lastSpeed*3600 < 20 then
			Utils.setEmittingState(self.exhaustParticleSystems4, true);
		end;
		if not self.attachedTrailer and self.lastSpeed*3600 < 2 or self.lastSpeed*3600 > 20 then
			Utils.setEmittingState(self.exhaustParticleSystems4, false);
		end;
		
		if not self.attachedTrailer and self.lastSpeed*3600 > 20 then
			Utils.setEmittingState(self.exhaustParticleSystems5, true);
		end;
		if not self.attachedTrailer and self.lastSpeed*3600 < 20 then
			Utils.setEmittingState(self.exhaustParticleSystems5, false);
		end;
	end;
	
	if self.isEntered then
		
		if self.twinWheelsActive then
			for i=1, self.numTwinWheels do
				local twinWheel = self.twinWheels[i];
				setVisibility(twinWheel, self.twinWheelsActive);
			end;
		else
			for i=1, self.numTwinWheels do
				local twinWheel = self.twinWheels[i];
				setVisibility(twinWheel, self.twinWheelsActive, false);
			end;
		end;
		
		if self.smallWheelsActive then
			for i=1, self.numSmallWheels do
				local smallWheel = self.smallWheels[i];
				setVisibility(smallWheel, self.smallWheelsActive);
			end;
		else
			for i=1, self.numSmallWheels do
				local smallWheel = self.smallWheels[i];
				setVisibility(smallWheel, self.smallWheelsActive, false);
			end;
		end;
		
		if not self.bigWheelsActive then
			for i=1, self.numBigWheels do
				local bigWheel = self.bigWheels[i];
				setVisibility(bigWheel, self.bigWheelsActive, false);
			end;
		else
			for i=1, self.numBigWheels do
				local bigWheel = self.bigWheels[i];
				setVisibility(bigWheel, self.bigWheelsActive);
			end;
		end;
		
		if not self.compressorSoundRunning then
            playSample(self.compressorSound, 0, 1, 0);
            self.compressorSoundRunning = true;
        end;
	end;
	
	if self.roundlightsActive then
		if self.drumNode ~= nil then
            rotate(self.drumNode, self.drumRotationScale*dt, 0, 0, 0);
        end;
		for i=1, self.numRoundlights do
			local roundlight = self.roundlights[i];
			setVisibility(roundlight, self.roundlightsActive);
		end;
	else
		for i=1, self.numRoundlights do
			local roundlight = self.roundlights[i];
			setVisibility(roundlight, self.roundlightsActive, false);
		end;
	end;
	
	if self.worklightsActive then
		for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive);
		end;
	else
		for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive, false);
		end;
	end;
	
	if self.worklightsActive then
		self.roundlightsActive = false;
	end;
	
	if self.isEntered then
		if not self.helpPanel then
			renderText(0.02, 0.2, 0.03, "Przycisk 0: Wlacz informacje");
		else
			renderText(0.02, 0.2, 0.02, "Przycisk 0: Wylacz informacje");
		end;
		if self.helpPanel then
			renderText(0.02, 0.28, 0.025, "- Informacje o traktorze -");
			if not self.worklightsActive then
				if self.roundlightsActive then
					renderText(0.02, 0.245, 0.02, "Przycisk 5: Wylacz kogut");
				else
					renderText(0.02, 0.245, 0.023, "Przycisk 5: Wlacz kogut");
				end;
			end;
			if self.worklightsActive then
				renderText(0.02, 0.26, 0.02, "Przycisk 4: Wylacz robocze swiatla");
			else
				renderText(0.02, 0.26, 0.023, "Przycisk 4: Wlacz robocze swiatla");
			end;
		end;
	end;
		
	
	if self.attachedTrailer == nil and self.trailerAttacherJoint2 ~= nil then
	    local px1, py1, pz1 = getWorldTranslation(self.trailerAttacherJoint1);
		local px2, py2, pz2 = getWorldTranslation(self.trailerAttacherJoint2);
        local nearestTrailer = nil
		local nearestDistance = 0.4;
		for i=1, table.getn(g_currentMission.trailers) do
			local vx, vy, vz = getWorldTranslation(g_currentMission.trailers[i].attacherJoint);
	        local distance1 = Utils.vector2Length(px1-vx, pz1-vz);
			local distance2 = Utils.vector2Length(px2-vx, pz2-vz);
			if distance1 < nearestDistance then
				self.trailerAttacherJoint = self.trailerAttacherJoint1;
	        end;
            if distance2 < nearestDistance then
	            self.trailerAttacherJoint = self.trailerAttacherJoint2;
			end;
        end;
	end;
	
	Vehicle.update(self, dt);
	
end;

function zetor:onBrake()
	Vehicle.onBrake(self);
	print("brake");
end;

function zetor:onReleaseBrake()
	Vehicle.onReleaseBrake(self);
	print("release");
end;

function zetor:onLeave()
	Vehicle.onLeave(self);
	self.worklightsActive = false;
	self.roundlightsActive = false;
	Utils.setEmittingState(self.exhaustParticleSystems2, false);
	Utils.setEmittingState(self.exhaustParticleSystems3, false);
	Utils.setEmittingState(self.exhaustParticleSystems4, false);
	Utils.setEmittingState(self.exhaustParticleSystems5, false);
	stopSample(self.compressorSound);
    self.compressorSoundRunning = false;
	self.helpPanel = false;
end;