SetToggleCoverEvent = {};
SetToggleCoverEvent_mt = Class(SetToggleCoverEvent, Event);

InitEventClass(SetToggleCoverEvent, "SetToggleCoverEvent");

function SetToggleCoverEvent:emptyNew()
    local self = Event:new(SetToggleCoverEvent_mt);
    self.className="SetToggleCoverEvent";
    return self;
end;

function SetToggleCoverEvent:new(vehicle, coverState)
    local self = SetToggleCoverEvent:emptyNew()
    self.vehicle = vehicle;
	self.coverState = coverState;
    return self;
end;

function SetToggleCoverEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.coverState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetToggleCoverEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.coverState);
end;

function SetToggleCoverEvent:run(connection)   
	self.vehicle:setToggleCover(self.coverState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetToggleCoverEvent:new(self.vehicle, self.coverState), nil, connection, self.vehicle);
    end;
end;

function SetToggleCoverEvent.sendEvent(vehicle, coverState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetToggleCoverEvent:new(vehicle, coverState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetToggleCoverEvent:new(vehicle, coverState));
		end;
	end;
end;