SetBackDoorEvent = {};
SetBackDoorEvent_mt = Class(SetBackDoorEvent, Event);

InitEventClass(SetBackDoorEvent, "SetBackDoorEvent");

function SetBackDoorEvent:emptyNew()
    local self = Event:new(SetBackDoorEvent_mt);
    self.className="SetBackDoorEvent";
    return self;
end;

function SetBackDoorEvent:new(vehicle, backDoorState)
    local self = SetBackDoorEvent:emptyNew()
    self.vehicle = vehicle;
	self.backDoorState = backDoorState;
    return self;
end;

function SetBackDoorEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.backDoorState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetBackDoorEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.backDoorState);
end;

function SetBackDoorEvent:run(connection)   
	self.vehicle:toggleBackDoor(self.backDoorState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetBackDoorEvent:new(self.vehicle, self.backDoorState), nil, connection, self.vehicle);
    end;
end;

function SetBackDoorEvent.sendEvent(vehicle, backDoorState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetBackDoorEvent:new(vehicle, backDoorState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetBackDoorEvent:new(vehicle, backDoorState));
		end;
	end;
end;