
moveAttacherz = {};

function moveAttacherz.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function moveAttacherz:load(xmlFile)

	self.moveableAttacherz = {};
	self.moveableAttacherz.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.moveableAttacherz#index"));
	self.moveableAttacherz.max = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableAttacherz#maxZ"), 0); 
	self.moveableAttacherz.min = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableAttacherz#minZ"), 0); 
	
end;

function moveAttacherz:delete()
end;

function moveAttacherz:mouseEvent(posX, posZ, isDown, isUp, button)
end;

function moveAttacherz:keyEvent(unicode, sym, modifier, isDown)

end;

function moveAttacherz:update(dt)

	if self.moveableAttacherz ~= nil then
		local xAttacherz, yAttacherz, zAttacherz = getTranslation(self.moveableAttacherz.index);
		local maxZ = self.moveableAttacherz.max;
		local minZ = self.moveableAttacherz.min;
		local moveSpeed = 0.016;
			if InputBinding.isPressed(InputBinding.ATTACHER_UP1) and  InputBinding.isPressed(InputBinding.ACTIVATION) then
				if zAttacherz < maxZ then
					zAttacherz = zAttacherz + moveSpeed;
				else
					zAttacherz = maxZ;
				end;
			elseif InputBinding.isPressed(InputBinding.ATTACHER_DOWN1)  and InputBinding.isPressed(InputBinding.ACTIVATION) then
				if zAttacherz > minZ then
					zAttacherz = zAttacherz - moveSpeed;
				else
					zAttacherz = minZ;
				end;
			end;
		setTranslation(self.moveableAttacherz.index, xAttacherz, yAttacherz, zAttacherz);
	end;
				
end;

function moveAttacherz:onLeave()

end;

function moveAttacherz:draw()

end;

function moveAttacherz:validateAttacherzJoint(implement, jointDesc, dt)
    return true;
end;

