--
-- drawFill
-- Specialization for drawing Fill Level of a Trailer
--
-- @author  Hoschiander
-- @date  22/08/09
--

drawFill = {};

function drawFill.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function drawFill:load(xmlFile)

	if getXMLString(xmlFile, "vehicle.name.de") ~= nil then self.trailerName = getXMLString(xmlFile, "vehicle.name.de");
	elseif getXMLString(xmlFile, "vehicle.name")~= nil then self.trailerName = getXMLString(xmlFile, "vehicle.name");
	else self.trailerName = "UTO ;-)";
	end;
	self.graincapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.capacity"));
	self.keyTimes = 21;
	self.maxvertPos = 21;
	self.drawFillInfo = 1;
end;

function drawFill:delete()
end;

function drawFill:mouseEvent(posX, posY, isDown, isUp, button)
end;

function drawFill:keyEvent(unicode, sym, modifier, isDown)
    if isDown and sym == Input.KEY_pageup then
		self.displaytest= not self.displaytest;
		self.keyTimes = self.keyTimes + 1;
	end;
    if isDown and sym == Input.KEY_pagedown then
		self.keyTimes = self.keyTimes - 1;		
	end;
end;

function drawFill:update(dt)

--[[	if InputBinding.hasEvent(InputBinding.DRAWFILLUP) then
		self.displaytest= not self.displaytest;
		self.keyTimes = self.keyTimes + 1;
	end;
    if InputBinding.hasEvent(InputBinding.DRAWFILLDOWN) then
		self.keyTimes = self.keyTimes - 1;
	end;
]]--
	local procent = self.fillLevel/self.graincapacity*100;
			if self.keyTimes == 0 then
			self.vertPos = 0.02;
			elseif self.keyTimes == 1 then
			self.vertPos = 0.04;
			elseif self.keyTimes == 2 then
			self.vertPos = 0.06;
			elseif self.keyTimes == 3 then
			self.vertPos = 0.08;
			elseif self.keyTimes == 4 then
			self.vertPos = 0.1;
			elseif self.keyTimes == 5 then
			self.vertPos = 0.12;
			elseif self.keyTimes == 6 then
			self.vertPos = 0.14;
			elseif self.keyTimes == 7 then
			self.vertPos = 0.16;
			elseif self.keyTimes == 8 then
			self.vertPos = 0.18;
			elseif self.keyTimes == 9 then
			self.vertPos = 0.2;
			elseif self.keyTimes == 10 then
			self.vertPos = 0.22;
			elseif self.keyTimes == 11 then
			self.vertPos = 0.24;
			elseif self.keyTimes == 12 then
			self.vertPos = 0.26;
			elseif self.keyTimes == 13 then
			self.vertPos = 0.28;
			elseif self.keyTimes == 14 then
			self.vertPos = 0.3;
			elseif self.keyTimes == 15 then
			self.vertPos = 0.32;
			elseif self.keyTimes == 16 then
			self.vertPos = 0.34;
			elseif self.keyTimes == 17 then
			self.vertPos = 0.36;
			elseif self.keyTimes == 18 then
			self.vertPos = 0.38;
			elseif self.keyTimes == 19 then
			self.vertPos = 0.4;
			elseif self.keyTimes == 20 then
			self.vertPos = 0.42;
			elseif self.keyTimes > self.maxvertPos then
			self.keyTimes = 0;
			elseif self.keyTimes < 0 then
			self.keyTimes = self.maxvertPos;
			end;
	if self.fillLevel > 0 and self.keyTimes ~= self.maxvertPos then
		if procent < 80 then
		setTextColor(0, 1, 0, 1);
		elseif procent < 95 then
		setTextColor(1,1,0,1);
		else
		setTextColor(1, 0, 0, 1);
		end;
		renderText(0.02, self.vertPos, 0.015,""..string.format("Fllstand %s: %.0f (%d%%)", self.trailerName, self.fillLevel, procent).."");
	end;
end;


function drawFill:draw()
	if self.keyTimes ~= self.maxvertPos then
		setTextColor(1,1,1,1);
	    renderText(0.01, self.vertPos, 0.015,""..string.format("*").."");
	else
	    if self.attacherVehicle ~= nil then
			if self.attacherVehicle.showHudInfoBaseh then
				setTextColor(1, 1, 1, 1);
--	    renderText(0.02, 0, 0.02, "".. string.format("%s %s %s", g_i18n:getText("DrawFill"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.DRAWFILLUP), InputBinding.getKeyNamesOfDigitalAction(InputBinding.DRAWFILLDOWN)));
				renderText(0.02, 0, 0.015, "".. string.format("%s", g_i18n:getText("DrawFill")));
			end;
		end;
	end;
end;

