--
-- TerragatorHakenLiftObject NEW SCRIPT FOR LS2009
--
-- @Original-author Manuel L. (1.LS-Modschmiede)
-- @author Hoschiander (www.mein-ls.de)
-- @date 28/10/2009

TerragatorHakenLiftObject = {};

Vehicle.registerJointType("container");

function TerragatorHakenLiftObject.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function TerragatorHakenLiftObject:load(xmlFile)

	local switchTipCamera = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tipCamera#index"));
	if switchTipCamera ~= nil then
	    self.switchTipCamera = {};
	    self.switchTipCamera.basic = 0;
		self.switchTipCamera.tipping = false;
	    self.switchTipCamera.node = switchTipCamera;
	end;
	
	local rotateTipCamera = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotateTipCamera#index"));
	if rotateTipCamera ~= nil then
		self.rotateTipCamera = {};
		self.rotateTipCamera.node = rotateTipCamera;
		
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotateTipCamera#minRot"));
		self.rotateTipCamera.minRot = {};
		self.rotateTipCamera.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.rotateTipCamera.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.rotateTipCamera.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotateTipCamera#maxRot"));
		self.rotateTipCamera.maxRot = {};
		self.rotateTipCamera.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.rotateTipCamera.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.rotateTipCamera.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		
		self.rotateTipCamera.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotateTipCamera#rotTime"), 2)*1000;		
		
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotateTipCamera#minTrans"));
		self.rotateTipCamera.minTrans = {};
		self.rotateTipCamera.minTrans[1] = Utils.getNoNil(x, 0);
		self.rotateTipCamera.minTrans[2] = Utils.getNoNil(y, 0);
		self.rotateTipCamera.minTrans[3] = Utils.getNoNil(z, 0);
		
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotateTipCamera#maxTrans"));
		self.rotateTipCamera.maxTrans = {};
		self.rotateTipCamera.maxTrans[1] = Utils.getNoNil(x, 0);
		self.rotateTipCamera.maxTrans[2] = Utils.getNoNil(y, 0);
		self.rotateTipCamera.maxTrans[3] = Utils.getNoNil(z, 0);
		
		self.rotateTipCamera.transTime = self.rotateTipCamera.rotTime;
	end;
end;

function TerragatorHakenLiftObject:delete()
    Trailer.delete(self);
end;

function TerragatorHakenLiftObject:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TerragatorHakenLiftObject:keyEvent(unicode, sym, modifier, isDown)
end;

function TerragatorHakenLiftObject:update(dt)

	if self.rotateTipCamera ~= nil then
		local moveCam = self.rotateTipCamera;
		local trans = {getTranslation(moveCam.node)};
		local newTrans = Utils.getMovedLimitedValues(trans, moveCam.maxTrans, moveCam.minTrans, 3, moveCam.transTime, dt, self.switchTipCamera.tipping);
		setTranslation(moveCam.node, unpack(newTrans));
		
		local turnCam = self.rotateTipCamera;
		local rot = {getRotation(turnCam.node)};
		local newRot = Utils.getMovedLimitedValues(rot, turnCam.maxRot, turnCam.minRot, 3, turnCam.rotTime, dt, self.switchTipCamera.tipping);
		setRotation(turnCam.node, unpack(newRot));
	end;

end;

function TerragatorHakenLiftObject:draw()
end;


function TerragatorHakenLiftObject:onDetach()
end;


function TerragatorHakenLiftObject:toggleTipState()
end;

function TerragatorHakenLiftObject:onStartTip()
	if not self.attacherVehicle.workingPartArm.locked then
		self.attacherVehicle.rootPartArmturn = not self.attacherVehicle.rootPartArmturn;
		if self.switchTipCamera ~= nil then
			self.switchTipCamera.basic = self.attacherVehicle.attacherVehicle.tipCamera;
	        self.attacherVehicle.attacherVehicle.tipCamera = self.switchTipCamera.node;
			self.switchTipCamera.tipping = not self.switchTipCamera.tipping;
		end;
    end;
end;

function TerragatorHakenLiftObject:onEndTip()
	self.attacherVehicle.rootPartArmturn = not self.attacherVehicle.rootPartArmturn;
	if self.switchTipCamera ~= nil then
		self.attacherVehicle.attacherVehicle.tipCamera = self.switchTipCamera.basic;
		self.switchTipCamera.tipping = not self.switchTipCamera.tipping;
	end;
end;