Kuhn_FC_353GC = {};

function Kuhn_FC_353GC.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;
function Kuhn_FC_353GC:load(xmlFile)
	-- Animations and moving collisions --

	self.connectCollisions = SpecializationUtil.callSpecializationsFunction("connectCollisions");
	self.anim = SpecializationUtil.callSpecializationsFunction("anim");
	self.Go = {}; 
	self.Done = {};
	self.charId = {};
	self.clipIndex = {};
	self.CheckDone = {};
	self.moveColli = {}; 
    self.animParts = {};
	self.collisionArm = {};
	self.startpoint = {};
	self.loopCheck = {};
	self.Speed = {};
	local count = getXMLInt(xmlFile, "vehicle.animParts#count");
	local part = self.animParts;
    for i=1, count do
		part[i] = {};
        local partname = string.format("vehicle.animParts.part".."%d", i);
	    local nameR = getXMLString(xmlFile, partname.."#name");
		self.charId[nameR] = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#rootNode"));
		self.clipIndex[nameR] = getXMLString(xmlFile, partname.."#animationClip");
		self.CheckDone[nameR] = false;
		self.moveColli[nameR] = getXMLString(xmlFile, partname.."#moveColli");
		self.startpoint[nameR] = Utils.getNoNil(getXMLFloat(xmlFile, partname.."#startpoint"),0.0);
		if self.moveColli[nameR] ~= nil then
			local Collision = {};
			Collision.collision = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#collision"));
			Collision.collisionAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#collsionAttacher"));
			Collision.armAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.. "#armAttacher"));
			Collision.index = 0;
			self.collisionArm[nameR] = Collision;
			self:connectCollisions(nameR);
		end; 
		local charId = getAnimCharacterSet(self.charId[nameR]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[nameR]);
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackTime(charId, 0, self.startpoint[nameR]);
		enableAnimTrack(charId, 0);
		disableAnimTrack(charId, 0);
		self.loopCheck[nameR] = false;
		self.Speed[nameR] = 1.0;
	end;
		
	-- Animations Plateau --
    self.rotors = {};

    local psFile = getXMLString(xmlFile, "vehicle.rotors.rotor(1)#index");
    if psFile ~= nil then
        local i=0;
        while true do
            local baseName = string.format("vehicle.rotors.rotor(%d)", i);
            local node = {};
            node.index = getXMLString(xmlFile, baseName.. "#index");
            node.direction = getXMLInt(xmlFile, baseName.. "#direction");
            if node.index == nil then
                break;
            end;
            node.index = Utils.indexToObject(self.components, node.index);
            if node ~= nil then
                table.insert(self.rotors, node);
            end;
            i = i+1;
        end;
    end;
	
	-- Annimations Conditionneur --
	self.conditionneur= Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.conditionneur#index"));
    self.conditionneurRotationScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.conditionneur#rotationScale"), 1);
	
	-- Cutting Area --
    local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
    for i=1, numCuttingAreas do
        local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
        self.cuttingAreas[i].foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMinLimit"), 0);
        self.cuttingAreas[i].foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMaxLimit"), 1);
		self.cuttingAreas[i].grassParticleSystemIndex = getXMLInt(xmlFile, areanamei .. "#particleSystemIndex");
    end;
	
	-- Bache Cot --
	self.BacheCoteR = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.BacheCote#index1"));
	self.BacheCoteR2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.BacheCote#index2"));	
	self.BacheCoteD = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.BacheCote#index3"));
	self.BacheCoteD2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.BacheCote#index4"));	
	
	-- Particle systems --
	self.grassParticleSystems = {};
    local grassParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.grassParticleSystems#count"), 0);
    for i=1, grassParticleSystemCount do
        local namei = string.format("vehicle.grassParticleSystems.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.grassParticleSystems, namei, nodei, false, nil, self.baseDirectory)			
    end;
	self.strawParticleSystems = {};
    local strawParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.strawParticleSystems#count"), 0);
    for i=1, strawParticleSystemCount do
        local namei = string.format("vehicle.strawParticleSystems.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.strawParticleSystems, namei, nodei, false, nil, self.baseDirectory)			
    end;
	-- Bache --
	local rotationNodePartAV = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartAV#index"));
    if rotationNodePartAV ~= nil then
        self.rotationPartAV = {};
        self.rotationPartAV.node = rotationNodePartAV;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartAV#minRot"));
        self.rotationPartAV.minRot = {};
        self.rotationPartAV.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartAV.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartAV.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartAV#maxRot"));
        self.rotationPartAV.maxRot = {};
        self.rotationPartAV.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartAV.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartAV.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartAV.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartAV#rotTime"), 2)*1000;
        self.rotationPartAV.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartAV#touchRotLimit"), 10));
    end;  	

	local rotationNodePartAR = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartAR#index"));
    if rotationNodePartAR ~= nil then
        self.rotationPartAR = {};
        self.rotationPartAR.node = rotationNodePartAR;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartAR#minRot"));
        self.rotationPartAR.minRot = {};
        self.rotationPartAR.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartAR.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartAR.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartAR#maxRot"));
        self.rotationPartAR.maxRot = {};
        self.rotationPartAR.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartAR.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartAR.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartAR.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartAR#rotTime"), 2)*1000;
        self.rotationPartAR.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartAR#touchRotLimit"), 10));
    end; 	
	-- Son --
	local workSound = getXMLString(xmlFile, "vehicle.workSound#file");
    if workSound ~= nil and workSound ~= "" then
        workSound = Utils.getFilename(workSound, self.baseDirectory);
        self.workSound = createSample("workSound");
        self.workSoundEnabled = false;
        loadSample(self.workSound, workSound, false);
        self.workSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#pitchOffset"), 1);
        self.workSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#volume"), 1);
    end;
end;

function Kuhn_FC_353GC:delete()
	Utils.setEmittingState(self.grassParticleSystems, false)
	Utils.setEmittingState(self.strawParticleSystems, false)
	if self.workSoundEnabled then
		stopSample(self.workSound);
		self.workSoundEnabled = false;
	end;
end;

function Kuhn_FC_353GC:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Kuhn_FC_353GC:keyEvent(unicode, sym, modifier, isDown)
	if self.CheckDone.Transport then
		if isDown and sym == Input.KEY_l then
			self.Speed.rotChassis = 1.0; 
			self.Go.rotChassis = 2000.0;
			self.Done.rotChassis = true; 
		end;
		if isDown and sym == Input.KEY_k then
			self.Speed.rotChassis = 1.0; 
			self.Go.rotChassis = 4000.0;
			self.Done.rotChassis = true; 
		end;
		if isDown and sym == Input.KEY_j then
			self.Speed.rotChassis = 1.0; 
			self.Go.rotChassis = 6000.0;
			self.Done.rotChassis = true; 
		end;
	end;
	if isDown and sym == Input.KEY_v then
		self.Go.Lower = not self.Go.Lower;
		self.Done.Lower = true; 
	end;
	if isDown and sym == Input.KEY_o then
		self.Go.Transport = not self.Go.Transport;
		self.Done.Transport = true; 
		if self.Go.Transport then
			self.Speed.rotChassis = 1.0; 
			self.Go.rotChassis = 2000.0;
			self.Done.rotChassis = true; 
		else
			self.Speed.rotChassis = 1.0; 
			self.Go.rotChassis = 4000.0;
			self.Done.rotChassis = true; 
			self.Go.Lower = false;
		end;
	end;
end;

function Kuhn_FC_353GC:update(dt)
	if self.Go.rotChassis ~= nil and self.Done.rotChassis ~= false then
		self:anim("rotChassis"); 
	end;
	if self.Go.Lower ~= nil and self.Done.Lower ~= false then
		self:anim("Lower"); 
	end;
	if self.Go.Transport ~= nil and self.Done.Transport ~= false then
		self:anim("Transport"); 
	end;
	if self.Go.Support ~= nil and self.Done.Support ~= false then
		self:anim("Support"); 
	end;
	if self.Go.Transport then
		self.deplier = true;
	else
		self.deplier = false;
	end;
	if self.deplier then
		setVisibility(self.BacheCoteR, false);
		setVisibility(self.BacheCoteR2, false);
		setVisibility(self.BacheCoteD, true);
		setVisibility(self.BacheCoteD2, true);	
	else
		setVisibility(self.BacheCoteR, true);
		setVisibility(self.BacheCoteR2, true);
		setVisibility(self.BacheCoteD, false);
		setVisibility(self.BacheCoteD2, false);	
	end;	
	if self.Done.rotChassis then	
		local joint = self.componentJoints[2];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
		local joint = self.componentJoints[3];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
	end; 
	
    if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			self.isTurnedOn = not self.isTurnedOn;

		end;
	end;
	if self.isTurnedOn then
		if not self.workSoundEnabled and self:getIsActiveForSound() then
			playSample(self.workSound, 0, self.workSoundVolume, 0);
			setSamplePitch(self.workSound, self.workSoundPitchOffset);
			self.workSoundEnabled = true;
		end;
	else
		if self.workSoundEnabled then
			stopSample(self.workSound);
			self.workSoundEnabled = false;
		end;
	end;
	-- Animations Plateau --
    if self:getIsActive() then
		if self.isTurnedOn then
			for i=1, table.getn(self.rotors) do
				local rotor = self.rotors[i].index;
				local rotorRot = (-0.04*self.rotors[i].direction)*dt;
				rotate(rotor, 0, rotorRot, 0);
			end;
		end;
	end;
	-- Annimations Conditionneur --	
	if self.conditionneur ~= nil and self.isTurnedOn then
		rotate(self.conditionneur, self.conditionneurRotationScale * 3, 0, 0);
	end;
	
	-- Pour couper --
    if self:getIsActive() then
		if self.isTurnedOn and self.Go.Lower and self.Go.Transport then
			local x,y,z = getWorldTranslation(self.groundReferenceNode);
						
			local area = 0;
			local areaWheat = 0;
			local areaBarley = 0;
		
			for k, cuttingArea in pairs(self.cuttingAreas) do
				local x,y,z = getWorldTranslation(cuttingArea.start);
				local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
				local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
				
				if k == 1 then
					area = Utils.updateMeadowArea(x, z, x1, z1, x2, z2);
					areaWheat = Utils.cutFruitArea(FruitUtil.FRUITTYPE_WHEAT, x, z, x1, z1, x2, z2);
					areaBarley = Utils.cutFruitArea(FruitUtil.FRUITTYPE_BARLEY, x, z, x1, z1, x2, z2);
					
					if self.attacherVehicle.movingDirection ~= -1 then
						area = area + Utils.updateFruitCutLongArea(FruitUtil.FRUITTYPE_GRASS, x, z, x1, z1, x2, z2, 0);
					else
						if areaWheat > 0 then	
							local old, total = Utils.getFruitWindrowArea(FruitUtil.FRUITTYPE_WHEAT, x, z, x1, z1, x2, z2);
							local value = 1+math.floor(old / total + 0.7);
							value = math.min(value, g_currentMission.maxWindrowValue);
							Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_WHEAT, x, z, x1, z1, x2, z2, value, true);
						end;
						
						if areaBarley > 0 then
							local old, total = Utils.getFruitWindrowArea(FruitUtil.FRUITTYPE_BARLEY, x, z, x1, z1, x2, z2);
							local value = 1+math.floor(old / total + 0.7);
							value = math.min(value, g_currentMission.maxWindrowValue);
							Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_BARLEY, x, z, x1, z1, x2, z2, value, true);
						end;
					end;
					if area > 0 then
						Utils.setEmittingState(self.grassParticleSystems, true)	
						Utils.setEmittingState(self.strawParticleSystems, false)	
						if not self.attacherVehicle.movingDirection ~= 1 then
							if self.rotationPartAV ~= nil then
								local x, y, z = getRotation(self.rotationPartAV.node);
								y = ((self.rotationPartAV.maxRot[2] - self.rotationPartAV.minRot[2]) / 35) * (self.lastSpeed*3600) + self.rotationPartAV.minRot[2];
								setRotation(self.rotationPartAV.node, x, y ,z);
							end;
							if self.rotationPartAR ~= nil then
								local x, y, z = getRotation(self.rotationPartAR.node);
								y = ((self.rotationPartAR.maxRot[2] - self.rotationPartAR.minRot[2]) / 35) * (self.lastSpeed*3600) + self.rotationPartAR.minRot[2];
								setRotation(self.rotationPartAR.node, x, y ,z);
							end;	
						end;	
					elseif areaWheat > 0 or areaBarley > 0 then
						Utils.setEmittingState(self.grassParticleSystems, false)
						Utils.setEmittingState(self.strawParticleSystems, true)	
						if not self.attacherVehicle.movingDirection ~= 1 then
							if self.rotationPartAV ~= nil then
								local x, y, z = getRotation(self.rotationPartAV.node);
								y = ((self.rotationPartAV.maxRot[2] - self.rotationPartAV.minRot[2]) / 35) * (self.lastSpeed*3600) + self.rotationPartAV.minRot[2];
								setRotation(self.rotationPartAV.node, x, y ,z);
							end;
							if self.rotationPartAR ~= nil then
								local x, y, z = getRotation(self.rotationPartAR.node);
								y = ((self.rotationPartAR.maxRot[2] - self.rotationPartAR.minRot[2]) / 35) * (self.lastSpeed*3600) + self.rotationPartAR.minRot[2];
								setRotation(self.rotationPartAR.node, x, y ,z);
							end;
						end;
					else
						Utils.setEmittingState(self.grassParticleSystems, false)
						Utils.setEmittingState(self.strawParticleSystems, false)
						if not self.attacherVehicle.movingDirection ~= 1 then
							if self.rotationPartAV ~= nil then
								local x, y, z = getRotation(self.rotationPartAV.node);
								y = ((self.rotationPartAV.maxRot[2] - self.rotationPartAV.minRot[2]) / 35) * (self.lastSpeed*3600) + self.rotationPartAV.minRot[2];
								setRotation(self.rotationPartAV.node, x, y ,z);
							end;
							if self.rotationPartAR ~= nil then
								local x, y, z = getRotation(self.rotationPartAR.node);
								y = ((self.rotationPartAR.maxRot[2] - self.rotationPartAR.minRot[2]) / 35) * (self.lastSpeed*3600) + self.rotationPartAR.minRot[2];
								setRotation(self.rotationPartAR.node, x, y ,z);
							end;
						end;
					end;
				else
					if self.attacherVehicle.movingDirection ~= -1 then
						if area > 0 then
							local old, total = Utils.getFruitCutLongArea(FruitUtil.FRUITTYPE_DRYGRASS, x, z, x1, z1, x2, z2);							
							local value = 1+math.floor(old / total + 0.7);
							value = math.min(value, g_currentMission.maxWindrowValue);
							Utils.updateFruitCutLongArea(FruitUtil.FRUITTYPE_GRASS, x, z, x1, z1, x2, z2, value, true);	
						end;
						
						if areaWheat > 0 then							
							local old, total = Utils.getFruitWindrowArea(FruitUtil.FRUITTYPE_WHEAT, x, z, x1, z1, x2, z2);
							local value = 1+math.floor(old / total + 0.7);
							value = math.min(value, g_currentMission.maxWindrowValue);
							Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_WHEAT, x, z, x1, z1, x2, z2, value, true);	
						end;
						
						if areaBarley > 0 then
							local old, total = Utils.getFruitWindrowArea(FruitUtil.FRUITTYPE_BARLEY, x, z, x1, z1, x2, z2);
							local value = 1+math.floor(old / total + 0.7);
							value = math.min(value, g_currentMission.maxWindrowValue);
							Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_BARLEY, x, z, x1, z1, x2, z2, value, true);
						end;
					end;							
				end;
            end;
		else
			Utils.setEmittingState(self.grassParticleSystems, false)
			Utils.setEmittingState(self.strawParticleSystems, false)
			if not self.attacherVehicle.movingDirection ~= 1 then
				if self.rotationPartAV ~= nil then
					local x, y, z = getRotation(self.rotationPartAV.node);
					y = ((self.rotationPartAV.maxRot[2] - self.rotationPartAV.minRot[2]) / 75) * (self.lastSpeed*3600) + self.rotationPartAV.minRot[2];
					setRotation(self.rotationPartAV.node, x, y ,z);
				end;
				if self.rotationPartAR ~= nil then
					local x, y, z = getRotation(self.rotationPartAR.node);
					y = ((self.rotationPartAR.maxRot[2] - self.rotationPartAR.minRot[2]) / 100) * (self.lastSpeed*3600) + self.rotationPartAR.minRot[2];
					setRotation(self.rotationPartAR.node, x, y ,z);
				end;
			end;
		end;
	end;
end;

function Kuhn_FC_353GC:draw()
	if self.Go.Transport then 
		g_currentMission:addExtraPrintText("Touche O: Transport Postion");
		g_currentMission:addExtraPrintText("Touche J/K/L: Mover Left/Behind/Right");
		if self.Go.Lower then
			g_currentMission:addExtraPrintText("Touche V: Lift cutter");
		else
			g_currentMission:addExtraPrintText("Touche V: Lower cutter");
		end;
		if self.isTurnedOn then
			g_currentMission:addExtraPrintText("Touche B: Turn off mover");
		else
			g_currentMission:addExtraPrintText("Touche B: Turn on mover");
		end;
	else
		g_currentMission:addExtraPrintText("Touche O: Work Position");	
	end;
end;

function Kuhn_FC_353GC:onDetach()
	self.Go.Support = false;
	self.Done.Support = true;
	if self.workSoundEnabled then
		stopSample(self.workSound);
		self.workSoundEnabled = false;
	end;
end;

function Kuhn_FC_353GC:onAttach()
	self.Go.Support = true;
	self.Done.Support = true;
end;

function Kuhn_FC_353GC:anim(varName, loopCheck)
	if self.moveColli[varName] ~= nil then
		local Collision = self.collisionArm[varName];
		setJointFrame(Collision.index, 0, Collision.armAttacher);
	end;
	local loopCheck = self.loopCheck[varName];
	local speed = Utils.getNoNil(self.Speed[varName],1);
	local offset = 10;  
	local charId = getAnimCharacterSet(self.charId[varName]);
	local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
	if self.Done[varName] ~= false then
		if self.Go[varName] == true then
			assignAnimTrackClip(charId , 0, clipIndex);
			setAnimTrackLoopState(charId, 0, loopCheck);
			setAnimTrackSpeedScale(charId, 0, speed);
			enableAnimTrack(charId, 0);
			if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) and loopCheck == false then
				self.Done[varName] = false;	
				self.CheckDone[varName] = self.Go[varName];	
			end;
			if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) and loopCheck then
				local setTime = getAnimClipDuration(charId, clipIndex) - getAnimClipDuration(charId, clipIndex);
				setAnimTrackTime(charId, 0, setTime);
			end;
		elseif self.Go[varName] == false then
			if loopCheck == true then
				self.Done[varName] = false;	
			else
				assignAnimTrackClip(charId , 0, clipIndex);
				setAnimTrackLoopState(charId, 0, loopCheck);
				setAnimTrackSpeedScale(charId, 0, -speed);
				enableAnimTrack(charId, 0);
				if getAnimTrackTime(charId, 0) <= 0 then
					self.Done[varName] = false;	
					self.CheckDone[varName] = self.Go[varName];
				end;
			end;
		elseif self.Go[varName] ~= nil then
			assignAnimTrackClip(charId , 0, clipIndex);
			setAnimTrackLoopState(charId, 0, loopCheck);
			if self.Go[varName] < 0.0 then
				self.Go[varName] = 0.0;
			elseif self.Go[varName] > getAnimClipDuration(charId, clipIndex) then
				self.Go[varName] = getAnimClipDuration(charId, clipIndex);
			end;
			if getAnimTrackTime(charId, 0) >= self.Go[varName] then
				setAnimTrackSpeedScale(charId, 0, -speed);
			else
				setAnimTrackSpeedScale(charId, 0, speed);
			end;
			enableAnimTrack(charId, 0);
			if getAnimTrackTime(charId, 0) <= self.Go[varName] + offset and getAnimTrackTime(charId, 0) >= self.Go[varName] - offset then
				self.Done[varName] = false;	
				self.CheckDone[varName] = self.Go[varName];
			end;
		end;
	end;
	if self.Done[varName] == false then
		disableAnimTrack(charId, 0);
	end;
end; 

function Kuhn_FC_353GC:connectCollisions(varName)
	local Collision = self.collisionArm[varName];
	local constr = JointConstructor:new();
	constr:setActors(self.rootNode, Collision.collision);
	constr:setJointTransforms(Collision.armAttacher, Collision.collisionAttacher);
	for i=1, 3 do		            
		constr:setRotationLimit(i-1, 0, 0, 0);
		constr:setTranslationLimit(i-1, true, 0, 0);
	end;
	Collision.index = constr:finalize();
end;