--
-- Specialization for farmer car mod
--
-- @author  Stefan Geiger
-- @date  10/01/09
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
--
-- Specialization for LADA VAZ 2107 mod
--
-- @autor SpeedySC1978
-- @update 04/08/09
--
-- Copyright (C) of all Scripter, here an excerpt of their lines of code can be found
--

LADA = {};

function LADA.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function LADA:load(xmlFile)
--[[Blinker start]]--
	turn1SoundFile = Utils.getFilename("sounds/turn1.wav", self.baseDirectory);
    self.turn1 = createSample("turn1");
    loadSample(self.turn1, turn1SoundFile, false);
	turn2SoundFile = Utils.getFilename("sounds/turn2.wav", self.baseDirectory);
    self.turn2 = createSample("turn2");
    loadSample(self.turn2, turn2SoundFile, false);	
    self.numTurnlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights#count"), 0);
    self.turnlights = {};
    for i=1, self.numTurnlights do
        local turnlightnamei = string.format("vehicle.turnlights.turnlight" .. "%d", i);
        self.turnlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei .. "#index"));
        setVisibility(self.turnlights[i], false);
    end;	
	self.turnlightsActive = false;
    self.numTurnlights2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights2#count"), 0);
    self.turnlights2 = {};
    for i=1, self.numTurnlights2 do
        local turnlightnamei2 = string.format("vehicle.turnlights2.turnlight" .. "%d", i);
        self.turnlights2[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei2 .. "#index"));
        setVisibility(self.turnlights2[i], false);
    end;	
	self.turnlightsActive2 = false;	
--[[Blinker ende]]--
--[[Rckfahrlicht start]]--
    self.numBacklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.backlights#count"), 0);
    self.backlights= {};
    for i=1, self.numBacklights do
        local backlightnamei = string.format("vehicle.backlights.backlight" .. "%d", i);
        self.backlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, backlightnamei .. "#index"));
        setVisibility(self.backlights[i], false);
    end;	
	self.backlightsActive = false;	
--[[Rckfahrlicht ende]]--
--[[Nebelleuchte start]]--
    self.numFoglights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.foglights#count"), 0);
    self.foglights = {};
    for i=1, self.numFoglights do
        local foglightnamei = string.format("vehicle.foglights.foglight" .. "%d", i);
        self.foglights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, foglightnamei .. "#index"));
        setVisibility(self.foglights[i], false);
    end;	
	self.foglightsActive = false;	
--[[Nebelleuchte ende]]--
--[[Bremslicht start]]--
	self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;
	self.brakelightsActive = false;
    self.braking = false;	
--[[Bremslicht ende]]--
--[[Fernlicht start]]--
	self.extra_lights = {};
    self.extra_lights.far = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.extra_lights.far#index"));
    self.farlightActive = false;	
--[[Fernlicht ende]]--
--[[Radio start]]--
    self.radioCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.radio#count"),0);
	self.radioVolume = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.radio#volume"),0);
    self.radioOn = false;
    self.radio = {};
	self.currentSong = 1;
    for i=1, self.radioCount do
        local objname = string.format("vehicle.radio.song" .. "%d",i);
        self.radio[i] = {};
        local filename = Utils.getFilename(getXMLString(xmlFile, objname .. "#filename"),self.baseDirectory);
		self.radio[i].song = createSample(string.format("track" .. "%d",i));
		loadSample(self.radio[i].song, filename, false);
    end;
	self.songPlayed = false;
--[[Radio ende]]--
--[[Motorstart start]]--
    self.ignitionKey = false;
	self.allowedIgnition = false;                                                  
    self.motorStopSoundVolume2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#volume"), 1.0);	
--[[Motorstart ende]]--
--[[Doors start]]--
    local rotationPartNodeLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft#index"));
    if rotationPartNodeLeft ~= nil then
        self.rotationPartLeft = {};
        self.rotationPartLeft.node = rotationPartNodeLeft;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#minRot"));
        self.rotationPartLeft.minRot = {};
        self.rotationPartLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#maxRot"));
        self.rotationPartLeft.maxRot = {};
        self.rotationPartLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotationPartLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#rotTime"), 2)*1000;
        self.rotationPartLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#touchRotLimit"), 10));
    end;
    local rotationPartNodeLeft2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft2#index"));
    if rotationPartNodeLeft2 ~= nil then
        self.rotationPartLeft2 = {};
        self.rotationPartLeft2.node = rotationPartNodeLeft2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft2#minRot"));
        self.rotationPartLeft2.minRot = {};
        self.rotationPartLeft2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft2#maxRot"));
        self.rotationPartLeft2.maxRot = {};
        self.rotationPartLeft2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotationPartLeft2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft2#rotTime"), 2)*1000;
        self.rotationPartLeft2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft2#touchRotLimit"), 10));
    end;
    local rotationPartNodeLeft3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft3#index"));
    if rotationPartNodeLeft3 ~= nil then
        self.rotationPartLeft3 = {};
        self.rotationPartLeft3.node = rotationPartNodeLeft3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft3#minRot"));
        self.rotationPartLeft3.minRot = {};
        self.rotationPartLeft3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft3#maxRot"));
        self.rotationPartLeft3.maxRot = {};
        self.rotationPartLeft3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotationPartLeft3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft3#rotTime"), 2)*1000;
        self.rotationPartLeft3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft3#touchRotLimit"), 10));
    end;
    local rotationPartNodeLeft4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft4#index"));
    if rotationPartNodeLeft4 ~= nil then
        self.rotationPartLeft4 = {};
        self.rotationPartLeft4.node = rotationPartNodeLeft4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft4#minRot"));
        self.rotationPartLeft4.minRot = {};
        self.rotationPartLeft4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft4#maxRot"));
        self.rotationPartLeft4.maxRot = {};
        self.rotationPartLeft4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotationPartLeft4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft4#rotTime"), 2)*1000;
        self.rotationPartLeft4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft4#touchRotLimit"), 10));
    end;
    local rotationPartNodeLeft5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft5#index"));
    if rotationPartNodeLeft5 ~= nil then
        self.rotationPartLeft5 = {};
        self.rotationPartLeft5.node = rotationPartNodeLeft5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft5#minRot"));
        self.rotationPartLeft5.minRot = {};
        self.rotationPartLeft5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft5#maxRot"));
        self.rotationPartLeft5.maxRot = {};
        self.rotationPartLeft5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotationPartLeft5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft5#rotTime"), 2)*1000;
        self.rotationPartLeft5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft5#touchRotLimit"), 10));
    end;
    local rotationPartNodeLeft6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft6#index"));
    if rotationPartNodeLeft6 ~= nil then
        self.rotationPartLeft6 = {};
        self.rotationPartLeft6.node = rotationPartNodeLeft6;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft6#minRot"));
        self.rotationPartLeft6.minRot = {};
        self.rotationPartLeft6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft6#maxRot"));
        self.rotationPartLeft6.maxRot = {};
        self.rotationPartLeft6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotationPartLeft6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft6#rotTime"), 2)*1000;
        self.rotationPartLeft6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft6#touchRotLimit"), 10));
    end;
--[[Doors ende]]--	
--[[Windows start]]--
	local translationPartNodeRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartRight#index"));
    if translationPartNodeRight ~= nil then
        self.translationPartRight = {};
        self.translationPartRight.node = translationPartNodeRight;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartRight#minTrans"));
        self.translationPartRight.minTrans = {};
        self.translationPartRight.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartRight.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartRight.minTrans[3] = Utils.getNoNil(z, 0);
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartRight#maxTrans"));
        self.translationPartRight.maxTrans = {};
        self.translationPartRight.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartRight.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartRight.maxTrans[3] = Utils.getNoNil(z, 0);
        self.translationPartRight.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartRight#transTime"), 2)*1000;
        self.translationPartRight.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartRight#touchTransLimit"), 10);
    end;
	local translationPartNodeRight2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartRight2#index"));
    if translationPartNodeRight2 ~= nil then
        self.translationPartRight2 = {};
        self.translationPartRight2.node = translationPartNodeRight2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartRight2#minTrans"));
        self.translationPartRight2.minTrans = {};
        self.translationPartRight2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartRight2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartRight2.minTrans[3] = Utils.getNoNil(z, 0);
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartRight2#maxTrans"));
        self.translationPartRight2.maxTrans = {};
        self.translationPartRight2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartRight2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartRight2.maxTrans[3] = Utils.getNoNil(z, 0);
        self.translationPartRight2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartRight2#transTime"), 2)*1000;
        self.translationPartRight2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartRight2#touchTransLimit"), 10);
    end;
	local translationPartNodeRight3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartRight3#index"));
    if translationPartNodeRight3 ~= nil then
        self.translationPartRight3 = {};
        self.translationPartRight3.node = translationPartNodeRight3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartRight3#minTrans"));
        self.translationPartRight3.minTrans = {};
        self.translationPartRight3.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartRight3.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartRight3.minTrans[3] = Utils.getNoNil(z, 0);
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartRight3#maxTrans"));
        self.translationPartRight3.maxTrans = {};
        self.translationPartRight3.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartRight3.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartRight3.maxTrans[3] = Utils.getNoNil(z, 0);
        self.translationPartRight3.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartRight3#transTime"), 2)*1000;
        self.translationPartRight3.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartRight3#touchTransLimit"), 10);
    end;
	local translationPartNodeRight4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartRight4#index"));
    if translationPartNodeRight4 ~= nil then
        self.translationPartRight4 = {};
        self.translationPartRight4.node = translationPartNodeRight4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartRight4#minTrans"));
        self.translationPartRight4.minTrans = {};
        self.translationPartRight4.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartRight4.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartRight4.minTrans[3] = Utils.getNoNil(z, 0);
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartRight4#maxTrans"));
        self.translationPartRight4.maxTrans = {};
        self.translationPartRight4.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartRight4.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartRight4.maxTrans[3] = Utils.getNoNil(z, 0);
        self.translationPartRight4.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartRight4#transTime"), 2)*1000;
        self.translationPartRight4.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartRight4#touchTransLimit"), 10);
    end;
--[[Windows ende]]--	

	self.controlpath = Utils.getFilename("textures/LADAHUD.png", self.baseDirectory);
    self.hudLADAWidth = 0.300;
    self.hudLADAHeight = 0.400;
	self.hudLADAPoxX = 0.700;
    self.hudLADAPoxY = 0.350;
    self.hudLADAOverlay = Overlay:new("hudLADAControl", self.controlpath, self.hudLADAPoxX, self.hudLADAPoxY, self.hudLADAWidth, self.hudLADAHeight);
	
    hornSoundFile = Utils.getFilename("sounds/horn.wav", self.baseDirectory);
    self.hornSoundId = createSample("famerCarSound");
    loadSample(self.hornSoundId, hornSoundFile, false);
    self.hornPlaying = false;
	
    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;	
end;

function LADA:delete()
    delete(self.hornSoundId);
end;

function LADA:mouseEvent(posX, posY, isDown, isUp, button)
end;

function LADA:keyEvent(unicode, sym, modifier, isDown)
--[[Fernlicht start]]--
	if InputBinding.isPressed(InputBinding.LADA_FARLIGHT) then	
		self.farlightActive = not self.farlightActive;
		setVisibility(self.extra_lights.far, self.farlightActive);
	end;
--[[Fernlicht ende]]--	
--[[Nebelleuchte start]]--
	if self.isMotorStarted then
		if InputBinding.isPressed(InputBinding.LADA_FOGLIGHT) then
			self.foglightsActive = not self.foglightsActive;
		end;
		if isDown and sym == Input.KEY_KP_enter then
			self.foglightsActive = false;
		end;		
	end;
--[[Nebelleuchte ende]]--	
----[[Blinker start]]----
--[[Blinker Rechts]]--
	if self.isMotorStarted then
		if InputBinding.isPressed(InputBinding.LADA_t_RIGHT) then
			self.flashLeft = not self.flashLeft;
			self.delayOnLeft = 10;
			self.flashRight = false;
			self.flash = false;
			self.flashlightsRightActive = false;
			self.flashlightsWarnerActive = false;
			self.flashlightsRight2Active = false;
			self.turnlightsActive2 = false;
			self.flashWarner = false;
		end;
	end;
--[[Warnblinker]]--
	if InputBinding.isPressed(InputBinding.LADA_FLASH) then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
		self.flashWarner = not self.flashWarner;
	end;
--[[Blinker Links]]--
	if self.isMotorStarted then
		if InputBinding.isPressed(InputBinding.LADA_t_LEFT) then
			self.flashRight = not self.flashRight;
			self.delayOnRight = 10;
			self.flashLeft = false;
			self.flash = false;
			self.flashlightsLeftActive = false;
			self.flashlightsWarnerActive = false;
			self.flashlightsLeft2Active = false;
			self.turnlightsActive = false;
			self.flashWarner = false;
		end;
	end;	
----[[Blinker ende]]----
--[[Doors start]]--
    if InputBinding.isPressed(InputBinding.DOOR_HL) then
		self.rotationMaxLeft = not self.rotationMaxLeft;
	end;
    if InputBinding.isPressed(InputBinding.DOOR_VL) then
		self.rotationMaxLeft2 = not self.rotationMaxLeft2;
	end;
    if InputBinding.isPressed(InputBinding.DOOR_HR) then
		self.rotationMaxLeft3 = not self.rotationMaxLeft3;
	end;
    if InputBinding.isPressed(InputBinding.DOOR_VR) then
		self.rotationMaxLeft4 = not self.rotationMaxLeft4;
	end;
    if InputBinding.isPressed(InputBinding.BACKDOOR) then
		self.rotationMaxLeft5 = not self.rotationMaxLeft5;
	end;
    if InputBinding.isPressed(InputBinding.FRONTDOOR) then
		self.rotationMaxLeft6 = not self.rotationMaxLeft6;
	end;
--[[Doors ende]]--
--[[Windows start]]--	
    if InputBinding.isPressed(InputBinding.WINDOW_HL) then
		self.translationMaxRight = not self.translationMaxRight;
	end;
    if InputBinding.isPressed(InputBinding.WINDOW_VL) then
		self.translationMaxRight2 = not self.translationMaxRight2;
	end;
    if InputBinding.isPressed(InputBinding.WINDOW_HR) then
		self.translationMaxRight3 = not self.translationMaxRight3;
	end;
    if InputBinding.isPressed(InputBinding.WINDOW_VR) then
		self.translationMaxRight4 = not self.translationMaxRight4;
	end;	
--[[Windows ende]]--	
    if isDown and sym == Input.KEY_KP_5 then
		self.rotationMaxLeft = false;
		self.rotationMaxLeft2 = false;
		self.rotationMaxLeft3 = false;	
		self.rotationMaxLeft4 = false;
		self.rotationMaxLeft5 = false;	
		self.rotationMaxLeft6 = false;
		self.translationMaxRight = false;	
		self.translationMaxRight2 = false;	
		self.translationMaxRight3 = false;	
		self.translationMaxRight4 = false;			
	end;
--[[Radio start]]--	
	if isDown and sym == Input.KEY_f5 then
		self.radioOn = not self.radioOn;
	end;
	if isDown and sym == Input.KEY_f6 then
		stopSample(self.radio[self.currentSong].song);
		self.songPlayed = false;
		if self.currentSong >= self.radioCount then
			self.currentSong = 1;
		else
			self.currentSong = self.currentSong + 1;
		end;
	end;
	if isDown and sym == Input.KEY_f7 then
		stopSample(self.radio[self.currentSong].song);
		self.songPlayed = false;
		if self.currentSong <= 1 then
			self.currentSong = self.radioCount;
		else
			self.currentSong = self.currentSong - 1;
		end;
	end;
--[[Radio ende]]--
--[[Hilfeanzeige start]]--
    if isDown and sym == Input.KEY_0 then
		self.helpPanel = not self.helpPanel;
	end;
--[[Hilfeanzeige ende]]--
end;

function LADA:update(dt)
    if self:getIsActiveForInput() and self:getIsActiveForSound() and InputBinding.isPressed(InputBinding.LADA_HORN) then
        if not self.hornPlaying then
            playSample(self.hornSoundId, 0, 1, 0);
            self.hornPlaying = true;
        end;
    else
        if self.hornPlaying then
            stopSample(self.hornSoundId);
            self.hornPlaying = false;
        end;
    end;
--[[Motorstart start]]--
    if not self.isAITractorActivated then
        if self:getIsActiveForInput() then
            if InputBinding.hasEvent(InputBinding.IGNITION) then
		        self.ignitionKey = not self.ignitionKey;
			    self.allowedIgnition = true;
	        end;
	    end;
	    if not self.allowedIgnition and  not self.ignitionKey then
            self.isMotorStarted = false;
            Motorized.stopSounds(self);
	        self.steeringEnabled = false;
            Utils.setEmittingState(self.exhaustParticleSystems, false)
	    end;
	    if not self.ignitionKey then
	        self.motorStopSoundVolume = 0;
        else
	        self.motorStopSoundVolume = self.motorStopSoundVolume2;
	    end;
	    if self.allowedIgnition then
	        if  not self.ignitionKey then
		        self.motorStopSoundVolume = self.motorStopSoundVolume2;
                self:stopMotor();
			    self.steeringEnabled = false;
                self.allowedIgnition = false;
	            for k,wheel in pairs(self.wheels) do
                    setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
                end;
                self:onDeactivateAttachements();
	        elseif self.ignitionKey then
                self:startMotor();
                self.steeringEnabled = true;
                self.allowedIgnition = false;
       	    end;
	    end;
    elseif not self.ignitionKey and not self.deactivateOnLeave then
		self:stopAITractor();
	end;
--[[Motorstart ende]]--
--[[Radio start]]--
	if self.radioVolume <= 0 then
		self.radioVolume = 0.1;
	end;
	if self.radioOn then
		if not self.songPlayed then
			playSample(self.radio[self.currentSong].song, 1, self.radioVolume, 0);
			self.songKoniec = self.time + getSampleDuration(self.radio[self.currentSong].song);
			self.songPlayed = true;
		end;
		if self.time >= self.songKoniec then
			if self.currentSong == self.radioCount then
				self.currentSong = 1;
			else
				self.currentSong = self.currentSong + 1;
			end;
			self.songPlayed = false;
		end;
	else
		if self.songPlayed then
			stopSample(self.radio[self.currentSong].song, 0, 1, 0);
			self.songPlayed = false;
		end;
	end;
--[[Radio ende]]--	
--[[Blinker start]]--
	if self.flash then
		if self.delayOn >= 0 then
			self.delayOn = self.delayOn -dt;
		end;
		if not self.flashlightsRightActive then
			if self.delayOn < 0 then
				self.delayOff = 500;
				self.flashlightsRightActive = true;
				self.flashlightsLeftActive = true;
				self.flashlightsWarnerActive = true;
				self.turnlightsActive2 = true;
				self.turnlightsActive = true;
				playSample(self.turn1, 1, 0.7, 0);
			end;
		end;
		if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOff < 0 then
				self.delayOn = 500;
				self.flashlightsLeftActive = false;
				self.flashlightsRightActive = false;
				self.flashlightsWarnerActive = false;
				self.turnlightsActive2 = false;
				self.turnlightsActive = false;
				playSample(self.turn2, 1, 0.7, 0);
			end;
		end;
	end;
		if self.flashRight then
			if self.delayOnRight >= 0 then
				self.delayOnRight = self.delayOnRight -dt;
			end;
			if not self.flashlightsRightActive then
				if self.delayOnRight < 0 then
					self.delayOffRight = 500;
					self.flashlightsRightActive = true;
					self.turnlightsActive2 = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffRight >= 0 then
				self.delayOffRight = self.delayOffRight -dt;
			end;
			if self.flashlightsRightActive then
				if self.delayOffRight < 0 then
					self.delayOnRight = 500;
					self.flashlightsRightActive = false;
					self.turnlightsActive2 = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.turnlightsActive2 = false;
			end;
		end;
	
		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					self.turnlightsActive = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					self.turnlightsActive = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.turnlightsActive = false;
			end;
		end;
		if self.turnlightsActive then
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive);
			end;
		else
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive, false);
			end;
		end;
		if self.turnlightsActive2 then
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2);
			end;
		else
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2, false);
			end;
		end;
--[[Blinker ende]]--
--[[Rckfahrlicht start]]--
	if not self.reverseLight then
		if self.movingDirection < 0 then
			self.backlightsActive = true;
		else
			self.backlightsActive = false;
		end;
	end;
	if self.backlightsActive then
		for i=1, self.numBacklights do
			local backlight = self.backlights[i];
			setVisibility(backlight, self.backlightsActive);
		end;
	else
		for i=1, self.numBacklights do
			local backlight = self.backlights[i];
			setVisibility(backlight, self.backlightsActive, false);
		end;
	end;
--[[Rckfahrlicht ende]]--
--[[Nebelleuchte start]]--
	if self.isMotorStarted then
		if self.foglightsActive then
			for i=1, self.numFoglights do
				local foglight = self.foglights[i];
				setVisibility(foglight, self.foglightsActive);
			end;
		else
			for i=1, self.numFoglights do
				local foglight = self.foglights[i];
				setVisibility(foglight, self.foglightsActive, false);
			end;
		end;
	end;	
--[[Nebelleuchte ende]]--
--[[Bremslicht start]]--
    inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);	
    if InputBinding.isAxisZero(inputAxisY) then
        inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
    end;
	if self.isEntered ~= nil then
		if self.brakelightsActive then
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive);
			end;
		else
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive, false);
			end;
		end;
		if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then		
			self.brakelightsActive = true;
			self.braking = true;
		else
			self.brakelightsActive = false;
			self.braking = false;
		end;	
	end;
--[[Bremslicht ende]]--
--[[Doors start]]--
    if self.isMotorStarted then
		self.rotationMaxLeft = false;
		self.rotationMaxLeft2 = false;
		self.rotationMaxLeft3 = false;	
		self.rotationMaxLeft4 = false;
		self.rotationMaxLeft5 = false;
		self.rotationMaxLeft6 = false;
	end;
	if self.rotationPartLeft ~= nil then
		local x, y, z = getRotation(self.rotationPartLeft.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft.maxRot, self.rotationPartLeft.minRot, 3, self.rotationPartLeft.rotTime, dt, not self.rotationMaxLeft);
		setRotation(self.rotationPartLeft.node, unpack(newRot));
	end;
	if self.rotationPartLeft2 ~= nil then
		local x, y, z = getRotation(self.rotationPartLeft2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft2.maxRot, self.rotationPartLeft2.minRot, 3, self.rotationPartLeft2.rotTime, dt, not self.rotationMaxLeft2);
		setRotation(self.rotationPartLeft2.node, unpack(newRot));
	end;
	if self.rotationPartLeft3 ~= nil then
		local x, y, z = getRotation(self.rotationPartLeft3.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft3.maxRot, self.rotationPartLeft3.minRot, 3, self.rotationPartLeft3.rotTime, dt, not self.rotationMaxLeft3);
		setRotation(self.rotationPartLeft3.node, unpack(newRot));
	end;
	if self.rotationPartLeft4 ~= nil then
		local x, y, z = getRotation(self.rotationPartLeft4.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft4.maxRot, self.rotationPartLeft4.minRot, 3, self.rotationPartLeft4.rotTime, dt, not self.rotationMaxLeft4);
		setRotation(self.rotationPartLeft4.node, unpack(newRot));
	end;
	if self.rotationPartLeft5 ~= nil then
		local x, y, z = getRotation(self.rotationPartLeft5.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft5.maxRot, self.rotationPartLeft5.minRot, 3, self.rotationPartLeft5.rotTime, dt, not self.rotationMaxLeft5);
		setRotation(self.rotationPartLeft5.node, unpack(newRot));
	end;
	if self.rotationPartLeft6 ~= nil then
		local x, y, z = getRotation(self.rotationPartLeft6.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft6.maxRot, self.rotationPartLeft6.minRot, 3, self.rotationPartLeft6.rotTime, dt, not self.rotationMaxLeft6);
		setRotation(self.rotationPartLeft6.node, unpack(newRot));
	end;
--[[Doors ende]]--	
--[[Windows start]]--
	if self.translationPartRight ~= nil then
		local x, y, z = getTranslation(self.translationPartRight.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartRight.maxTrans, self.translationPartRight.minTrans, 3, self.translationPartRight.transTime, dt, not self.translationMaxRight);
		setTranslation(self.translationPartRight.node, unpack(newTrans));
	end;	
	if self.translationPartRight2 ~= nil then
		local x, y, z = getTranslation(self.translationPartRight2.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartRight2.maxTrans, self.translationPartRight2.minTrans, 3, self.translationPartRight2.transTime, dt, not self.translationMaxRight2);
		setTranslation(self.translationPartRight2.node, unpack(newTrans));
	end;
	if self.translationPartRight3 ~= nil then
		local x, y, z = getTranslation(self.translationPartRight3.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartRight3.maxTrans, self.translationPartRight3.minTrans, 3, self.translationPartRight3.transTime, dt, not self.translationMaxRight3);
		setTranslation(self.translationPartRight3.node, unpack(newTrans));
	end;
	if self.translationPartRight4 ~= nil then
		local x, y, z = getTranslation(self.translationPartRight4.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartRight4.maxTrans, self.translationPartRight4.minTrans, 3, self.translationPartRight4.transTime, dt, not self.translationMaxRight4);
		setTranslation(self.translationPartRight4.node, unpack(newTrans));
	end;
--[[Windows ende]]--	
end;

function LADA:draw()
--[[Motorstart start]]--
    if not self.isMotorStarted and not self.automaticStart then	
        g_currentMission:addHelpButtonText(g_i18n:getText("LADA_Start"), InputBinding.IGNITION);
	end;
--[[Motorstart ende]]--
    g_currentMission:addHelpButtonText(g_i18n:getText("LADAHorn"), InputBinding.LADA_HORN);
--[[Hilfeanzeige start]]--
	g_currentMission:addExtraPrintText(g_i18n:getText("LADA_WIN"));
	if self.isEntered then
		if not self.helpPanel then
			renderText(0.8335, 0.15, 0.02, "Taste 0: Info Ein");
		else
			renderText(0.8335, 0.15, 0.02, "Taste 0: Info Aus");
		end;
		if self.helpPanel then
			renderText(0.82, 0.31, 0.025, "- Zusatz Info -");
			if self.radioOn then
				renderText(0.82, 0.27, 0.018, g_i18n:getText("LADA_Radio_1"), (InputBinding.Radio)); 
			else
				renderText(0.82, 0.27, 0.018, g_i18n:getText("LADA_Radio_2"), (InputBinding.Radio)); 
			end;
			if self.farlightActive then
				renderText(0.82, 0.25, 0.018, g_i18n:getText("LADA_Light_1"), (InputBinding.LADA_FARLIGHT)); 
			else
				renderText(0.82, 0.25, 0.018, g_i18n:getText("LADA_Light_2"), (InputBinding.LADA_FARLIGHT)); 
			end;
			if self.flash then --[[do not change......its flashwarnlight]]--
				renderText(0.82, 0.19, 0.018, g_i18n:getText("LADA_WARN"), (InputBinding.LADA_FLASH));
			else
				renderText(0.82, 0.19, 0.018, g_i18n:getText("LADA_WARN1"), (InputBinding.LADA_FLASH));
			end;			
			if self.isMotorStarted then
				if self.foglightsActive then
					renderText(0.82, 0.23, 0.018, g_i18n:getText("LADA_Light_3"), (InputBinding.LADA_FOGLIGHT)); 
				else
					renderText(0.82, 0.23, 0.018, g_i18n:getText("LADA_Light_4"), (InputBinding.LADA_FOGLIGHT)); 
				end;				
				if self.flashLeft then --[[do not change......its flashlight right]]--
					renderText(0.82, 0.17, 0.018, g_i18n:getText("LADA_RIGHT"), (InputBinding.LADA_t_RIGHT));
				else
					renderText(0.82, 0.17, 0.018, g_i18n:getText("LADA_RIGHT1"), (InputBinding.LADA_t_RIGHT));
				end;
				if self.flashRight then --[[do not change......its flashlight left]]--
					renderText(0.82, 0.21, 0.018, g_i18n:getText("LADA_LEFT"), (InputBinding.LADA_t_LEFT));
				else
					renderText(0.82, 0.21, 0.018, g_i18n:getText("LADA_LEFT1"), (InputBinding.LADA_t_LEFT));
				end;
			end;
			if self.hudLADAOverlay ~= nil then
				self.hudLADAOverlay:render();
			end;
		end;
	end;
--[[Hilfeanzeige ende]]--
end;

function LADA:onLeave()
--[[Rueckfahrlicht start]]--
    self.rearlightActive = false;
--[[Rueckfahrlicht ende]]--
--[[Fernlicht start]]--	
	self.farlightActive = false;
--[[Fernlicht ende]]--
--[[Nebelleuchte start]]--	
	self.foglightsActive = false;
--[[Nebelleuchte ende]]--
--[[Radio start]]--
	self.radioOn = false;
--[[Radio ende]]--	
--[[Motorstart start]]--
	if not self.deactivateOnLeave then
	    self.allowedIgnition = false;
	    self.ignitionKey = true; 
    else
	    self.allowedIgnition = false;
	    self.ignitionKey = false;
	end;
--[[Motorstart ende]]--
end;

function key_convert(key)
    if key ~= nil then 
	    local keyname = "";
	    if key > 32 and key < 123 then
	    	keyname = string.upper(string.char(key));
	    elseif key > 255 and key < 266 then
	    	keyname = "NUM "..string.char(key-208);
	    else 
	    	keyname = "";
	    end;
	    return(keyname);
	end;
end;