SetLeftTracerEvent = {};
SetLeftTracerEvent_mt = Class(SetLeftTracerEvent, Event);

InitEventClass(SetLeftTracerEvent, "SetLeftTracerEvent");

function SetLeftTracerEvent:emptyNew()
    local self = Event:new(SetLeftTracerEvent_mt);
    self.className="SetLeftTracerEvent";
    return self;
end;

function SetLeftTracerEvent:new(vehicle, isLeftUnfold)
    local self = SetLeftTracerEvent:emptyNew()
    self.vehicle = vehicle;
	self.isLeftUnfold = isLeftUnfold;
    return self;
end;

function SetLeftTracerEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isLeftUnfold = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetLeftTracerEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isLeftUnfold);
end;

function SetLeftTracerEvent:run(connection)   
	self.vehicle:setLeftTracer(self.isLeftUnfold, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetLeftTracerEvent:new(self.vehicle, self.isLeftUnfold), nil, connection, self.vehicle);
    end;
end;

function SetLeftTracerEvent.sendEvent(vehicle, isLeftUnfold, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetLeftTracerEvent:new(vehicle, isLeftUnfold), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetLeftTracerEvent:new(vehicle, isLeftUnfold));
		end;
	end;
end;