


Guellefass = {};

function Guellefass.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Sprayer, specializations);
end;

function Guellefass:load(xmlFile)
	
	self.lowerRmp = SpecializationUtil.callSpecializationsFunction("lowerRmp");
	
	self.allowFillWithArm = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.allowFillWithArm#value"), false);
	if self.allowFillWithArm then
		self.fillArmNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.allowFillWithArm#node"));
	end; 
	
	self.connectCollisions = SpecializationUtil.callSpecializationsFunction("connectCollisions");
	self.anim = SpecializationUtil.callSpecializationsFunction("anim");
	self.Go = {}; 
	self.Done = {};
	self.charId = {};
	self.clipIndex = {};
	self.CheckDone = {};
	self.moveColli = {}; 
    self.animParts = {};
	self.collisionArm = {};
	self.startpoint = {};
	self.loopCheck = {};
	self.Speed = {};
	local count = getXMLInt(xmlFile, "vehicle.animParts#count");
	local part = self.animParts;
    for i=1, count do
		part[i] = {};
        local partname = string.format("vehicle.animParts.part".."%d", i);
	    local nameR = getXMLString(xmlFile, partname.."#name");
		self.charId[nameR] = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#rootNode"));
		self.clipIndex[nameR] = getXMLString(xmlFile, partname.."#animationClip");
		self.CheckDone[nameR] = false;
		self.moveColli[nameR] = getXMLString(xmlFile, partname.."#moveColli");
		self.startpoint[nameR] = Utils.getNoNil(getXMLFloat(xmlFile, partname.."#startpoint"),0.0);
		if self.moveColli[nameR] ~= nil then
			local Collision = {};
			Collision.collision = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#collision"));
			Collision.collisionAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#collsionAttacher"));
			Collision.armAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.. "#armAttacher"));
			Collision.index = 0;
			self.collisionArm[nameR] = Collision;
			self:connectCollisions(nameR);
		end; 
		local charId = getAnimCharacterSet(self.charId[nameR]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[nameR]);
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackTime(charId, 0, self.startpoint[nameR]);
		enableAnimTrack(charId, 0);
		disableAnimTrack(charId, 0);
		self.loopCheck[nameR] = false;
		self.Speed[nameR] = 1.0;
	end; 
	
	local rotationPartNodeDisplay1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartDisplay1#index"));
    if rotationPartNodeDisplay1 ~= nil then
        self.rotationPartDisplay1 = {};
        self.rotationPartDisplay1.node = rotationPartNodeDisplay1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDisplay1#minRot"));
        self.rotationPartDisplay1.minRot = {};
        self.rotationPartDisplay1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDisplay1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDisplay1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDisplay1#maxRot"));
        self.rotationPartDisplay1.maxRot = {};
        self.rotationPartDisplay1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDisplay1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDisplay1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartDisplay1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDisplay1#rotTime"), 2)*1000;
        self.rotationPartDisplay1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDisplay1#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeDisplay2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartDisplay2#index"));
    if rotationPartNodeDisplay2 ~= nil then
        self.rotationPartDisplay2 = {};
        self.rotationPartDisplay2.node = rotationPartNodeDisplay2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDisplay2#minRot"));
        self.rotationPartDisplay2.minRot = {};
        self.rotationPartDisplay2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDisplay2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDisplay2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDisplay2#maxRot"));
        self.rotationPartDisplay2.maxRot = {};
        self.rotationPartDisplay2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDisplay2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDisplay2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartDisplay2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDisplay2#rotTime"), 2)*1000;
        self.rotationPartDisplay2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDisplay2#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeDisplay3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartDisplay3#index"));
    if rotationPartNodeDisplay3 ~= nil then
        self.rotationPartDisplay3 = {};
        self.rotationPartDisplay3.node = rotationPartNodeDisplay3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDisplay3#minRot"));
        self.rotationPartDisplay3.minRot = {};
        self.rotationPartDisplay3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDisplay3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDisplay3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDisplay3#maxRot"));
        self.rotationPartDisplay3.maxRot = {};
        self.rotationPartDisplay3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDisplay3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDisplay3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartDisplay3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDisplay3#rotTime"), 2)*1000;
        self.rotationPartDisplay3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDisplay3#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeDisplay4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartDisplay4#index"));
    if rotationPartNodeDisplay4 ~= nil then
        self.rotationPartDisplay4 = {};
        self.rotationPartDisplay4.node = rotationPartNodeDisplay4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDisplay4#minRot"));
        self.rotationPartDisplay4.minRot = {};
        self.rotationPartDisplay4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDisplay4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDisplay4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDisplay4#maxRot"));
        self.rotationPartDisplay4.maxRot = {};
        self.rotationPartDisplay4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDisplay4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDisplay4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartDisplay4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDisplay4#rotTime"), 2)*1000;
        self.rotationPartDisplay4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDisplay4#touchRotLimit"), 10));
    end;
	
	
	
	self.groundCheck = {};
	self.groundCheck.left = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.groundCheck#left"));
	self.groundCheck.right = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.groundCheck#right"));
	
	self.literPerSecond = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.literPerSecond#value"), 1);
	
	self.keyType = InputBinding.getKeyNamesOfDigitalAction;
	self.keyName = "Key"; 
	
	
	local rotationPartNodeFillLevel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartFillLevel#index"));
    if rotationPartNodeFillLevel ~= nil then
        self.rotationPartFillLevel = {};
        self.rotationPartFillLevel.node = rotationPartNodeFillLevel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartFillLevel#minRot"));
        self.rotationPartFillLevel.minRot = {};
        self.rotationPartFillLevel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartFillLevel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartFillLevel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartFillLevel#maxRot"));
        self.rotationPartFillLevel.maxRot = {};
        self.rotationPartFillLevel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartFillLevel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartFillLevel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartFillLevel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartFillLevel#rotTime"), 2)*1000;
        self.rotationPartFillLevel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartFillLevel#touchRotLimit"), 10));
    end;
	
	
	self.numBacklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.backlights#count"), 0);
    self.backlights = {};
    for i=1, self.numBacklights do
        local backlightnamei = string.format("vehicle.backlights.backlight" .. "%d", i);
        self.backlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, backlightnamei .. "#index"));
        setVisibility(self.backlights[i], false);
    end;
	
	self.numBrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numBrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;
	
	self.numReverselights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.reverselights#count"), 0);
    self.reverselights = {};
    for i=1, self.numReverselights do
        local reverselightnamei = string.format("vehicle.reverselights.reverselight" .. "%d", i);
        self.reverselights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, reverselightnamei .. "#index"));
        setVisibility(self.reverselights[i], false);
    end;
	
	self.sprayParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.sprayParticleSystems.sprayParticleSystems(%d)", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.sprayParticleSystems, namei, nodei, false, nil, self.baseDirectory)		
		i = i +1;		
    end;
	
	local workSound = getXMLString(xmlFile, "vehicle.workSound#file");
    if workSound ~= nil and workSound ~= "" then
        workSound = Utils.getFilename(workSound, self.baseDirectory);
        self.workSound = createSample("workSound");
        self.workSoundEnabled = false;
        loadSample(self.workSound, workSound, false);
        self.workSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#pitchOffset"), 1);
        self.workSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#volume"), 1);
    end;
	
	
	
	self.brakelightsActive = false;
	self.reverselightsActive = false;
	self.backlightsActive = false;
	self.turnOn = false;
	self.levelCheck = false;
	self.filling = false;
end;

function Guellefass:delete()
end;

function Guellefass:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Guellefass:keyEvent(unicode, sym, modifier, isDown)
	self.keyType = InputBinding.getKeyNamesOfDigitalAction;
	self.keyName = "Key";
end;

function Guellefass:update(dt)

	if self.rotationPartFillLevel ~= nil then
		local x, y, z = getRotation(self.rotationPartFillLevel.node);
		z = ((self.rotationPartFillLevel.maxRot[3] - self.rotationPartFillLevel.minRot[3]) / self.capacity) * self.fillLevel + self.rotationPartFillLevel.minRot[3];
		setRotation(self.rotationPartFillLevel.node, x, y ,z);
	end;
	
	if self.backlightsActive then
		for i=1, self.numBacklights do
			local backlight = self.backlights[i];
			setVisibility(backlight, self.backlightsActive);
		end;
	else
		for i=1, self.numBacklights do
			local backlight = self.backlights[i];
			setVisibility(backlight, self.backlightsActive, false);
		end;
	end;
		
	if self.brakelightsActive then
		for i=1, self.numBrakelights do
			local brakelight = self.brakelights[i];
			setVisibility(brakelight, self.brakelightsActive);
		end;
	else
		for i=1, self.numBrakelights do
			local brakelight = self.brakelights[i];
			setVisibility(brakelight, self.brakelightsActive, false);
		end;
	end;
		
	if self.reverselightsActive then
		for i=1, self.numReverselights do
			local reverselight = self.reverselights[i];
			setVisibility(reverselight, self.reverselightsActive);
		end;
	else
		for i=1, self.numReverselights do
			local reverselight = self.reverselights[i];
			setVisibility(reverselight, self.reverselightsActive, false);
		end;
	end;
	
	
	
	
	if self.attacherVehicle then
		if self.attacherVehicle.lightsActive then
			self.backlightsActive = true;
		else
			self.backlightsActive = false;
		end;
		
		if self.attacherVehicle.movingDirection < 0 then
			self.reverselightsActive = true;
		else
			self.reverselightsActive = false;
		end;
	end;

	if self.attacherVehicle then
		if not self.turnOn --and not self.Go.trsp
		then
			if self:getIsActiveForInput() and InputBinding.hasEvent(InputBinding.Guellefass_filling) then
				self.filling = not self.filling;
			end;
		elseif self.turnOn --or self.Go.trsp
		then
			self.filling = false;
		end;
--------------------------------------------
--		if self:getIsActiveForInput() and InputBinding.hasEvent(InputBinding.Guellefass_transport) and not self.turnOn and not self.filling and not self.levelCheck then
--			self.Go.trsp = not self.Go.trsp; 
--			self.Done.trsp = true;  
--			self.Go.hub = false; 
--			self.Done.hub = true;
--		end;
-----------------------------------
--		if self:getIsActiveForInput() and InputBinding.hasEvent(InputBinding.Guellefass_levelcheck) and self.CheckDone.trsp and self.Go.trsp then
--			self.levelCheck = not self.levelCheck; 
--		end;
--		if self:getIsActiveForInput() and InputBinding.isPressed(InputBinding.Guellefass_up) and not self.levelCheck and self.CheckDone.trsp and self.Go.trsp then
--			self.Go.hub = true; 
--			self.Done.hub = true;
-----------------------------------------------------------
--		elseif self:getIsActiveForInput() and InputBinding.isPressed(InputBinding.Guellefass_down) and not self.levelCheck and self.CheckDone.trsp and self.Go.trsp then
--			self.Go.hub = false; 
--			self.Done.hub = true;
--		elseif not self.Done.trsp and not self.levelCheck and self.CheckDone.trsp and self.Go.trsp then
--			self.Done.hub = false; 
--		end; 
		
		if self.filling then
		
			if self:getIsActiveForInput() and InputBinding.isPressed(InputBinding.Guellefass_armRot1) then--and not self.levelCheck and self.CheckDone.trsp and self.Go.trsp then
				self.Go.armrot = true; 
				self.Done.armrot = true;
			
			elseif self:getIsActiveForInput() and InputBinding.isPressed(InputBinding.Guellefass_armRot2) then --and not self.levelCheck and self.CheckDone.trsp and self.Go.trsp then
				self.Go.armrot = false; 
				self.Done.armrot = true;
			else--if not self.Done.trsp and not self.levelCheck and self.CheckDone.trsp and self.Go.trsp then
				self.Done.armrot = false; 
			end; 
			
			if self:getIsActiveForInput() and InputBinding.isPressed(InputBinding.Guellefass_armHub1) then--and not self.levelCheck and self.CheckDone.trsp and self.Go.trsp then
				self.Go.armhub = true; 
				self.Done.armhub = true;
			
			elseif self:getIsActiveForInput() and InputBinding.isPressed(InputBinding.Guellefass_armHub2) then --and not self.levelCheck and self.CheckDone.trsp and self.Go.trsp then
				self.Go.armhub = false; 
				self.Done.armhub = true;
			else--if not self.Done.trsp and not self.levelCheck and self.CheckDone.trsp and self.Go.trsp then
				self.Done.armhub = false; 
			end; 
			
			if self:getIsActiveForInput() and InputBinding.isPressed(InputBinding.Guellefass_armKnick1) then--and not self.levelCheck and self.CheckDone.trsp and self.Go.trsp then
				self.Go.armknick = true; 
				self.Done.armknick = true;
			
			elseif self:getIsActiveForInput() and InputBinding.isPressed(InputBinding.Guellefass_armKnick2) then --and not self.levelCheck and self.CheckDone.trsp and self.Go.trsp then
				self.Go.armknick = false; 
				self.Done.armknick = true;
			else--if not self.Done.trsp and not self.levelCheck and self.CheckDone.trsp and self.Go.trsp then
				self.Done.armknick = false; 
			end; 
			
			if self:getIsActiveForInput() and InputBinding.isPressed(InputBinding.Guellefass_armTele1) then--and not self.levelCheck and self.CheckDone.trsp and self.Go.trsp then
				self.Go.armtele = true; 
				self.Done.armtele = true;
			
			elseif self:getIsActiveForInput() and InputBinding.isPressed(InputBinding.Guellefass_armTele2) then --and not self.levelCheck and self.CheckDone.trsp and self.Go.trsp then
				self.Go.armtele = false; 
				self.Done.armtele = true;
			else--if not self.Done.trsp and not self.levelCheck and self.CheckDone.trsp and self.Go.trsp then
				self.Done.armtele = false; 
			end; 
		else
			self.Go.armtele = false;
			self.Done.armtele =true;
			self.Go.armknick = false;
			self.Done.armknick = true;
			self.Go.armhub = false;
			self.Done.armhub = true;
			self.Go.armrot = false;
			self.Done.armrot = true;
		end;
		
		if self.levelCheck then	
			local x,y,z = getWorldTranslation(self.groundCheck.right);
			local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
			local gCr = y-terrainHeight; 
			local x,y,z = getWorldTranslation(self.groundCheck.left);
			local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
			local gCl = y-terrainHeight; 
			local gC = math.floor(math.min(gCl,gCr) * 10) / 10;
			if (gC < 2.0) then 
				self.Go.hub = false; 
				self.Done.hub = true;
			else
				self.Go.hub = true; 
				self.Done.hub = true;
			end;
		end; 	
		
	end;
	if self.attacherVehicle then
		if self:getIsActiveForInput() and InputBinding.hasEvent(InputBinding.Guellefass_activate) then
			if self.Go.trsp and not self.filling and self.CheckDone.trsp then
				self.turnOn = not self.turnOn; 
			end; 
		end;
		
		if self.fillLevel == 0 then
			self.turnOn = false; 
			self:lowerRmp();
			Utils.setEmittingState(self.sprayParticleSystems, false)
			if self.workSoundEnabled then
		        stopSample(self.workSound);
		        self.workSoundEnabled = false;
			end;
		end; 
		
		if self.turnOn then
			if not self.backupRmp then
				self.backupRmp = self.attacherVehicle.motor.minRpm;
			end; 			
			if self.attacherVehicle.motor.minRpm >= -500 then
				self.attacherVehicle.motor.minRpm = self.attacherVehicle.motor.minRpm - 15; 
			end; 		
			local difficultyMultiplier = math.max(3 * (3 - g_currentMission.missionStats.difficulty), 1);
			local deltaLevel = FruitUtil.fruitIndexToDesc[self.currentFillType].literPerSqm * difficultyMultiplier * self.literPerSecond;
			self:setFillLevel(self.fillLevel-deltaLevel, self.currentFillType);
			Utils.setEmittingState(self.dustParticleSystems, true)
			for k,cuttingArea in pairs(self.cuttingAreas) do
                local x,y,z = getWorldTranslation(cuttingArea.start);
                local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
                Utils.updateSprayArea(x, z, x1, z1, x2, z2);
            end;
			Utils.setEmittingState(self.sprayParticleSystems, true)
			if not self.workSoundEnabled and self:getIsActiveForSound() then
	            playSample(self.workSound, 0, self.workSoundVolume, 0);
	            setSamplePitch(self.workSound, self.workSoundPitchOffset);
	            self.workSoundEnabled = true;
	        end;	
		else
			self:lowerRmp();
			Utils.setEmittingState(self.sprayParticleSystems, false)
			if self.workSoundEnabled then
		        stopSample(self.workSound);
		        self.workSoundEnabled = false;
			end;
		end;
	end;
	
	if self.Go.trsp ~= nil and self.Done.trsp ~= false then
		self:anim("trsp", false); 
	end;

	self:anim("hub", false); 
	self:anim("armhub", false);
	self:anim("armrot", false);
	self:anim("armknick", false);
	self:anim("armtele", false);
	
	if self.rotationPartDisplay1 ~= nil then
		local x, y, z = getRotation(self.rotationPartDisplay1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartDisplay1.maxRot, self.rotationPartDisplay1.minRot, 3, self.rotationPartDisplay1.rotTime, dt, not self.rotationMaxDisplay1);
		setRotation(self.rotationPartDisplay1.node, unpack(newRot));
	end;
	
	if self.rotationPartDisplay2 ~= nil then
		local x, y, z = getRotation(self.rotationPartDisplay2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartDisplay2.maxRot, self.rotationPartDisplay2.minRot, 3, self.rotationPartDisplay2.rotTime, dt, not self.rotationMaxDisplay2);
		setRotation(self.rotationPartDisplay2.node, unpack(newRot));
	end;
	
	if self.rotationPartDisplay3 ~= nil then
		local x, y, z = getRotation(self.rotationPartDisplay3.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartDisplay3.maxRot, self.rotationPartDisplay3.minRot, 3, self.rotationPartDisplay3.rotTime, dt, not self.rotationMaxDisplay3);
		setRotation(self.rotationPartDisplay3.node, unpack(newRot));
	end;
	
	if self.rotationPartDisplay4 ~= nil then
		local x, y, z = getRotation(self.rotationPartDisplay4.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartDisplay4.maxRot, self.rotationPartDisplay4.minRot, 3, self.rotationPartDisplay4.rotTime, dt, not self.rotationMaxDisplay4);
		setRotation(self.rotationPartDisplay4.node, unpack(newRot));
	end;
	
	if self.turnOn then
		self.rotationMaxDisplay4 = true;
		self.rotationMaxDisplay2 = true;
		self.rotationMaxDisplay3 = true;
		self.rotationMaxDisplay1 = true;
	else
		self.rotationMaxDisplay4 = false;
		self.rotationMaxDisplay2 = false;
		self.rotationMaxDisplay3 = false;
		self.rotationMaxDisplay1 = false;
	end;
	
end;

function Guellefass:draw()
	

end;

function Guellefass:onBrake()
	if self.attacherVehicle.motor.speedLevel == 0 then	
		self.brakelightsActive = true;
    end;
end;

function Guellefass:onReleaseBrake()
	self.brakelightsActive = false;
end;

function Guellefass:anim(varName, loopCheck)
	if self.moveColli[varName] ~= nil then
		local Collision = self.collisionArm[varName];
		setJointFrame(Collision.index, 0, Collision.armAttacher);
	end;
	local loopCheck = self.loopCheck[varName];
	local speed = Utils.getNoNil(self.Speed[varName],1);
	local offset = 10;  
	local charId = getAnimCharacterSet(self.charId[varName]);
	local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
	if self.Done[varName] ~= false then
		if self.Go[varName] == true then
			assignAnimTrackClip(charId , 0, clipIndex);
			setAnimTrackLoopState(charId, 0, loopCheck);
			setAnimTrackSpeedScale(charId, 0, speed);
			enableAnimTrack(charId, 0);
			if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) and loopCheck == false then
				self.Done[varName] = false;	
				self.CheckDone[varName] = self.Go[varName];	
			end;
			if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) and loopCheck then
				local setTime = getAnimClipDuration(charId, clipIndex) - getAnimClipDuration(charId, clipIndex);
				setAnimTrackTime(charId, 0, setTime);
			end;
		elseif self.Go[varName] == false then
			if loopCheck == true then
				self.Done[varName] = false;	
			else
				assignAnimTrackClip(charId , 0, clipIndex);
				setAnimTrackLoopState(charId, 0, loopCheck);
				setAnimTrackSpeedScale(charId, 0, -speed);
				enableAnimTrack(charId, 0);
				if getAnimTrackTime(charId, 0) <= 0 then
					self.Done[varName] = false;	
					self.CheckDone[varName] = self.Go[varName];
				end;
			end;
		elseif self.Go[varName] ~= nil then
			assignAnimTrackClip(charId , 0, clipIndex);
			setAnimTrackLoopState(charId, 0, loopCheck);
			if self.Go[varName] < 0.0 then
				self.Go[varName] = 0.0;
			elseif self.Go[varName] > getAnimClipDuration(charId, clipIndex) then
				self.Go[varName] = getAnimClipDuration(charId, clipIndex);
			end;
			if getAnimTrackTime(charId, 0) >= self.Go[varName] then
				setAnimTrackSpeedScale(charId, 0, -speed);
			else
				setAnimTrackSpeedScale(charId, 0, speed);
			end;
			enableAnimTrack(charId, 0);
			if getAnimTrackTime(charId, 0) <= self.Go[varName] + offset and getAnimTrackTime(charId, 0) >= self.Go[varName] - offset then
				self.Done[varName] = false;	
				self.CheckDone[varName] = self.Go[varName];
			end;
		end;
	end;
	if self.Done[varName] == false then
		disableAnimTrack(charId, 0);
	end;
end; 

function Guellefass:onDetach()
	self.turnOn = false;
	if self.workSoundEnabled then
		stopSample(self.workSound);
		self.workSoundEnabled = false;
	end;
	Utils.setEmittingState(self.sprayParticleSystems, false)
	self:lowerRmp();
end;

function Guellefass:lowerRmp()
	if self.backupRmp and self.attacherVehicle then
		if self.attacherVehicle.motor.minRpm <= self.backupRmp then
			self.attacherVehicle.motor.minRpm = self.attacherVehicle.motor.minRpm + 15; 
		else
			self.attacherVehicle.motor.minRpm = self.backupRmp; 
			self.backupRmp = nil; 			
		end; 	
	end; 
end;


