--
-- JD_8530
-- Specialization class for John Deere 8530
--
-- @author  Mario
-- @date  24/08/2010
--
-- Copyright (C) Mario, All Rights Reserved.

JD_8530 = {};

function JD_8530.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function JD_8530:load(xmlFile)
	self.controlpath = Utils.getFilename("textur/same.png", self.baseDirectory);
    self.hudjohndeereWidth = 0.2700;
    self.hudjohndeereHeight = 0.1864;
	self.hudjohndeerePoxX = 0.015;
    self.hudjohndeerePoxY = 0.075;
    self.hudjohndeereOverlay = Overlay:new("hudjohndeereControl", self.controlpath, self.hudjohndeerePoxX, self.hudjohndeerePoxY, self.hudjohndeereWidth, self.hudjohndeereHeight);

	self.worklight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.worklight#index"));
	self.worklight2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.worklight#index2"));
	self.farlight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.farlight#index"));
	self.farlight2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.farlight#index2"));
	self.rundum = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rundum#index"));
	self.warn = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.warn#index"));
	self.tanklight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tanklight#index"));
	self.tank2light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tanklight#index2"));
	self.drucklight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drucklight#index"));
	self.druck2light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drucklight#index2"));
	self.druck3light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drucklight#index3"));
	self.blinkerleft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.blinkerleft#index"));
	self.blinkerright = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.blinkerright#index"));
	self.tanklightActive = false;
	self.worklightActive = false;
	self.farlightActive = false;
	self.dualsActive = false;
	self.wycieraczki = false;
	self.wyc = 650;
	self.tankwarn = 100;

	self.duals = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.duals#index"));
	self.duals2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.duals#index2"));
	self.duals3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.duals#index3"));
	self.duals4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.duals#index4"));
	
    self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenKey = getXMLString(xmlFile, "vehicle.rundumleuchten#key");
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;
	
	self.dustParticleSystems = {};
    local dustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems#count"), 0);
    for i=1, dustParticleSystemCount do
        local namei = string.format("vehicle.dustParticleSystems.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
	
    local rotationPartNodeLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft#index"));
    if rotationPartNodeLeft ~= nil then
        self.rotationPartLeft = {};
        self.rotationPartLeft.node = rotationPartNodeLeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#minRot"));
        self.rotationPartLeft.minRot = {};
        self.rotationPartLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#maxRot"));
        self.rotationPartLeft.maxRot = {};
        self.rotationPartLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#rotTime"), 2)*1000;
        self.rotationPartLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft2#index"));
    if rotationPartNodeLeft2 ~= nil then
        self.rotationPartLeft2 = {};
        self.rotationPartLeft2.node = rotationPartNodeLeft2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft2#minRot"));
        self.rotationPartLeft2.minRot = {};
        self.rotationPartLeft2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft2#maxRot"));
        self.rotationPartLeft2.maxRot = {};
        self.rotationPartLeft2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft2#rotTime"), 2)*1000;
        self.rotationPartLeft2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft2#touchRotLimit"), 10));
    end;
	
	local rotationPartNodePedal = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartPedal#index"));
    if rotationPartNodePedal ~= nil then
        self.rotationPartPedal = {};
        self.rotationPartPedal.node = rotationPartNodePedal;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartPedal#minRot"));
        self.rotationPartPedal.minRot = {};
        self.rotationPartPedal.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPedal.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPedal.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartPedal#maxRot"));
        self.rotationPartPedal.maxRot = {};
        self.rotationPartPedal.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPedal.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPedal.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartPedal.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartPedal#rotTime"), 2)*1000;
        self.rotationPartPedal.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartPedal#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeBrake = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartBrake#index"));
    if rotationPartNodeBrake ~= nil then
        self.rotationPartBrake = {};
        self.rotationPartBrake.node = rotationPartNodeBrake;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartBrake#minRot"));
        self.rotationPartBrake.minRot = {};
        self.rotationPartBrake.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartBrake.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartBrake.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartBrake#maxRot"));
        self.rotationPartBrake.maxRot = {};
        self.rotationPartBrake.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartBrake.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartBrake.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartBrake.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartBrake#rotTime"), 2)*1000;
        self.rotationPartBrake.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartBrake#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeClutch = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartClutch#index"));
    if rotationPartNodeClutch ~= nil then
        self.rotationPartClutch = {};
        self.rotationPartClutch.node = rotationPartNodeClutch;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartClutch#minRot"));
        self.rotationPartClutch.minRot = {};
        self.rotationPartClutch.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartClutch.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartClutch.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartClutch#maxRot"));
        self.rotationPartClutch.maxRot = {};
        self.rotationPartClutch.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartClutch.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartClutch.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartClutch.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartClutch#rotTime"), 2)*1000;
        self.rotationPartClutch.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartClutch#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeDrehzahl1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#index"));
    if rotationPartNodeDrehzahl1 ~= nil then
        self.rotationPartDrehzahl1 = {};
        self.rotationPartDrehzahl1.node = rotationPartNodeDrehzahl1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#minRot"));
        self.rotationPartDrehzahl1.minRot = {};
        self.rotationPartDrehzahl1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrehzahl1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrehzahl1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#maxRot"));
        self.rotationPartDrehzahl1.maxRot = {};
        self.rotationPartDrehzahl1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrehzahl1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrehzahl1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartDrehzahl1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#rotTime"), 2)*1000;
        self.rotationPartDrehzahl1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeDrehzahl2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#index"));
    if rotationPartNodeDrehzahl2 ~= nil then
        self.rotationPartDrehzahl2 = {};
        self.rotationPartDrehzahl2.node = rotationPartNodeDrehzahl2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#minRot"));
        self.rotationPartDrehzahl2.minRot = {};
        self.rotationPartDrehzahl2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrehzahl2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrehzahl2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#maxRot"));
        self.rotationPartDrehzahl2.maxRot = {};
        self.rotationPartDrehzahl2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrehzahl2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrehzahl2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartDrehzahl2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#rotTime"), 2)*1000;
        self.rotationPartDrehzahl2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeKmh1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartKmh1#index"));
    if rotationPartNodeKmh1 ~= nil then
        self.rotationPartKmh1 = {};
        self.rotationPartKmh1.node = rotationPartNodeKmh1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh1#minRot"));
        self.rotationPartKmh1.minRot = {};
        self.rotationPartKmh1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh1#maxRot"));
        self.rotationPartKmh1.maxRot = {};
        self.rotationPartKmh1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKmh1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh1#rotTime"), 2)*1000;
        self.rotationPartKmh1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh1#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeKmh2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartKmh2#index"));
    if rotationPartNodeKmh2 ~= nil then
        self.rotationPartKmh2 = {};
        self.rotationPartKmh2.node = rotationPartNodeKmh2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh2#minRot"));
        self.rotationPartKmh2.minRot = {};
        self.rotationPartKmh2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh2#maxRot"));
        self.rotationPartKmh2.maxRot = {};
        self.rotationPartKmh2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKmh2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh2#rotTime"), 2)*1000;
        self.rotationPartKmh2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh2#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeTanknadel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTanknadel#index"));
    if rotationPartNodeTanknadel ~= nil then
        self.rotationPartTanknadel = {};
        self.rotationPartTanknadel.node = rotationPartNodeTanknadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#minRot"));
        self.rotationPartTanknadel.minRot = {};
        self.rotationPartTanknadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#maxRot"));
        self.rotationPartTanknadel.maxRot = {};
        self.rotationPartTanknadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#rotTime"), 2)*1000;
        self.rotationPartTanknadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeTanknadel2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#index"));
    if rotationPartNodeTanknadel2 ~= nil then
        self.rotationPartTanknadel2 = {};
        self.rotationPartTanknadel2.node = rotationPartNodeTanknadel2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#minRot"));
        self.rotationPartTanknadel2.minRot = {};
        self.rotationPartTanknadel2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#maxRot"));
        self.rotationPartTanknadel2.maxRot = {};
        self.rotationPartTanknadel2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#rotTime"), 2)*1000;
        self.rotationPartTanknadel2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeDruck = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartDruck#index"));
    if rotationPartNodeDruck ~= nil then
        self.rotationPartDruck = {};
        self.rotationPartDruck.node = rotationPartNodeDruck;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDruck#minRot"));
        self.rotationPartDruck.minRot = {};
        self.rotationPartDruck.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDruck.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDruck.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDruck#maxRot"));
        self.rotationPartDruck.maxRot = {};
        self.rotationPartDruck.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDruck.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDruck.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartDruck.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDruck#rotTime"), 2)*1000;
        self.rotationPartDruck.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDruck#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeDruckLight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartDruckLight#index"));
    if rotationPartNodeDruckLight ~= nil then
        self.rotationPartDruckLight = {};
        self.rotationPartDruckLight.node = rotationPartNodeDruckLight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDruckLight#minRot"));
        self.rotationPartDruckLight.minRot = {};
        self.rotationPartDruckLight.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDruckLight.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDruckLight.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDruckLight#maxRot"));
        self.rotationPartDruckLight.maxRot = {};
        self.rotationPartDruckLight.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDruckLight.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDruckLight.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartDruckLight.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDruckLight#rotTime"), 2)*1000;
        self.rotationPartDruckLight.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDruckLight#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeBlinkerLinks = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartBlinkerLinks#index"));
    if rotationPartNodeBlinkerLinks ~= nil then
        self.rotationPartBlinkerLinks = {};
        self.rotationPartBlinkerLinks.node = rotationPartNodeBlinkerLinks;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartBlinkerLinks#minRot"));
        self.rotationPartBlinkerLinks.minRot = {};
        self.rotationPartBlinkerLinks.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartBlinkerLinks.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartBlinkerLinks.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartBlinkerLinks#maxRot"));
        self.rotationPartBlinkerLinks.maxRot = {};
        self.rotationPartBlinkerLinks.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartBlinkerLinks.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartBlinkerLinks.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartBlinkerLinks.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartBlinkerLinks#rotTime"), 2)*1000;
        self.rotationPartBlinkerLinks.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartBlinkerLinks#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeBlinkerRechts = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartBlinkerRechts#index"));
    if rotationPartNodeBlinkerRechts ~= nil then
        self.rotationPartBlinkerRechts = {};
        self.rotationPartBlinkerRechts.node = rotationPartNodeBlinkerRechts;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartBlinkerRechts#minRot"));
        self.rotationPartBlinkerRechts.minRot = {};
        self.rotationPartBlinkerRechts.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartBlinkerRechts.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartBlinkerRechts.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartBlinkerRechts#maxRot"));
        self.rotationPartBlinkerRechts.maxRot = {};
        self.rotationPartBlinkerRechts.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartBlinkerRechts.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartBlinkerRechts.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartBlinkerRechts.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartBlinkerRechts#rotTime"), 2)*1000;
        self.rotationPartBlinkerRechts.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartBlinkerRechts#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeWischerhebel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartWischerhebel#index"));
    if rotationPartNodeWischerhebel ~= nil then
        self.rotationPartWischerhebel = {};
        self.rotationPartWischerhebel.node = rotationPartNodeWischerhebel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWischerhebel#minRot"));
        self.rotationPartWischerhebel.minRot = {};
        self.rotationPartWischerhebel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWischerhebel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWischerhebel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWischerhebel#maxRot"));
        self.rotationPartWischerhebel.maxRot = {};
        self.rotationPartWischerhebel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWischerhebel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWischerhebel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartWischerhebel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWischerhebel#rotTime"), 2)*1000;
        self.rotationPartWischerhebel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWischerhebel#touchRotLimit"), 10));
    end;
	
	local translationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart#index"));
    if translationPartNode ~= nil then
        self.translationPart = {};
        self.translationPart.node = translationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#minTrans"));
        self.translationPart.minTrans = {};
        self.translationPart.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#maxTrans"));
        self.translationPart.maxTrans = {};
        self.translationPart.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#transTime"), 2)*1000;
        self.translationPart.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#touchTransLimit"), 10);
    end;
	
	--local translationPartNodeAttacher = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPartAttacher#index"));
    --if translationPartNodeAttacher ~= nil then
    --   self.translationPartAttacher = {};
    --    self.translationPartAttacher.node = translationPartNodeAttacher;
    --    local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartAttacher#minTrans"));
    --    self.translationPartAttacher.minTrans = {};
    --   self.translationPartAttacher.minTrans[1] = Utils.getNoNil(x, 0);
    --    self.translationPartAttacher.minTrans[2] = Utils.getNoNil(y, 0);
    --    self.translationPartAttacher.minTrans[3] = Utils.getNoNil(z, 0);

    --    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPartAttacher#maxTrans"));
    --    self.translationPartAttacher.maxTrans = {};
    --    self.translationPartAttacher.maxTrans[1] = Utils.getNoNil(x, 0);
    --    self.translationPartAttacher.maxTrans[2] = Utils.getNoNil(y, 0);
    --    self.translationPartAttacher.maxTrans[3] = Utils.getNoNil(z, 0);

    --    self.translationPartAttacher.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartAttacher#transTime"), 2)*1000;
    --    self.translationPartAttacher.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPartAttacher#touchTransLimit"), 10);
    --end;
	
	--local rotationPartNodeAttacherPart = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartAttacherPart#index"));
    --if rotationPartNodeAttacherPart ~= nil then
    --    self.rotationPartAttacherPart = {};
    --    self.rotationPartAttacherPart.node = rotationPartNodeAttacherPart;

    --    local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartAttacherPart#minRot"));
    --   self.rotationPartAttacherPart.minRot = {};
    --    self.rotationPartAttacherPart.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
    --    self.rotationPartAttacherPart.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
    --    self.rotationPartAttacherPart.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

    --    x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartAttacherPart#maxRot"));
    --    self.rotationPartAttacherPart.maxRot = {};
    --    self.rotationPartAttacherPart.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
    --    self.rotationPartAttacherPart.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
    --    self.rotationPartAttacherPart.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

    --    self.rotationPartAttacherPart.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartAttacherPart#rotTime"), 2)*1000;
    --    self.rotationPartAttacherPart.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartAttacherPart#touchRotLimit"), 10));
    --end;
	
	local rotationPartNodeWajchaZaczep = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartWajchaZaczep#index"));
    if rotationPartNodeWajchaZaczep ~= nil then
        self.rotationPartWajchaZaczep = {};
        self.rotationPartWajchaZaczep.node = rotationPartNodeWajchaZaczep;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWajchaZaczep#minRot"));
        self.rotationPartWajchaZaczep.minRot = {};
        self.rotationPartWajchaZaczep.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWajchaZaczep.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWajchaZaczep.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWajchaZaczep#maxRot"));
        self.rotationPartWajchaZaczep.maxRot = {};
        self.rotationPartWajchaZaczep.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWajchaZaczep.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWajchaZaczep.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartWajchaZaczep.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWajchaZaczep#rotTime"), 2)*1000;
        self.rotationPartWajchaZaczep.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWajchaZaczep#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeWajchaZaczep2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartWajchaZaczep2#index"));
    if rotationPartNodeWajchaZaczep2 ~= nil then
        self.rotationPartWajchaZaczep2 = {};
        self.rotationPartWajchaZaczep2.node = rotationPartNodeWajchaZaczep2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWajchaZaczep2#minRot"));
        self.rotationPartWajchaZaczep2.minRot = {};
        self.rotationPartWajchaZaczep2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWajchaZaczep2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWajchaZaczep2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWajchaZaczep2#maxRot"));
        self.rotationPartWajchaZaczep2.maxRot = {};
        self.rotationPartWajchaZaczep2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWajchaZaczep2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWajchaZaczep2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartWajchaZaczep2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWajchaZaczep2#rotTime"), 2)*1000;
        self.rotationPartWajchaZaczep2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWajchaZaczep2#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeReczny = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartReczny#index"));
    if rotationPartNodeReczny ~= nil then
        self.rotationPartReczny = {};
        self.rotationPartReczny.node = rotationPartNodeReczny;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartReczny#minRot"));
        self.rotationPartReczny.minRot = {};
        self.rotationPartReczny.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartReczny.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartReczny.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartReczny#maxRot"));
        self.rotationPartReczny.maxRot = {};
        self.rotationPartReczny.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartReczny.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartReczny.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartReczny.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartReczny#rotTime"), 2)*1000;
        self.rotationPartReczny.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartReczny#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeWajcha = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartWajcha#index"));
    if rotationPartNodeWajcha ~= nil then
        self.rotationPartWajcha = {};
        self.rotationPartWajcha.node = rotationPartNodeWajcha;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWajcha#minRot"));
        self.rotationPartWajcha.minRot = {};
        self.rotationPartWajcha.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWajcha.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWajcha.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWajcha#maxRot"));
        self.rotationPartWajcha.maxRot = {};
        self.rotationPartWajcha.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWajcha.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWajcha.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartWajcha.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWajcha#rotTime"), 2)*1000;
        self.rotationPartWajcha.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWajcha#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeWajcha2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartWajcha2#index"));
    if rotationPartNodeWajcha2 ~= nil then
        self.rotationPartWajcha2 = {};
        self.rotationPartWajcha2.node = rotationPartNodeWajcha2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWajcha2#minRot"));
        self.rotationPartWajcha2.minRot = {};
        self.rotationPartWajcha2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWajcha2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWajcha2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartWajcha2#maxRot"));
        self.rotationPartWajcha2.maxRot = {};
        self.rotationPartWajcha2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartWajcha2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartWajcha2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartWajcha2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWajcha2#rotTime"), 2)*1000;
        self.rotationPartWajcha2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartWajcha2#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeSkrzynia = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartSkrzynia#index"));
    if rotationPartNodeSkrzynia ~= nil then
        self.rotationPartSkrzynia = {};
        self.rotationPartSkrzynia.node = rotationPartNodeSkrzynia;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia#minRot"));
        self.rotationPartSkrzynia.minRot = {};
        self.rotationPartSkrzynia.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSkrzynia.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSkrzynia.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia#maxRot"));
        self.rotationPartSkrzynia.maxRot = {};
        self.rotationPartSkrzynia.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSkrzynia.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSkrzynia.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartSkrzynia.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia#rotTime"), 2)*1000;
        self.rotationPartSkrzynia.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeSkrzynia2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartSkrzynia2#index"));
    if rotationPartNodeSkrzynia2 ~= nil then
        self.rotationPartSkrzynia2 = {};
        self.rotationPartSkrzynia2.node = rotationPartNodeSkrzynia2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia2#minRot"));
        self.rotationPartSkrzynia2.minRot = {};
        self.rotationPartSkrzynia2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSkrzynia2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSkrzynia2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia2#maxRot"));
        self.rotationPartSkrzynia2.maxRot = {};
        self.rotationPartSkrzynia2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSkrzynia2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSkrzynia2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartSkrzynia2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia2#rotTime"), 2)*1000;
        self.rotationPartSkrzynia2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia2#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeSkrzynia3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartSkrzynia3#index"));
    if rotationPartNodeSkrzynia3 ~= nil then
        self.rotationPartSkrzynia3 = {};
        self.rotationPartSkrzynia3.node = rotationPartNodeSkrzynia3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia3#minRot"));
        self.rotationPartSkrzynia3.minRot = {};
        self.rotationPartSkrzynia3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSkrzynia3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSkrzynia3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia3#maxRot"));
        self.rotationPartSkrzynia3.maxRot = {};
        self.rotationPartSkrzynia3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSkrzynia3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSkrzynia3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartSkrzynia3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia3#rotTime"), 2)*1000;
        self.rotationPartSkrzynia3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia3#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeSkrzynia4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartSkrzynia4#index"));
    if rotationPartNodeSkrzynia4 ~= nil then
        self.rotationPartSkrzynia4 = {};
        self.rotationPartSkrzynia4.node = rotationPartNodeSkrzynia4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia4#minRot"));
        self.rotationPartSkrzynia4.minRot = {};
        self.rotationPartSkrzynia4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSkrzynia4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSkrzynia4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia4#maxRot"));
        self.rotationPartSkrzynia4.maxRot = {};
        self.rotationPartSkrzynia4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSkrzynia4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSkrzynia4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartSkrzynia4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia4#rotTime"), 2)*1000;
        self.rotationPartSkrzynia4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia4#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeSkrzynia5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartSkrzynia5#index"));
    if rotationPartNodeSkrzynia5 ~= nil then
        self.rotationPartSkrzynia5 = {};
        self.rotationPartSkrzynia5.node = rotationPartNodeSkrzynia5;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia5#minRot"));
        self.rotationPartSkrzynia5.minRot = {};
        self.rotationPartSkrzynia5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSkrzynia5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSkrzynia5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia5#maxRot"));
        self.rotationPartSkrzynia5.maxRot = {};
        self.rotationPartSkrzynia5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSkrzynia5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSkrzynia5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartSkrzynia5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia5#rotTime"), 2)*1000;
        self.rotationPartSkrzynia5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia5#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeSkrzynia6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartSkrzynia6#index"));
    if rotationPartNodeSkrzynia6 ~= nil then
        self.rotationPartSkrzynia6 = {};
        self.rotationPartSkrzynia6.node = rotationPartNodeSkrzynia6;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia6#minRot"));
        self.rotationPartSkrzynia6.minRot = {};
        self.rotationPartSkrzynia6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSkrzynia6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSkrzynia6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia6#maxRot"));
        self.rotationPartSkrzynia6.maxRot = {};
        self.rotationPartSkrzynia6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSkrzynia6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSkrzynia6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartSkrzynia6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia6#rotTime"), 2)*1000;
        self.rotationPartSkrzynia6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia6#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeSkrzynia7 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartSkrzynia7#index"));
    if rotationPartNodeSkrzynia7 ~= nil then
        self.rotationPartSkrzynia7 = {};
        self.rotationPartSkrzynia7.node = rotationPartNodeSkrzynia7;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia7#minRot"));
        self.rotationPartSkrzynia7.minRot = {};
        self.rotationPartSkrzynia7.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSkrzynia7.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSkrzynia7.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia7#maxRot"));
        self.rotationPartSkrzynia7.maxRot = {};
        self.rotationPartSkrzynia7.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSkrzynia7.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSkrzynia7.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartSkrzynia7.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia7#rotTime"), 2)*1000;
        self.rotationPartSkrzynia7.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia7#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeSkrzynia8 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartSkrzynia8#index"));
    if rotationPartNodeSkrzynia8 ~= nil then
        self.rotationPartSkrzynia8 = {};
        self.rotationPartSkrzynia8.node = rotationPartNodeSkrzynia8;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia8#minRot"));
        self.rotationPartSkrzynia8.minRot = {};
        self.rotationPartSkrzynia8.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSkrzynia8.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSkrzynia8.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia8#maxRot"));
        self.rotationPartSkrzynia8.maxRot = {};
        self.rotationPartSkrzynia8.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSkrzynia8.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSkrzynia8.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartSkrzynia8.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia8#rotTime"), 2)*1000;
        self.rotationPartSkrzynia8.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartSkrzynia8#touchRotLimit"), 10));
    end;
	
    self.numWorklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.worklights = {};
    for i=1, self.numWorklights do
        local worklightnamei = string.format("vehicle.worklights.worklight" .. "%d", i);
        self.worklights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);
    end;	
	self.worklightsActive = false;
	
    self.numWorklights2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights2#count"), 0);
    self.worklights2 = {};
    for i=1, self.numWorklights2 do
        local worklightnamei2 = string.format("vehicle.worklights2.worklight" .. "%d", i);
        self.worklights2[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklightnamei2 .. "#index"));
        setVisibility(self.worklights2[i], false);
    end;	
	self.worklightsActive2 = false;
	
	klaksonFile = Utils.getFilename("sound/horn.wav", self.baseDirectory);
    self.klaksonId = createSample("klakson");
    loadSample(self.klaksonId, klaksonFile, false);
    self.klaksonPlaying = false;
	
	turn1SoundFile = Utils.getFilename("sound/turn1.wav", self.baseDirectory);
    self.turn1 = createSample("turn1");
    loadSample(self.turn1, turn1SoundFile, false);
	
	turn2SoundFile = Utils.getFilename("sound/turn2.wav", self.baseDirectory);
    self.turn2 = createSample("turn2");
    loadSample(self.turn2, turn2SoundFile, false);
	
	fuelwarningSoundFile = Utils.getFilename("sound/fuelwarning.wav", self.baseDirectory);
    self.fuelwarningSoundId = createSample("fuelwarningSound");
    loadSample(self.fuelwarningSoundId, fuelwarningSoundFile, false);
    self.fuelwarningPlaying = false;
	
	self.helpPanel = false;
	self.helpPanel = false;
end;

function JD_8530:delete()

end;

function JD_8530:mouseEvent(posX, posY, isDown, isUp, button)

end;

function JD_8530:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_ then
        self.rundumleuchtenAn = not self.rundumleuchtenAn;
        for i=1, self.rundumleuchtenAnz do
			setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
        end;
    end;
	if isDown and sym == Input.KEY_l then
		self.worklightActive = not self.worklightActive;
	end;
	if isDown and sym == Input.KEY_o then
		self.farlightActive = not self.farlightActive;
	end;
	
	
	if isDown and sym == Input.KEY_KP_0 then
		self.helpPanel = not self.helpPanel;
	end;
	
		
	
	
	if isDown and sym == Input.KEY_g then
		self.chuj = not self.chuj;
	end;
	
	if isDown and sym == Input.KEY_v then
		if self.chuj then
			self.rotationMaxWajcha = true;
		else
			self.rotationMaxWajcha2 = true
		end;
	else
		self.rotationMaxWajcha = false;
		self.rotationMaxWajcha2 = false;
	end;
end;

function JD_8530:update(dt)
	if self.isEntered and Input.isKeyPressed(Input.KEY_w) then
		Utils.setEmittingState(self.dustParticleSystems, false);
	else
		Utils.setEmittingState(self.dustParticleSystems, false);
	end;
	self.rotationMaxSkrzynia = false;
	self.rotationMaxSkrzynia2 = false;
	self.rotationMaxSkrzynia3 = false;
	self.rotationMaxSkrzynia4 = false;
	self.rotationMaxSkrzynia5 = false;
	self.rotationMaxSkrzynia6 = false;
	self.rotationMaxSkrzynia7 = false;
	self.rotationMaxSkrzynia8 = false;
	
	if self.gang02 then
		self.rotationMaxSkrzynia8 = true;
	elseif self.gang01 then
		self.rotationMaxSkrzynia7 = true;
	elseif self.gang1 then
		self.rotationMaxSkrzynia = true;
	elseif self.gang2 then
		self.rotationMaxSkrzynia2 = true;
	elseif self.gang3 then
		self.rotationMaxSkrzynia3 = true;
	elseif self.gang4 then
		self.rotationMaxSkrzynia4 = true;
	elseif self.gang5 then
		self.rotationMaxSkrzynia5 = true;
	elseif self.gang6 then
		self.rotationMaxSkrzynia6 = true;
	end;

	if self.rotationPartSkrzynia ~= nil then
		local x, y, z = getRotation(self.rotationPartSkrzynia.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartSkrzynia.maxRot, self.rotationPartSkrzynia.minRot, 3, self.rotationPartSkrzynia.rotTime, dt, not self.rotationMaxSkrzynia);
		setRotation(self.rotationPartSkrzynia.node, unpack(newRot));
	end;
	
	if self.rotationPartSkrzynia2 ~= nil then
		local x, y, z = getRotation(self.rotationPartSkrzynia2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartSkrzynia2.maxRot, self.rotationPartSkrzynia2.minRot, 3, self.rotationPartSkrzynia2.rotTime, dt, not self.rotationMaxSkrzynia2);
		setRotation(self.rotationPartSkrzynia2.node, unpack(newRot));
	end;
	
	if self.rotationPartSkrzynia3 ~= nil then
		local x, y, z = getRotation(self.rotationPartSkrzynia3.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartSkrzynia3.maxRot, self.rotationPartSkrzynia3.minRot, 3, self.rotationPartSkrzynia3.rotTime, dt, not self.rotationMaxSkrzynia3);
		setRotation(self.rotationPartSkrzynia3.node, unpack(newRot));
	end;
	
	if self.rotationPartSkrzynia4 ~= nil then
		local x, y, z = getRotation(self.rotationPartSkrzynia4.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartSkrzynia4.maxRot, self.rotationPartSkrzynia4.minRot, 3, self.rotationPartSkrzynia4.rotTime, dt, not self.rotationMaxSkrzynia4);
		setRotation(self.rotationPartSkrzynia4.node, unpack(newRot));
	end;
	
	if self.rotationPartSkrzynia5 ~= nil then
		local x, y, z = getRotation(self.rotationPartSkrzynia5.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartSkrzynia5.maxRot, self.rotationPartSkrzynia5.minRot, 3, self.rotationPartSkrzynia5.rotTime, dt, not self.rotationMaxSkrzynia5);
		setRotation(self.rotationPartSkrzynia5.node, unpack(newRot));
	end;
	
	if self.rotationPartSkrzynia6 ~= nil then
		local x, y, z = getRotation(self.rotationPartSkrzynia6.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartSkrzynia6.maxRot, self.rotationPartSkrzynia6.minRot, 3, self.rotationPartSkrzynia6.rotTime, dt, not self.rotationMaxSkrzynia6);
		setRotation(self.rotationPartSkrzynia6.node, unpack(newRot));
	end;
	
	if self.rotationPartSkrzynia7 ~= nil then
		local x, y, z = getRotation(self.rotationPartSkrzynia7.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartSkrzynia7.maxRot, self.rotationPartSkrzynia7.minRot, 3, self.rotationPartSkrzynia7.rotTime, dt, not self.rotationMaxSkrzynia7);
		setRotation(self.rotationPartSkrzynia7.node, unpack(newRot));
	end;
	
	if self.rotationPartSkrzynia8 ~= nil then
		local x, y, z = getRotation(self.rotationPartSkrzynia8.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartSkrzynia8.maxRot, self.rotationPartSkrzynia8.minRot, 3, self.rotationPartSkrzynia8.rotTime, dt, not self.rotationMaxSkrzynia8);
		setRotation(self.rotationPartSkrzynia8.node, unpack(newRot));
	end;

	if self.rotationPartWajcha ~= nil then
		local x, y, z = getRotation(self.rotationPartWajcha.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartWajcha.maxRot, self.rotationPartWajcha.minRot, 3, self.rotationPartWajcha.rotTime, dt, not self.rotationMaxWajcha);
		setRotation(self.rotationPartWajcha.node, unpack(newRot));
	end;

	if self.rotationPartWajcha2 ~= nil then
		local x, y, z = getRotation(self.rotationPartWajcha2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartWajcha2.maxRot, self.rotationPartWajcha2.minRot, 3, self.rotationPartWajcha2.rotTime, dt, not self.rotationMaxWajcha2);
		setRotation(self.rotationPartWajcha2.node, unpack(newRot));
	end;

	if self.rotationPartReczny ~= nil then
		local x, y, z = getRotation(self.rotationPartReczny.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartReczny.maxRot, self.rotationPartReczny.minRot, 3, self.rotationPartReczny.rotTime, dt, not self.rotationMaxReczny);
		setRotation(self.rotationPartReczny.node, unpack(newRot));
	end;

	if self.handbrake then
		self.rotationMaxReczny = true;
	else
		self.rotationMaxReczny = false;
	end;
	
	if Input.isKeyPressed(Input.KEY_0) then
		self.rotationMaxWajchaZaczep = true;
		self.rotationMaxWajchaZaczep2 = false;
	else
		self.rotationMaxWajchaZaczep = false;
	end;
	if Input.isKeyPressed(Input.KEY_9) then
		self.rotationMaxWajchaZaczep2 = true;
		self.rotationMaxWajchaZaczep = false;
	else
		self.rotationMaxWajchaZaczep2 = false;
	end;
	
	if self.rotationPartWajchaZaczep ~= nil then
		local x, y, z = getRotation(self.rotationPartWajchaZaczep.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartWajchaZaczep.maxRot, self.rotationPartWajchaZaczep.minRot, 3, self.rotationPartWajchaZaczep.rotTime, dt, not self.rotationMaxWajchaZaczep);
		setRotation(self.rotationPartWajchaZaczep.node, unpack(newRot));
	end;
	
	if self.rotationPartWajchaZaczep2 ~= nil then
		local x, y, z = getRotation(self.rotationPartWajchaZaczep2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartWajchaZaczep2.maxRot, self.rotationPartWajchaZaczep2.minRot, 3, self.rotationPartWajchaZaczep2.rotTime, dt, not self.rotationMaxWajchaZaczep2);
		setRotation(self.rotationPartWajchaZaczep2.node, unpack(newRot));
	end;
	
	if self.isEntered then
		if self.attachedTrailer then
			self.rotationMaxAttacherPart = true;
			self.translationMax = true;
		else
			self.rotationMaxAttacherPart = false;
			self.translationMax = false;
		end;
	end;
	
	--local doTranslate = self.translationMaxAttacher or self.translationMinAttacher
	--if self.translationPartAttacher ~= nil and doTranslate then
	--	local x, y, z = getTranslation(self.translationPartAttacher.node);
	--	local trans = {x,y,z};
	--	local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartAttacher.maxTrans, self.translationPartAttacher.minTrans, 3, self.translationPartAttacher.transTime, dt, not self.translationMaxAttacher);
	--	setTranslation(self.translationPartAttacher.node, unpack(newTrans));
	--end;
	
	--if self.translationPart ~= nil then
	--	local x, y, z = getTranslation(self.translationPart.node);
    --   local trans = {x,y,z};
    --    local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart.maxTrans, self.translationPart.minTrans, 3, self.translationPart.transTime, dt, not self.translationMax);
    --    setTranslation(self.translationPart.node, unpack(newTrans));
	--end;

	--if self.rotationPartAttacherPart ~= nil then
	--	local x, y, z = getRotation(self.rotationPartAttacherPart.node);
	--	local rot = {x,y,z};
	--	local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartAttacherPart.maxRot, self.rotationPartAttacherPart.minRot, 3, self.rotationPartAttacherPart.rotTime, dt, not self.rotationMaxAttacherPart);
	--	setRotation(self.rotationPartAttacherPart.node, unpack(newRot));
	--end;
	
	if self.rotationPartWischerhebel ~= nil then
		local x, y, z = getRotation(self.rotationPartWischerhebel.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartWischerhebel.maxRot, self.rotationPartWischerhebel.minRot, 3, self.rotationPartWischerhebel.rotTime, dt, not self.rotationMaxWischerhebel);
		setRotation(self.rotationPartWischerhebel.node, unpack(newRot));
	end;
	
	if self.rotationPartBlinkerRechts ~= nil then
		local x, y, z = getRotation(self.rotationPartBlinkerRechts.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartBlinkerRechts.maxRot, self.rotationPartBlinkerRechts.minRot, 3, self.rotationPartBlinkerRechts.rotTime, dt, not self.rotationMaxBlinkerRechts);
		setRotation(self.rotationPartBlinkerRechts.node, unpack(newRot));
	end;
	
	if self.rotationPartBlinkerLinks ~= nil then
		local x, y, z = getRotation(self.rotationPartBlinkerLinks.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartBlinkerLinks.maxRot, self.rotationPartBlinkerLinks.minRot, 3, self.rotationPartBlinkerLinks.rotTime, dt, not self.rotationMaxBlinkerLinks);
		setRotation(self.rotationPartBlinkerLinks.node, unpack(newRot));
	end;
	
	if self.rotationPartTanknadel ~= nil then
		local x, y, z = getRotation(self.rotationPartTanknadel.node);
		y = ((self.rotationPartTanknadel.maxRot[2] - self.rotationPartTanknadel.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel.minRot[2];
		setRotation(self.rotationPartTanknadel.node, x, y ,z);
	end;
	
	if self.rotationPartTanknadel2 ~= nil then
		local x, y, z = getRotation(self.rotationPartTanknadel2.node);
		y = ((self.rotationPartTanknadel2.maxRot[2] - self.rotationPartTanknadel2.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel2.minRot[2];
		setRotation(self.rotationPartTanknadel2.node, x, y ,z);
	end;

	local maxDruck = 10000;
	if self.rotationPartDruck ~= nil then
		local x, y, z = getRotation(self.rotationPartDruck.node);
	--	y = ((self.rotationPartDruck.maxRot[2] - self.rotationPartDruck.minRot[2]) / maxDruck) * self.druckLevel + self.rotationPartDruck.minRot[2];
		setRotation(self.rotationPartDruck.node, x, y ,z);
	end;
	
	local maxDruckLight = 10000;
	if self.rotationPartDruckLight ~= nil then
		local x, y, z = getRotation(self.rotationPartDruckLight.node);
	--	y = ((self.rotationPartDruckLight.maxRot[2] - self.rotationPartDruckLight.minRot[2]) / maxDruckLight) * self.druckLevel + self.rotationPartDruckLight.minRot[2];
		setRotation(self.rotationPartDruckLight.node, x, y ,z);
	end;
	
	local maxDrehzahl = 2800;
	if self.rotationPartDrehzahl1 ~= nil then
		local x, y, z = getRotation(self.rotationPartDrehzahl1.node);
		y = ((self.rotationPartDrehzahl1.maxRot[2] - self.rotationPartDrehzahl1.minRot[2]) / maxDrehzahl) * self.motor.lastMotorRpm + self.rotationPartDrehzahl1.minRot[2];
		setRotation(self.rotationPartDrehzahl1.node, x, y ,z);
	end;
	if self.rotationPartDrehzahl2 ~= nil then
		local x, y, z = getRotation(self.rotationPartDrehzahl2.node);
		y = ((self.rotationPartDrehzahl2.maxRot[2] - self.rotationPartDrehzahl2.minRot[2]) / maxDrehzahl) * self.motor.lastMotorRpm + self.rotationPartDrehzahl2.minRot[2];
		setRotation(self.rotationPartDrehzahl2.node, x, y ,z);
	end;
	
	local maxKmh = 65;
	if self.rotationPartKmh1 ~= nil then
		local x, y, z = getRotation(self.rotationPartKmh1.node);
		y = ((self.rotationPartKmh1.maxRot[2] - self.rotationPartKmh1.minRot[2]) / maxKmh) * self.lastSpeed*3600 + self.rotationPartKmh1.minRot[2];
		setRotation(self.rotationPartKmh1.node, x, y ,z);
	end;
	if self.rotationPartKmh2 ~= nil then
		local x, y, z = getRotation(self.rotationPartKmh2.node);
		y = ((self.rotationPartKmh2.maxRot[2] - self.rotationPartKmh2.minRot[2]) / maxKmh) * self.lastSpeed*3600 + self.rotationPartKmh2.minRot[2];
		setRotation(self.rotationPartKmh2.node, x, y ,z);
	end;
	
	if self.isEntered then
		if Input.isKeyPressed(Input.KEY_w) then
			self.rotationMaxPedal = true;
		else
			self.rotationMaxPedal = false;
		end;
		if Input.isKeyPressed(Input.KEY_s) then
			self.rotationMaxBrake = true;
		else
			self.rotationMaxBrake = false;
		end;
		if self.gang0 then
			self.rotationMaxClutch = true;
		else
			self.rotationMaxClutch = false;
		end;
	end
	
	if self.rotationPartPedal ~= nil then
		local x, y, z = getRotation(self.rotationPartPedal.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartPedal.maxRot, self.rotationPartPedal.minRot, 3, self.rotationPartPedal.rotTime, dt, not self.rotationMaxPedal);
		setRotation(self.rotationPartPedal.node, unpack(newRot));
	end;
	
	if self.rotationPartBrake ~= nil then
		local x, y, z = getRotation(self.rotationPartBrake.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartBrake.maxRot, self.rotationPartBrake.minRot, 3, self.rotationPartBrake.rotTime, dt, not self.rotationMaxBrake);
		setRotation(self.rotationPartBrake.node, unpack(newRot));
	end;
	
	if self.rotationPartClutch ~= nil then
		local x, y, z = getRotation(self.rotationPartClutch.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartClutch.maxRot, self.rotationPartClutch.minRot, 3, self.rotationPartClutch.rotTime, dt, not self.rotationMaxClutch);
		setRotation(self.rotationPartClutch.node, unpack(newRot));
	end;
	
	if self.isEntered then
		if self.fuelFillLevel < 50 then
			self.tankwarn = self.tankwarn - dt;
			if self.tankwarn <= 0 then
				playSample(self.fuelwarningSoundId,1,1,0);
				self.tankwarn = 30000;
			end;
			self.tanklightActive = true;
		else
			self.tankwarn = 30000;
			self.tanklightActive = false;
		end;
		setVisibility(self.tanklight,self.tanklightActive);
		setVisibility(self.tank2light,self.tanklightActive);
	end;

	
	if self.wycieraczki then
		self.wyc = self.wyc - dt;
		if self.wyc < 0 then
			self.rotationMaxLeft = not self.rotationMaxLeft;
			self.rotationMaxLeft2 = not self.rotationMaxLeft2;
			self.wyc = 650;
		end;
		self.rotationMaxWischerhebel = true;
	else
		self.rotationMaxWischerhebel = false;
	end;
	setVisibility(self.drucklight,self.drucklightActive);
	setVisibility(self.druck2light,self.drucklightActive);
	setVisibility(self.druck3light,not self.drucklightActive);
	setVisibility(self.worklight, self.worklightActive);
	setVisibility(self.worklight2, self.worklightActive);
	setVisibility(self.farlight, self.farlightActive);
	setVisibility(self.farlight2, self.farlightActive);
	setVisibility(self.rundum, self.rundumleuchtenAn);
	setVisibility(self.warn, self.warnLightActive);
	setVisibility(self.duals, self.dualsActive);
	setVisibility(self.duals2, self.dualsActive);
	setVisibility(self.duals3, self.dualsActive);
	setVisibility(self.duals4, self.dualsActive);
	setVisibility(self.blinkerleft, self.blinkerleftActive);
	setVisibility(self.blinkerright, self.blinkerrightActive);
	
	
	if self.klaksonAllow and not self.klaksonPlaying then
		playSample(self.klaksonId,0,1,0);
		self.klaksonPlaying = true;
	elseif not self.klaksonAllow and self.klaksonPlaying then
		stopSample(self.klaksonId);
		self.klaksonPlaying = false;
	end;
	
	if self.rundumleuchtenAn == true then
		setVisibility(self.rullight, true);
	else
		setVisibility(self.rullight, false);
	end;
		
    if self.rundumleuchtenAnz > 0 then
      if self.rundumleuchtenAn then
        for i=1, self.rundumleuchtenAnz do
          rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
        end;
      end;
    end;
	
	if self.rotationPartLeft ~= nil then
		local x, y, z = getRotation(self.rotationPartLeft.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft.maxRot, self.rotationPartLeft.minRot, 3, self.rotationPartLeft.rotTime, dt, not self.rotationMaxLeft);
		setRotation(self.rotationPartLeft.node, unpack(newRot));
	end;
	
	if self.rotationPartLeft2 ~= nil then
		local x, y, z = getRotation(self.rotationPartLeft2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft2.maxRot, self.rotationPartLeft2.minRot, 3, self.rotationPartLeft2.rotTime, dt, not self.rotationMaxLeft2);
		setRotation(self.rotationPartLeft2.node, unpack(newRot));
	end;
	

	   if self.worklightsActive then
			for i=1, self.numWorklights do
				local worklight = self.worklights[i];
				setVisibility(worklight, self.worklightsActive);
			end;
		else
			for i=1, self.numWorklights do
				local worklight = self.worklights[i];
				setVisibility(worklight, self.worklightsActive, false);
			end;
		end;

	
	   if self.worklightsActive2 then
			for i=1, self.numWorklights2 do
				local worklight2 = self.worklights2[i];
				setVisibility(worklight2, self.worklightsActive2);
			end;
		else
			for i=1, self.numWorklights2 do
				local worklight2 = self.worklights2[i];
				setVisibility(worklight2, self.worklightsActive2, false);
			end;
		end;
end;

function JD_8530:draw()
	if self.isEntered then
		if not self.helpPanel then
			renderText(0.72, 0.25, 0.02, "Tasto KP0: Info On");
		else
			renderText(0.72, 0.25, 0.02, "Tasto KP0: Info Off");
		end;
		if self.helpPanel then
			renderText(0.02, 0.56, 0.023, "- Same DIAMOND 265 Info -");
			
			if self.flashRight then
				renderText(0.02, 0.36, 0.021, "Tasto Num 3: Freccia dx. On/Off");
			else
				renderText(0.02, 0.36, 0.021, "Tasto Num 3: Freccia dx. On/Off");
			end;
			if self.flashLeft then
				renderText(0.02, 0.40, 0.021, "Tasto Num 1: Freccia sx. On/Off");
			else
				renderText(0.02, 0.40, 0.021, "Tasto Num 1: Freccia sx. On/Off");
			end;
			if self.flash then
				renderText(0.02, 0.38, 0.021, "Tasto Num 2: Emergenza On/Off");
			else
				renderText(0.02, 0.38, 0.021, "Tasto Num 2: Emergenza On/Off");
			end;
			if self.worklightActive then
				renderText(0.02, 0.44, 0.021, "Tasto Num 5: Luci lavoro ant. On/Off");
			else
				renderText(0.02, 0.44, 0.021, "Tasto Num 5: Luci lavoro ant. On/Off");
			end;
			if self.farlightActive then
				renderText(0.02, 0.46, 0.021, "Tasto Num 6: Luci lavoro post. On/Off");
			else
				renderText(0.02, 0.46, 0.021, "Tasto Num 6: Luci lavoro post. On/Off");
			end;
			if self.dualsActive then
				renderText(0.02, 0.48, 0.021, "");
			else
				renderText(0.02, 0.48, 0.021, "");
			end;
			if self.wycieraczki then
				renderText(0.02, 0.54, 0.021, "Tasto F: Luci On/Off(premuto Abbaglianti)");
			else
				renderText(0.02, 0.54, 0.021, "Tasto F: Luci On/Off(premuto Abbaglianti)");
			end;
			renderText(0.02, 0.52, 0.021, "Tasto c: Cambia Camera");
			renderText(0.02, 0.50, 0.021, "Tasto 8: Autopilot");
			renderText(0.02, 0.42, 0.021, "Tasto Home: Lampeggiante");
			renderText(0.02, 0.34, 0.021, "Tasto 0: Claxon");
			renderText(0.02, 0.32, 0.021, "Tasto Pgup/Pgdown: Limitatore Up/Down");
			renderText(0.02, 0.30, 0.021, "Mouse Dx.: Courseplay");
			renderText(0.02, 0.28, 0.021, "Tasto k: Accensione On/Off");
		end;
	end;
end;

function JD_8530:onEnter()
	
end;

function JD_8530:onLeave()

end;
