ParticleSystem = {};

function ParticleSystem.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ParticleSystem:load(xmlFile)
	
-- Dynamischer Auspuffqualm
	self.extraPS = {};
	self.extraPS.lastlos = {};
	self.extraPS.speedLimits = {Utils.getVectorFromString(getXMLString(xmlFile,"vehicle.exhaustParticleSystemExtra#speedLimits"))};
	for speedIndex=1,3 do
	    self.extraPS.lastlos[speedIndex] = {};
	    local c=0;
	    while true do
	    		local psstring = string.format("vehicle.exhaustParticleSystemExtra.lastlos.speed%d.particleSystem(%d)",speedIndex,c);
	    		if getXMLString(xmlFile, psstring.."#file") ~= nil then
	    			Utils.loadParticleSystem(xmlFile, self.extraPS.lastlos[speedIndex],psstring, self.components, false, nil, self.baseDirectory);
	    		else
	    			break;
	    		end;
	    		c=c+1;
	    	end;
	end;

	self.extraPS.last = {};
	for speedIndex=1,3 do
	    self.extraPS.last[speedIndex] = {};
	    local c=0;
	    while true do
	    		local psstring = string.format("vehicle.exhaustParticleSystemExtra.last.speed%d.particleSystem(%d)",speedIndex,c);
	    		if getXMLString(xmlFile, psstring.."#file") ~= nil then
	    			Utils.loadParticleSystem(xmlFile, self.extraPS.last[speedIndex],psstring, self.components, false, nil, self.baseDirectory);
	    		else
	    			break;
	    		end;
	    		c=c+1;
	    	end;
	end;

-- Dynamischer Auspuffqualm Ende

end;

function ParticleSystem:keyEvent(unicode, sym, modifier, isDown)

end;

function ParticleSystem:update(dt)

	if self:getIsActive() then
		local speed = self.lastSpeed*3600;
		if table.getn(self.attachedImplements) > 0 then
			-- belastet
			if speed > self.extraPS.speedLimits[1] and speed < self.extraPS.speedLimits[2] then
				Utils.setEmittingState(self.extraPS.last[1], true);
			else
				Utils.setEmittingState(self.extraPS.last[1], false);
			end;
			
			if speed > self.extraPS.speedLimits[2] and speed < self.extraPS.speedLimits[3] then
				Utils.setEmittingState(self.extraPS.last[2], true);
			else
				Utils.setEmittingState(self.extraPS.last[2], false);
			end;

			if speed > self.extraPS.speedLimits[3] then
				Utils.setEmittingState(self.extraPS.last[3], true);
			else
				Utils.setEmittingState(self.extraPS.last[3], false);
			end;
		else
			-- entlastet
			if speed > self.extraPS.speedLimits[1] and speed < self.extraPS.speedLimits[2] then
				Utils.setEmittingState(self.extraPS.lastlos[1], true);
			else
				Utils.setEmittingState(self.extraPS.lastlos[1], false);
			end;
			
			if speed > self.extraPS.speedLimits[2] and speed < self.extraPS.speedLimits[3] then
				Utils.setEmittingState(self.extraPS.lastlos[2], true);
			else
				Utils.setEmittingState(self.extraPS.lastlos[2], false);
			end;

			if speed > self.extraPS.speedLimits[3] then
				Utils.setEmittingState(self.extraPS.lastlos[3], true);
			else
				Utils.setEmittingState(self.extraPS.lastlos[3], false);
			end;
		end;
	end;
end;

function ParticleSystem:draw()
end;

function ParticleSystem:onEnter()
end;

function ParticleSystem:onLeave()
	for i=1,3 do
		Utils.setEmittingState(self.extraPS.last[i], false);
		Utils.setEmittingState(self.extraPS.lastlos[i], false);
	end;
end;

function ParticleSystem:delete()
	for i=1,3 do
		Utils.deleteParticleSystem(self.extraPS.last[i]);
		Utils.deleteParticleSystem(self.extraPS.lastlos[i]);
	end;
end;

function ParticleSystem:mouseEvent(posX, posY, isDown, isUp, button)
end;

