--
-- neptun, kobajn buraczany
-- by majster2009
-- LS2011: Burner
--




neptun = {};

function neptun.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function neptun:load(xmlFile)
	self.currentFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
    self.wasToFast = false;
	self.isTurnedOn = false;
	self.fillScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillScale#value"), 1);
	self.beben = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.beben#index"));	
end;


function neptun:update(dt)
	if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
            self.isTurnedOn = not self.isTurnedOn;
        end;
    end;
	self.wasToFast = false;
	if self:getIsActive() then
		if self.isTurnedOn and self.fillLevel < self.capacity then
			rotate(self.beben, dt*0.015, 0, 0 );
			local toFast = self:doCheckSpeedLimit() and self.attacherVehicle.lastSpeed*3600 > 20;
            if not toFast then				
				local area =0;
                for k, cuttingArea in pairs(self.cuttingAreas) do
                    local x,y,z = getWorldTranslation(cuttingArea.start);
                    local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                    local x2,y2,z2 = getWorldTranslation(cuttingArea.height);

                    for fillType,v in pairs(self.fillTypes) do
                        if fillType ~= Fillable.FILLTYPE_UNKNOWN then
							if self.currentFillType == fillType or self.currentFillType == Fillable.FILLTYPE_UNKNOWN then
								local fruitType = FruitUtil.fillTypeToFruitType[fillType];
								Utils.updateFruitCutShortArea(fruitType, x, z, x1, z1, x2, z2, 1);
								local area = Utils.cutFruitArea(fruitType, x, z, x1, z1, x2, z2, 0)
								area = area + Utils.cutFruitArea(fruitType, x, z, x1, z1, x2, z2, 0);
								if area > 0 then
									self.currentFruitType = fruitType;
									local pixelToQm = 2048 / 4096 * 2048 / 4096  / g_currentMission.maxFruitValue; -- 4096px are mapped to 2048m
									local literPerQm = FruitUtil.fruitIndexToDesc[fruitType].literPerSqm * (0.50 * (3 - g_currentMission.missionStats.difficulty));
									local qm = area*pixelToQm;
									local deltaLevel = qm*literPerQm * self.fillScale;
									self:setFillLevel(self.fillLevel+deltaLevel, fillType);
								end;
							end;
                        end;
                    end;
                end;							
            end;
            self.wasToFast = toFast;
		end;
	end; ---if self:getIsActive() then
end;

function neptun:mouseEvent(posX, posY, isDown, isUp, button)
end;

function neptun:keyEvent(unicode, sym, modifier, isDown)
end;

function neptun:draw()
	if self.isTurnedOn then
        g_currentMission:addExtraPrintText("Wcisnij B: Wylacz Neptuna");
    else
        g_currentMission:addExtraPrintText("Wcisnij B: Wlacz Neptuna");
    end;
	if self.attacherVehicle.lastSpeed*3600 > 21 and self.isTurnedOn then
		g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "1", InputBinding.getKeyNamesOfDigitalAction(InputBinding.SPEED_LEVEL1)), 0.07+0.022, 0.019+0.029);
	end;	
end;

function neptun:onAttach()
end; 	

function neptun:onDetach()
	self.isTurnedOn = false;
end;

function neptun:onDeactivate()
	self.isTurnedOn = false;
end;

function neptun:delete()
end;

function neptun:onLeave()
end;