--
-- Feeding
--
-- @poc@lypse



Feeding = {};

function Feeding:onCreate(id)
	
	Feeding:load(id);	
end;

FeedingOnCreate = Feeding.onCreate;


function Feeding:load(id) 
    addTrigger(id, "FeedingCallback", self);
    self.deleteListenerId = addDeleteListener(id, "delete", self);
    self.ballenPosIndex = Utils.indexToObject(id, getUserAttribute(id, "ballenPosIndex"));
    self.foin = getChildAt(id, 0);
    self.hasBale = false;
    setVisibility(self.foin, false); 
    self.dectime = 3600;
    self.triggerId = id;
 self.baleTypes = {};
  local file = self.baleTypes;
for i=1, 2 do
  file[i] = {};    
   file[1] = "data/maps/models/objects/strawbale/haybaleBaler.i3d";
   file[2] = "data/maps/models/objects/roundbales/roundbaleHay.i3d";
end; 
end;

function Feeding:loadMap(name)
end;

function Feeding:deleteMap()
removeTrigger(self.triggerId);
removeDeleteListener(self.triggerId, self.deleteListenerId);
end;

function Feeding:delete()
end;

function Feeding:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Feeding:keyEvent(unicode, sym, modifier, isDown)
end;

function Feeding:update(dt)
local numcows = AnimalHusbandry.getNumberOfAnimals();
local fillType = Fillable.FILLTYPE_FEEDING;
local siloAmount = g_currentMission:getSiloAmount(fillType);
if siloAmount == 0 then
    setVisibility(self.foin, false);    
    self.hasBale = false;
  end;
if siloAmount > 0 then
self.hasBale = true;
setVisibility(self.foin, true);
end;
local tscale = 0;
if numcows > 0 and numcows <= 5 then
tscale = 0.005;
elseif numcows > 5 and numcows <= 10 then
tscale = 0.008;
elseif numcows > 10 then 
tscale = 0.01;
end;
if self.hasBale and numcows > 0 then 
   if self.dectime > 1 then      
       self.dectime = self.dectime - dt*tscale*g_currentMission.environment.timeScale;       
    end;
    if self.dectime < 1 then
      local delta = 1
      g_currentMission:setSiloAmount(fillType, math.max(siloAmount-delta, 0));
       self.dectime = 3600;
    end;      
end;
if not self.hasBale then
	local nearestBale = ObjectInRange(self);                            		
end;


end;


function Feeding:draw()
end;

function ObjectInRange(self)
	local nearestObject = nil;	
	local nearestDistance = 1;
        local refnod = self.ballenPosIndex;        
	local px, py, pz = getWorldTranslation(refnod);           
	for index, item in pairs(g_currentMission.itemsToSave) do            
               if item.item:isa(Bale) then                                         
                      for _, filename in pairs(self.baleTypes) do 
                            if item.item.i3dFilename == filename then     
                               	local vx, vy, vz = getWorldTranslation(item.item.nodeId);
                                print(vx);
				local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
                                if distance < nearestDistance then                                                                                                                     
					index = i
					nearestObject = item.item;
					nearestDistance = distance;                                                                                                               
                                        self.hasBale = true;                                         
                                        setRigidBodyType(item.item.nodeId,"none");
                                        link(refnod,item.item.nodeId);
                                        local object = g_currentMission:getNodeObject(item.item.nodeId);                                           
                                        object:delete(); 
                                        local fillType = Fillable.FILLTYPE_FEEDING;
                                        local siloAmount = g_currentMission:getSiloAmount(fillType);                                                                            
                                        g_currentMission:setSiloAmount(fillType, math.min(siloAmount +500));                             
                                                                  
                                           				
				end;
                                 break; 
                           end; 
                      end;                            		
	      end;
	end;
	return nearestObject;
end;
addModEventListener(Feeding);

