--
-- movingPiles
--
-- @poc@lypse



movingPiles = {};
movingPiles.tasMoving = {};


function movingPiles:onCreate(id)
	
	movingPiles:load(id);	
end;

movingPilesOnCreate = movingPiles.onCreate;


function movingPiles:load(id)
 self.triggerId = id;	
    addTrigger(id, "movingPilesCallback", self);
    self.deleteListenerId = addDeleteListener(id, "delete", self);  
        local entry = {};
	local fruit = getUserAttribute(id, "fruitTypes");
        local key = "FRUITTYPE_"..string.upper(fruit);
        local parent = getParent(id);
        local movingIndex = getUserAttribute(id, "movingPilesIndex");
	local fillFruit = FruitUtil[key];
        entry.fillType = FruitUtil.fruitTypeToFillType[fillFruit];    
        entry.movingId = Utils.indexToObject(parent, movingIndex);
        entry.moveMaxY = Utils.getNoNil(getUserAttribute(id, "moveMaxY"), 0);
        entry.moveScale = Utils.getNoNil(getUserAttribute(id, "moveScale"), 0.001)*0.01;                          
        entry.id = id;
        table.insert(self.tasMoving, entry);
   
            
end;


function movingPiles:loadMap(name)
end;

function movingPiles:deleteMap()
removeTrigger(self.triggerId);
removeDeleteListener(self.triggerId, self.deleteListenerId);
end;

function movingPiles:delete()
end;

function movingPiles:readStream(streamId, connection)

   if connection:getIsServer() then
          for i=1, table.getn(self.tasMoving) do
            local htmoving = g_currentMission:getSiloAmount(self.tasMoving[i].fillType);
              if htmoving > 0 then  
                if self.tasMoving[i].movingId ~= nil then     
                  local x,y,z = getTranslation(self.tasMoving[i].movingId);
                  local newY = math.min(htmoving*self.tasMoving[i].moveScale, self.tasMoving[i].moveMaxY);
                  newY = streamReadFloat32(streamId);
                  setTranslation(self.tasMoving[i].movingId, x, newY, z); 
                end;
              end;
          end;
     end;
 end;

function movingPiles:writeStream(streamId, connection)
if not connection:getIsServer() then
  for i=1, table.getn(self.tasMoving) do
    if self.tasMoving[i].movingId ~= nil then     
    local x,y,z = getTranslation(self.tasMoving[i].movingId);
        streamWriteFloat32(streamId, y);
    end;
  end;
end;
end;

function movingPiles:readUpdateStream(streamId, timestamp, connection)
     self:readStream(streamId, connection);
end;

function movingPiles:readUpdateStream(streamId, timestamp, connection)
    self:readStream(streamId, connection);
end;

function movingPiles:writeUpdateStream(streamId, connection, dirtyMask)
   self:writeStream(streamId, connection);
  end;
  


function movingPiles:mouseEvent(posX, posY, isDown, isUp, button)
end;

function movingPiles:keyEvent(unicode, sym, modifier, isDown)
end;

function movingPiles:update(dt)

	     for i=1, table.getn(self.tasMoving) do
                 local htmoving = g_currentMission:getSiloAmount(self.tasMoving[i].fillType);
               if htmoving > 0 then 
                 if self.tasMoving[i].movingId ~= nil then                
          	 local x,y,z = getTranslation(self.tasMoving[i].movingId);        
                 local newY = math.min(htmoving*self.tasMoving[i].moveScale, self.tasMoving[i].moveMaxY);
                 setTranslation(self.tasMoving[i].movingId, x, newY, z); 
                end;
               end; 
                                             
            end;

end;

function movingPiles:draw()
end;


addModEventListener(movingPiles);

