-- @poc@lypse

OpenBarel = {};
OpenBarel.Opening = {};

function OpenBarel:onCreate(id)	
	OpenBarel:load(id);	
end;

OpenBarelOnCreate = OpenBarel.onCreate;

function OpenBarel:loadMap(name)
end;

function OpenBarel:draw()
end;

function OpenBarel:mouseEvent(posX, posY, isDown, isUp, button)
end;

function OpenBarel:keyEvent(unicode, sym, modifier, isDown)
end;


function OpenBarel:load(id)
 self.triggerId = id;
     addTrigger(id, "triggerCallback", self); 
     self.deleteListenerId = addDeleteListener(id, "delete", self);     
        local entry = {};
        local parent = getParent(id);        
        local DoorIndex = getUserAttribute(id, "DoorIndex");        
        entry.DoorId = Utils.indexToObject(parent, DoorIndex);
        entry.Rotmin = Utils.getNoNil(getUserAttribute(id, "Rotmin"), 0);
        entry.Rotmax = Utils.getNoNil(getUserAttribute(id, "RotMax"), 0);                     
        entry.id = id;
        table.insert(self.Opening, entry);
        self.translateDoor = false;
        self.open = false;        
end;

function OpenBarel:deleteMap()   
removeTrigger(self.triggerId);
removeDeleteListener(self.triggerId, self.deleteListenerId);
end;

function OpenBarel:update(dt)  
   for i=1, table.getn(self.Opening) do
        if self.translateDoor and InputBinding.hasEvent(InputBinding.OpenBarel) and not self.open then
                  setRotation(self.Opening[i].DoorId, 0,self.Opening[i].Rotmax,0);  
                   self.open = true;                
        elseif self.translateDoor and InputBinding.hasEvent(InputBinding.OpenBarel) and self.open then            
	          setRotation(self.Opening[i].DoorId, 0,self.Opening[i].Rotmin,0); 
                   self.open = false;                 
        end;    
   end;
end;

function OpenBarel:draw()	
	if self.translateDoor then		
			g_currentMission:addExtraPrintText("Open/Close: "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.OpenBarel));		
	end;	
end;


function OpenBarel:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
     if onEnter then
        	if g_currentMission.player ~= nil then
			if otherId == g_currentMission.player.rootNode then				
                                self.translateDoor = true; 
			end;
		end;                   
    elseif onLeave then
       if g_currentMission.player ~= nil then
			if otherId == g_currentMission.player.rootNode then				
                                self.translateDoor = false; 
			end;
		end;
    end;

end;


addModEventListener(OpenBarel);