-- @poc@lypse

OpenDoor = {};
OpenDoor.Opening = {};

function OpenDoor:onCreate(id)	
	OpenDoor:load(id);	
end;

OpenDoorOnCreate = OpenDoor.onCreate;

function OpenDoor:loadMap(name)
end;

function OpenDoor:draw()
end;

function OpenDoor:mouseEvent(posX, posY, isDown, isUp, button)
end;

function OpenDoor:keyEvent(unicode, sym, modifier, isDown)
end;


function OpenDoor:load(id)
 self.triggerId = id;
     addTrigger(id, "triggerCallback", self); 
     self.deleteListenerId = addDeleteListener(id, "delete", self);     
        local entry = {};
        local parent = getParent(id);        
        local DoorIndex = getUserAttribute(id, "DoorIndex");        
        entry.DoorId = Utils.indexToObject(parent, DoorIndex);      
        entry.TransX = Utils.getNoNil(getUserAttribute(id, "TransX"), 0); 
        entry.TransY = Utils.getNoNil(getUserAttribute(id, "TransY"), 0); 
        entry.TransZmin = Utils.getNoNil(getUserAttribute(id, "TransZmin"), 0); 
        entry.TransZmax = Utils.getNoNil(getUserAttribute(id, "TransZmax"), 0);
        entry.id = id;
        table.insert(self.Opening, entry);
        self.translateDoor = false;        
        self.open = false;
end;

function OpenDoor:deleteMap()   
removeTrigger(self.triggerId);
    removeDeleteListener(self.triggerId, self.deleteListenerId);
end;

function OpenDoor:update(dt)
  
   for i=1, table.getn(self.Opening) do   
        if self.translateDoor and InputBinding.hasEvent(InputBinding.OpenDoor) and not self.open then 
	          setTranslation(self.Opening[i].DoorId, self.Opening[i].TransX,self.Opening[i].TransY,self.Opening[i].TransZmax);
                  self.open = true;
        elseif self.translateDoor and InputBinding.hasEvent(InputBinding.OpenDoor) and self.open then           
                  setTranslation(self.Opening[i].DoorId, self.Opening[i].TransX,self.Opening[i].TransY,self.Opening[i].TransZmin);
                  self.open = false;
        end;    
   end;
end;

function OpenDoor:draw()

	
	if self.translateDoor then		
			g_currentMission:addExtraPrintText("Open/Close: "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.OpenDoor));		
	end;
	
end;



function OpenDoor:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
   
    if onEnter then
        	if g_currentMission.player ~= nil then
			if otherId == g_currentMission.player.rootNode then				
                                self.translateDoor = true; 
			end;
		end;                   
    elseif onLeave then
       if g_currentMission.player ~= nil then
			if otherId == g_currentMission.player.rootNode then				
                                self.translateDoor = false; 
			end;
		end;
    end;

end;


addModEventListener(OpenDoor);