--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;


function ShowHelp:draw()
	if not self.showHelp then
		renderText(0.757, 0.22, 0.018, "Numpad 0:");
		renderText(0.865, 0.22, 0.018, "Info einblenden");
		g_currentMission:addHelpButtonText(g_i18n:getText("ShowHelp1"), InputBinding.HUDINFO);
	 else
		-- Koordinaten sind aus der F930.lua - Author leider unbekannt
		renderText(0.757, 0.22, 0.018, "Numpad 0:");
		renderText(0.865, 0.22, 0.018, "Info ausblenden");
		renderText(0.757, 0.235, 0.018, "Numpad 1:");
		renderText(0.865, 0.235, 0.018, "Blinker Links");
		renderText(0.757, 0.25, 0.018, "Numpad 2:");
		renderText(0.865, 0.25, 0.018, "Warnblinker");
		renderText(0.757, 0.265, 0.018, "Numpad 3:");
		renderText(0.865, 0.265, 0.018, "Blinker Rechts");
		renderText(0.757, 0.28, 0.018, "Numpad 4:");
		renderText(0.865, 0.28, 0.018, "Zwillinge hinten");
		renderText(0.757, 0.295, 0.018, "Numpad 5:");
		renderText(0.865, 0.295, 0.018, "Zusatzlicht vorne");
		renderText(0.757, 0.31, 0.018, "Numpad 6:");
		renderText(0.865, 0.31, 0.018, "Zusatzlicht hinten");
		renderText(0.757, 0.325, 0.018, "Numpad 7:");
		renderText(0.865, 0.325, 0.018, "Zwillinge vorne");
		renderText(0.757, 0.34, 0.018, "Numpad 8:");
		renderText(0.865, 0.34, 0.018, "Fanfare");
		renderText(0.757, 0.355, 0.018, "Numpad 9:");
		renderText(0.865, 0.355, 0.018, "Allrad an/aus");
		renderText(0.757, 0.37, 0.018, "Numpad Enter:");
		renderText(0.865, 0.37, 0.018, "Motor an/aus");
		renderText(0.757, 0.385, 0.018, "Numpad Komma:");
		renderText(0.865, 0.385, 0.018, "Fronthydraulik");
		renderText(0.757, 0.40, 0.018, "F:");
		renderText(0.865, 0.40, 0.018, "Abblendlicht");
		renderText(0.757, 0.415, 0.018, "F halten:");
		renderText(0.865, 0.415, 0.018, "Fernlicht");
		renderText(0.757, 0.43, 0.018, "Pos1:");
		renderText(0.865, 0.43, 0.018, "Rundumleuchte");		
		renderText(0.757, 0.445, 0.018, "0:");
		renderText(0.865, 0.445, 0.018, "Hupe");
		renderText(0.757, 0.46, 0.018, "Bild Ab:");
		renderText(0.865, 0.46, 0.018, "RPM -");
		renderText(0.757, 0.475, 0.018, "Bild Auf:");
		renderText(0.865, 0.475, 0.018, "RPM +");
		renderText(0.757, 0.49, 0.018, "F2:");
		renderText(0.865, 0.49, 0.018, "Zugmaul Info");
		renderText(0.757, 0.505, 0.018, "F3");
		renderText(0.865, 0.505, 0.018, "Feldspuren an/aus");
		renderText(0.757, 0.52, 0.018, "F4");
		renderText(0.865, 0.52, 0.018, "vorderer Fender");

		g_currentMission:addHelpButtonText(g_i18n:getText("ShowHelp2"), InputBinding.HUDINFO);
	end;
end;

function ShowHelp:onLeave()
	self.showHelp = false;
end;

