Setblends3Event = {};
Setblends3Event_mt = Class(Setblends3Event, Event);
InitEventClass(Setblends3Event, "Setblends3Event");
function Setblends3Event:emptyNew()
      local self = Event:new(Setblends3Event_mt);
      self.className="Setblends3Event";
      return self;
end;
function Setblends3Event:new(object, active)
      local self = Setblends3Event:emptyNew()
      self.active = active;
      self.object = object;
      return self;
end;
function Setblends3Event:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.active = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
function Setblends3Event:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.active);
end;
function Setblends3Event:run(connection)
      self.object:Setblends3Visibility(self.active, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(Setblends3Event:new(self.object, self.active), nil, connection, self.object);
      end;
end;