Setblends2Event = {};
Setblends2Event_mt = Class(Setblends2Event, Event);
InitEventClass(Setblends2Event, "Setblends2Event");
function Setblends2Event:emptyNew()
      local self = Event:new(Setblends2Event_mt);
      self.className="Setblends2Event";
      return self;
end;
function Setblends2Event:new(object, active)
      local self = Setblends2Event:emptyNew()
      self.active = active;
      self.object = object;
      return self;
end;
function Setblends2Event:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.active = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
function Setblends2Event:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.active);
end;
function Setblends2Event:run(connection)
      self.object:Setblends2Visibility(self.active, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(Setblends2Event:new(self.object, self.active), nil, connection, self.object);
      end;
end;