--
-- lizard2000
-- Specialization for lizard2000 mod
--
-- @author  Stefan Geiger
-- @date  10/01/09
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

PThorn = {};

function PThorn.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function PThorn:load(xmlFile)
    hornSoundFile = Utils.getFilename("PThorn.wav", self.baseDirectory);
    self.hornSoundId = createSample("PThornsound");
    loadSample(self.hornSoundId, hornSoundFile, false);
    self.hornPlaying = false;
end;

function PThorn:delete()
    delete(self.burnerSoundId);
end;

function PThorn:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PThorn:keyEvent(unicode, sym, modifier, isDown)
end;

function PThorn:update(dt)
	if self:getIsActiveForInput() and self:getIsActiveForSound() and InputBinding.isPressed(InputBinding.PThorn_PThorn) then
        if not self.hornPlaying then
            playSample(self.hornSoundId, 0, 0.35, 0);
            self.hornPlaying = true;
        end;
    else
        if self.hornPlaying then
            stopSample(self.hornSoundId);
            self.hornPlaying = false;
        end;
    end;
end;

function PThorn:draw()
end;

