--
-- AllradV2
-- Specialization for Allrad
--
-- by modelleicher
-- www.schwabenmodding.bplaced.net
-- MP Fhig!


PITAllradV2 = {};

function PITAllradV2.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function PITAllradV2:load(xmlFile)

    self.allradState = PITAllradV2.allradState;

    self.PITAllradV2Active = false;
	 
	self.wellenCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Allradwellen.Wellen#count"), 0);	 
	self.Wellen = {}
	if self.wellenCount ~= 0 and self.wellenCount ~= nil then
	    for i=1, self.wellenCount do
	        local Welle = string.format("vehicle.Allradwellen.Welle%d", i)
		    self.Wellen[i] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, Welle .. "#index"));
	    end;
	end;
	self.hudAllradonPosX = 0.68;
    self.hudAllradonWidth = 0.08;
    self.hudAllradonPosY = 0.015;
    self.hudAllradonHeight = 0.195;
	
	self.infoPanelAllradPath = Utils.getFilename("allrad_symbol_on.png", self.baseDirectory);
	self.hudAllradonOverlay = Overlay:new("allrad_symbol_on", self.infoPanelAllradPath, self.hudAllradonPosX, self.hudAllradonPosY, self.hudAllradonWidth, self.hudAllradonHeight);
	
	self.infoPanelAllradPath1 = Utils.getFilename("allrad_symbol_off.png", self.baseDirectory);
	self.hudAllradoffOverlay = Overlay:new("allrad_symbol_off", self.infoPanelAllradPath1, self.hudAllradonPosX, self.hudAllradonPosY, self.hudAllradonWidth, self.hudAllradonHeight);	
	
	self.showhudAllradon = false;

end;

function PITAllradV2:delete()
    if self.hudAllradonOverlay ~= nil then
		self.hudAllradonOverlay:delete();
	end;
	if self.hudAllradonOverlay ~= nil then
		self.hudAllradoffOverlay:delete();
	end;
end;

function PITAllradV2:readStream(streamId, connection)  
     self:allradState(streamReadBool(streamId), true);  
end;

function PITAllradV2:writeStream(streamId, connection)  
    streamWriteBool(streamId, self.PITAllradV2Active);  
end;

function PITAllradV2:mouseEvent(posX, posY, isDown, isUp, button)
end;
function PITAllradV2:keyEvent(unicode, sym, modifier, isDown)
end;

function PITAllradV2:allradState(state, noEventSend)  
    AllradStateEvent.sendEvent(self, state, noEventSend);	
    self.PITAllradV2Active = state;
end;

function PITAllradV2:update(dt)
    if self:getIsActiveForInput() then  
		if InputBinding.hasEvent(InputBinding.PITAllradV2) then
		   	self.PITAllradV2Active = not self.PITAllradV2Active;
		end;
    end;	
	if self:getIsActive() then	
   		if self.PITAllradV2Active == true then
			self.showhudAllradon = true;
			self.showhudAllradoff = false;			
			self.wheels[1].driveMode =2
		 	self.wheels[2].driveMode =2
		 	self.wheels[3].driveMode =2
		 	self.wheels[4].driveMode =2			
		else
			self.showhudAllradon = false;
			self.showhudAllradoff = true;
		 	self.wheels[1].driveMode =0
			self.wheels[2].driveMode =0
			self.wheels[3].driveMode =2
			self.wheels[4].driveMode =2			
		end; 
	    if self.wellenCount ~= 0 and self.wellenCount ~= nil then
	      local getRx, getRy, getRz = getRotation(self.wheels[3].repr);
	      for i=1, self.wellenCount do
	         setRotation(self.Wellen[i], 0, 0, getRx);
	      end;
	    end;		
    end; 
end;

function PITAllradV2:draw()
   if self.showhudAllradon == true then
      	self.hudAllradonOverlay:render();
	end;
   if self.showhudAllradoff == true then
      	self.hudAllradoffOverlay:render();
	end;
end;

AllradStateEvent = {};
AllradStateEvent_mt = Class(AllradStateEvent, Event);

InitEventClass(AllradStateEvent, "AllradStateEvent");

function AllradStateEvent:emptyNew() 
    local self = Event:new(AllradStateEvent_mt );
    self.className="AllradStateEvent";
    return self;
end;

function AllradStateEvent:new(vehicle, state) 
    self.vehicle = vehicle;
    self.state = state;
    return self;
end;

function AllradStateEvent:readStream(streamId, connection)  
    local id = streamReadInt32(streamId); 
    self.state = streamReadBool(streamId); 
    self.vehicle = networkGetObject(id); 
    self:run(connection);  
end;

function AllradStateEvent:writeStream(streamId, connection)   
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
    streamWriteBool(streamId, self.state );   
end;

function AllradStateEvent:run(connection)  
    self.vehicle:allradState(self.state, true);
	if not connection:getIsServer() then  
		g_server:broadcastEvent(AllradStateEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;

function AllradStateEvent.sendEvent(vehicle, state, noEventSend)  
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then  
			g_server:broadcastEvent(AllradStateEvent:new(vehicle, state), nil, nil, vehicle);
		else 
			g_client:getServerConnection():sendEvent(AllradStateEvent:new(vehicle, state));
		end;
	end;
end;

