
-- by modelleicher
--

DeutzInfoHud = {};

function DeutzInfoHud.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function DeutzInfoHud:load(xmlFile)


	-- Deutz Info Hud --
	self.hudDeutzInfoPosX = 0.76;
    self.hudDeutzInfoWidth = 0.22;
    self.hudDeutzInfoPosY = 0.54;
    self.hudDeutzInfoHeight = 0.75;

	self.infoPanelDeutzInfoPath = Utils.getFilename("Hud.png", self.baseDirectory);
	self.hudDeutzInfoOverlay = Overlay:new("hudDeutzInfoOverlay", self.infoPanelDeutzInfoPath, self.hudDeutzInfoPosX, self.hudDeutzInfoPosY, self.hudDeutzInfoWidth, self.hudDeutzInfoHeight);

	self.showHudDeutzInfo = false;


end;

function DeutzInfoHud:onLeave()
	self.showHudDeutzInfo = false;
end;


function DeutzInfoHud:delete()

     	-- Deutz Info Hud --
    if self.hudDeutzInfoOverlay ~= nil then
		self.hudDeutzInfoOverlay:delete();
	end;

end;

function DeutzInfoHud:mouseEvent(posX, posY, isDown, isUp, button)
end;

function DeutzInfoHud:keyEvent(unicode, sym, modifier, isDown)
end;

function DeutzInfoHud:update(dt)

    if self:getIsActiveForInput() and self.isEntered then
    

		if InputBinding.hasEvent(InputBinding.HUDINFO) then
		    self.showHudDeutzInfo = not self.showHudDeutzInfo;
		end;
		


   		

	end;			 

end;

function DeutzInfoHud:draw()


  	if self.showHudDeutzInfo and self.isEntered then
		self.hudDeutzInfoOverlay:render();
	end;

end;

