--
-- OtterFarm
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

OtterFarm = {}

local OtterFarm_mt = Class(OtterFarm, Mission00);

function OtterFarm:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = OtterFarm_mt;
    end;
    local self = OtterFarm:superClass():new(baseDirectory, mt);
    return self;
end;

function OtterFarm:delete()
    OtterFarm:superClass().delete(self);
end;

function OtterFarm:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    
    -- load paths for AI traffic vehicles
    --self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
    
    -- load paths for AI pedestrians
   -- self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
    OtterFarm:superClass().load(self);
end
function OtterFarm:loadFinished()
    OtterFarm:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function OtterFarm:mouseEvent(posX, posY, isDown, isUp, button)
    OtterFarm:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function OtterFarm:keyEvent(unicode, sym, modifier, isDown)
    OtterFarm:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function OtterFarm:update(dt)
    OtterFarm:superClass().update(self, dt);
end;

function OtterFarm:draw()
    OtterFarm:superClass().draw(self);
end;
