--
-- DMap
-- Author: Daniel "Desperados93" W.
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

DMap = {}

local DMap_mt = Class(DMap, Mission00);

function DMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = DMap_mt;
    end;
    local self = DMap:superClass():new(baseDirectory, mt);
    return self;
end;

function DMap:delete()
    DMap:superClass().delete(self);
end;

function DMap:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- Map
    self:loadMap(Utils.getFilename("Osthessenmap.i3d", self.baseDirectory));
    BGA = Utils.getFilename("map01/pdapics/bga.png", self.baseDirectory);
    Hof = Utils.getFilename("map01/pdapics/Hof.png", self.baseDirectory);
	shoppic = Utils.getFilename("map01/pdapics/shop.png", self.baseDirectory);
	Getreidelager = Utils.getFilename("map01/pdapics/Getreidelager.png", self.baseDirectory);
	Getreideverkauf = Utils.getFilename("map01/pdapics/Getreideverkauf.png", self.baseDirectory);
	
    -- Verkehr
    self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
    
    -- Fugaenger
    self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- PDA
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
	-- PDA Hotspots

    self.missionPDA:createMapHotspot("Brewery", "dataS2/missions/hud_pda_spot_brewery.png", 1314, 1450, 0.045, 0.026, false, false, 0);
    self.missionPDA:createMapHotspot("Watermill", "dataS2/missions/hud_pda_spot_watermill.png", 1314, 1350, 0.025, 0.025, false, false, 0);
    self.missionPDA:createMapHotspot("Hof", Hof , 1170, 768 , 0.055, 0.036, false, false, 0);
    self.missionPDA:createMapHotspot("BGA", BGA , 1405, 476 , 0.036, 0.036, false, false, 0);
	self.missionPDA:createMapHotspot("Cow", "dataS2/missions/hud_pda_spot_cow.png", 1208, 236, 0.036, 0.036, false, false, 0);
	self.missionPDA:createMapHotspot("Farming Shop", shoppic , 1021, 724, 0.065, 0.046, false, false, 0);
	self.missionPDA:createMapHotspot("Getreidelager", Getreidelager , 1695, 750, 0.055, 0.036, false, false, 0);
	self.missionPDA:createMapHotspot("Getreideverkauf", Getreideverkauf , 1630, 1125, 0.055, 0.036, false, false, 0);
    
	--Mission Glass Containers
    self:loadGlassContainers(Utils.getFilename("missions/glassContainers.i3d", self.baseDirectory));
	
	--Mission Bottles
    self:loadCollectableBottles(Utils.getFilename("missions/collectableBottles.i3d", self.baseDirectory));
 

    
	DMap:superClass().load(self);
end
function DMap:loadFinished()
    DMap:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function DMap:mouseEvent(posX, posY, isDown, isUp, button)
    DMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function DMap:keyEvent(unicode, sym, modifier, isDown)
    DMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function DMap:update(dt)
    DMap:superClass().update(self, dt);
end;

function DMap:draw()
    DMap:superClass().draw(self);
end;
