--
-- BGASilo
--
-- M@D Author:  Heady
-- M@D date: 06.01.2011
--
-- > Copyright (C) Heady - www.planet-ls.de < --
--


print("  Map: BGASilo v1.3 loaded");


ModEvent = {};

ModEvent.silos = {};

function ModEvent:loadMap(name)
	
	local dir = getUserProfileAppPath() .. "savegame"..g_currentMission.missionInfo.savegameIndex;
	createFolder(dir);
	self.saveXMLFile = dir .. "/bgaSilo.xml";

	if g_currentMission.missionStats.fuelUsageTotal == 0 then
		os.remove(self.saveXMLFile);
		self.firstTimeRun = false;
	else
		--ModEvent:loadBGAFromFile();
		self.firstTimeRun = true;
	end;
	
end;

function ModEvent:deleteMap()
	
	ModEvent.silos = {};

end;

function ModEvent:delete()
end;

function ModEvent:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ModEvent:keyEvent(unicode, sym, modifier, isDown)
end;

function ModEvent:update(dt)

	if g_server ~= nil then

		if self.firstTimeRun then
			ModEvent:loadBGASiloFromFile();
			self.firstTimeRun = false;
		end;
		
	end;

	--[[for i=1, table.getn(ModEvent.silos) do
		ModEvent.silos[i]:update(dt);
	end;]]

end;

function ModEvent:draw()

	for i=1, table.getn(ModEvent.silos) do
		ModEvent.silos[i]:draw();
	end;
	
end;

local CareerScreenSaveSelectedGame = CareerScreen.saveSelectedGame;
CareerScreen.saveSelectedGame = function(self)
	CareerScreenSaveSelectedGame(self); 
	ModEvent:saveBGASiloToXML();
end;

function ModEvent:saveBGASiloToXML()	
	
	local existDir = io.open (self.saveXMLFile, "w");	
	if existDir == nil then
		createXMLFile("createsilo", self.saveXMLFile, "savesilo");
	end;

    -- save silo filllevel
    local xmlFile = io.open (self.saveXMLFile, "w");
    if xmlFile ~= nil then
        xmlFile:write('<?xml version="1.0" encoding="utf-8" standalone="no" ?>\n<bgaSilos>\n');

		for i=1, table.getn(ModEvent.silos) do
			local silo = ModEvent.silos[i];
			xmlFile:write('    <silo silageFillLevel="'..silo.silage.fillLevel..'" siloFillLevel="'..silo.silo.fillLevel..'" siloMaxFillLevel="'..silo.silo.maxFillLevel..'" state="'..silo.siloState..'" />\n');
		end;		
		
        xmlFile:write("</bgaSilos>");

        xmlFile:close();
    end;	
	
end;

function ModEvent:loadBGASiloFromFile()

	local existDir = io.open (self.saveXMLFile, "r");
	if existDir ~= nil then
		local xmlFile = loadXMLFile("TempConfig", self.saveXMLFile);
		
		local siloI = 0;
		while true do
			local key = string.format("bgaSilos.silo(%d)", siloI);
			local siloMaxFillLevel = getXMLFloat(xmlFile, key.."#siloMaxFillLevel");
			if siloMaxFillLevel ~= nil then			
				ModEvent.silos[siloI+1].silage.fillLevel = getXMLFloat(xmlFile, key.."#silageFillLevel");
				ModEvent.silos[siloI+1].silo.fillLevel = getXMLFloat(xmlFile, key.."#siloFillLevel");
				ModEvent.silos[siloI+1].silo.maxFillLevel = siloMaxFillLevel;
				ModEvent.silos[siloI+1].siloState = getXMLFloat(xmlFile, key.."#state");
				
				ModEvent.silos[siloI+1]:updateState();		
				ModEvent.silos[siloI+1]:moveSilagePlane(ModEvent.silos[siloI+1].silage.fillLevel);
				ModEvent.silos[siloI+1]:moveSiloPlane(ModEvent.silos[siloI+1].silo.fillLevel);
				
				ModEvent.silos[siloI+1].runSiloState2 = false;			

			else
				break;
			end;
			
			siloI = siloI +1;
		end;
		
		delete(xmlFile);
		print("BGASilo saves loaded");
	else
		print("Warning: ", self.saveXMLFile, " can not be found, BGASilo saves not loaded.")
	end;

end;

addModEventListener(ModEvent);



function onCreate(self, id)
	--print("created MapBGASilo, id: ", id);
	local instance = MapBGASilo:new(g_server ~= nil, g_client ~= nil);
	local index = g_currentMission:addOnCreateLoadedObject(instance);
	instance:load(id);
	instance:register(true); -- add update routine, 
	table.insert(ModEvent.silos, instance);
end;


MapBGASilo = {};

local MapBGASilo_mt = Class(MapBGASilo, Object);

function MapBGASilo:new(isServer, isClient)
	local self = Object:new(isServer, isClient, MapBGASilo_mt);
	self.className = "MapBGASilo";
	return self;
end;

function MapBGASilo:load(id)

	addTrigger(id, "SiloTipCallback", self);
	
	self.specialTriggerId = id;
	
	self.silage = {};
	self.silage.moveMaxY = getUserAttribute(id, "moveMaxY");
	self.silage.moveMinY = getUserAttribute(id, "moveMinY");
	self.silage.maxFillLevel = getUserAttribute(id, "maxFillLevel");
	self.silage.plane = Utils.indexToObject(getParent(id), getUserAttribute(id, "silageIndex"));
	self.silage.allowFillTypes = {};
	local types = Utils.splitString(" ", getUserAttribute(id, "fruitTypes"));
	for k,v in pairs(types) do
		if FruitUtil.fruitTypes[v] ~= nil then
			self.silage.allowFillTypes[FruitUtil.fruitTypeToFillType[FruitUtil.fruitTypes[v].index]] = true;
		end;
	end;
	
	
	self.silo = {};
	self.silo.plane = Utils.indexToObject(getParent(id), getUserAttribute(id, "siloIndex"));
	self.silo.trigger = Utils.indexToObject(getParent(id), getUserAttribute(id, "siloTriggerIndex"));
	self.silo.triggerNode = Utils.indexToObject(getParent(id), getUserAttribute(id, "siloTriggerNode"));
	self.silo.maxZScale = getUserAttribute(id, "siloMaxZScale");
	self.silo.minZScale = getUserAttribute(id, "siloMinZScale");
	
	self.silo.triggerTransBackup = {getTranslation(self.silo.trigger)};
	setTranslation(self.silo.trigger, 0,-10,0);
	setVisibility(self.silo.plane, false);
	
	addTrigger(self.silo.trigger, "SiloGetCallback", self);
	
	
	self.folie = {};
	self.folie.plane = Utils.indexToObject(getParent(id), getUserAttribute(id, "folieIndex"));
	
	setVisibility(self.folie.plane, false);
	
	self.movingIndex = Utils.indexToObject(getParent(id), getUserAttribute(id, "movingIndex"));
	
	self.priceMultipliers = {};
	for i=1, FruitUtil.NUM_FRUITTYPES do
		self.priceMultipliers[i] = 0;
	end;
	
	self.trailerInTrigger = {};			
		
	self.trailerID = nil;
	self.silage.fillLevel = 0;
	self.silo.fillLevel = 0;
	self.silo.maxFillLevel = self.silage.maxFillLevel;
	
	self.tipTrailerIndex = 0;
	self.attachableID = nil;
	
	self.playerInRange = false;
	self.siloState = 0;
	
	
	self:moveSilagePlane(self.silage.fillLevel);
	self:moveSiloPlane(self.silo.fillLevel);
	self:updateState();	
	
	self.serverNumPlayers = 0;
	self.runSiloState2 = false;
	
	self.siloState2 = false;
	
	self.doUpdateSendEvent = false;
	
end;

function MapBGASilo:delete()

	removeTrigger(self.specialTriggerId);

end;

function MapBGASilo:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MapBGASilo:keyEvent(unicode, sym, modifier, isDown)
end;

function MapBGASilo:update(dt)


	if table.getn(self.trailerInTrigger) > 0 then
		local Index = 0;
		local aVIndex = 0;
		local aVaVIndex = 0;
		for i=1, table.getn(self.trailerInTrigger) do	
			if self.siloState == 0 then
				if g_currentMission.controlledVehicle ~= nil then
					if self.trailerInTrigger[i] == g_currentMission.controlledVehicle then
						Index = i;
						g_currentMission.trailerInTipRange = i;
					end;
					if self.trailerInTrigger[i].attacherVehicle == g_currentMission.controlledVehicle then
						aVIndex = i;
						g_currentMission.trailerInTipRange = i;
					end;
					if Utils.getNoNil(Utils.getNoNil(self.trailerInTrigger[i].attacherVehicle, self).attacherVehicle, self) == g_currentMission.controlledVehicle then
						aVaVIndex = i;
						g_currentMission.trailerInTipRange = i;
					end;
					--g_currentMission.trailerInTipRange = self.trailerInTrigger[i];
				end;
			end;			
		end;
		
		if g_gui.currentGui == nil then
			if InputBinding.hasEvent(InputBinding.ATTACH) then
				if Index ~= 0 then -- truck ohne / mit trailer, ohne hakenlift
					self.tipTrailerIndex = Index;
				elseif Index == 0 and aVIndex ~= 0 then -- trailer ohne truck
					self.tipTrailerIndex = aVIndex;		
				elseif aVIndex == 0 and aVaVIndex ~= 0 then -- hakenlift ohne trailer
					self.tipTrailerIndex = aVaVIndex;
				end;
				--self:updateSendEvent();
				self.doUpdateSendEvent = true;	
			end;
		end;
	end;
	
	
	if self.playerInRange and self.silage.fillLevel > 0 then
		if g_gui.currentGui == nil then
			if InputBinding.hasEvent(InputBinding.BGASILOSTATE) then
			
				self.siloState = self.siloState +1;			
				if self.siloState == 3 then
					self.siloState = 0;
				end;
				
				self:updateState();	
				--self:updateSendEvent();	
				self.doUpdateSendEvent = true;	
			end;
		end;
	end;	
	
	if self.siloState == 2 and self.runSiloState2 then
		self.silo.maxFillLevel = self.silage.fillLevel;
		self.silo.fillLevel = self.silage.fillLevel;
		self:moveSiloPlane(self.silo.fillLevel);
		self.runSiloState2 = false;
	elseif self.siloState == 1 then
		self.runSiloState2 = true;
	end;
	
	if self.silo.fillLevel <= 0 and self.siloState == 2 then
		self.siloState = 0;
		self.silage.fillLevel = 0;
		self.silo.fillLevel = 0;
		self:moveSilagePlane(self.silage.fillLevel);
		self:updateState();			
	end;
	
	if self.siloState == 2 then
		self.siloState2 = true;
	end;	
	if self.siloState == 0 and self.siloState2 then
		self.silage.fillLevel = self.silo.fillLevel;
		self.siloState2 = false;
	end;	


	if g_server ~= nil then
	
	
		if self.tipTrailerIndex > 0 then
			if self.trailerInTrigger[self.tipTrailerIndex].tipState ~= nil then
				if self.trailerInTrigger[self.tipTrailerIndex].tipState ~= Trailer.TIPSTATE_CLOSING then
					self.trailerInTrigger[self.tipTrailerIndex]:toggleTipState(self);
				end;
			end;
			for i=1, table.getn(self.trailerInTrigger[self.tipTrailerIndex].attachedImplements) do
				local trailer = self.trailerInTrigger[self.tipTrailerIndex].attachedImplements[i].object;
				if trailer.tipState ~= nil and trailer.toggleTipState ~= nil then
					if trailer.tipState ~= Trailer.TIPSTATE_CLOSING then
						trailer:toggleTipState(self);
					end;
				end;
			end;
			self.tipTrailerIndex = 0;
		end;
		
		if table.getn(self.trailerInTrigger) > 0 then
			if self.silage.fillLevel >= self.silage.maxFillLevel then
				for i=1, table.getn(self.trailerInTrigger) do
					if (self.trailerInTrigger[i].tipState == Trailer.TIPSTATE_OPENING or self.trailerInTrigger[i].tipState == Trailer.TIPSTATE_OPEN) then
						self.trailerInTrigger[i]:toggleTipState(self);
					end;
				end;
			end;
		else
			if self.siloState == 0 and self.silage.fillLevel >= self.silage.maxFillLevel then
				self.siloState = 1;
				self:updateState();
				--self:updateSendEvent();
				self.doUpdateSendEvent = true;	
			end;
		end;		
		
		--if self.fillLevel > self.silage.maxFillLevel then
			--self.fillLevel = self.silage.maxFillLevel;
		--end;
		

		
		if self.attachableID ~= nil then			
			if self.attachableID.isShovel ~= nil or self.attachableID.getFromSilo ~= nil then
				if self.attachableID.fillLevel < self.attachableID.capacity then
					local deltaFillLevel = dt*2;
					self.attachableID:setFillLevel(self.attachableID.fillLevel+deltaFillLevel, FruitUtil.fruitTypeToFillType[FruitUtil.FRUITTYPE_SILO]);
					self.silo.fillLevel = self.silo.fillLevel - deltaFillLevel;
					self:moveSiloPlane(self.silo.fillLevel);
					g_server:broadcastEvent(MPEventMoveSiloPlane:new(self));
					--self:updateSendEvent();
					self.doUpdateSendEvent = true;	
				end;
			end;
		end;
		
		local players = {};
		for key, value in pairs(g_currentMission.players) do			
			table.insert(players, value);
		end;		
		if self.serverNumPlayers ~= table.getn(players) then
			self.serverNumPlayers = table.getn(players);
			self:updateSendEvent();
			--self.doUpdateSendEvent = true;	
			g_server:broadcastEvent(MPEventMoveSilagePlane:new(self));
			g_server:broadcastEvent(MPEventMoveSiloPlane:new(self));
		end;		
		
	
	end;
	
	if self.doUpdateSendEvent then
		self:updateSendEvent();
		self.doUpdateSendEvent = false;
	end;
	
end;

function MapBGASilo:updateMoving(fillDelta)
	
	self.silage.fillLevel = self.silage.fillLevel + fillDelta;
	self:moveSilagePlane(self.silage.fillLevel);
	g_server:broadcastEvent(MPEventMoveSilagePlane:new(self));
	--self:updateSendEvent();
	self.doUpdateSendEvent = true;	

end;

function MapBGASilo:moveSilagePlane(fillLevel)

	local m = (self.silage.moveMaxY - self.silage.moveMinY) / self.silage.maxFillLevel;
	local xPos, yPos, zPos = getTranslation(self.movingIndex);
	setTranslation(self.movingIndex, xPos, m*fillLevel + self.silage.moveMinY, zPos);

end;

function MapBGASilo:moveSiloPlane(fillLevel)

	local m = (self.silo.maxZScale - self.silo.minZScale) / self.silo.maxFillLevel;
	local xScale, yScale, zScale = getScale(self.silo.plane);
	setScale(self.silo.plane, xScale, yScale, (m*fillLevel + self.silo.minZScale));	

	local xw,yw,zw = getWorldTranslation(self.silo.triggerNode);	
	local xl,yl,zl = worldToLocal(getParent(getParent(self.silo.trigger)), xw, yw, zw);
	setTranslation(getParent(self.silo.trigger), xl, yl, zl);
	
end;

function MapBGASilo:updateState()

	if self.siloState == 1 then -- folieplane
		setVisibility(self.silage.plane, false);
		setVisibility(self.folie.plane, true);
		setVisibility(self.silo.plane, false);
	elseif self.siloState == 2 then -- siloplane		
		setVisibility(self.silage.plane, false);
		setVisibility(self.folie.plane, false);
		setVisibility(self.silo.plane, true);
		setTranslation(self.silo.trigger, unpack(self.silo.triggerTransBackup));		
		setRigidBodyType(getParent(self.silage.plane), "NoRigidBody");
		--self.silo.maxFillLevel = self.fillLevel;
		--self:moveSiloPlane(self.fillLevel)
	else	-- silageplane
		setVisibility(self.silage.plane, true);
		setVisibility(self.silo.plane, false);
		setTranslation(self.silo.trigger, 0,-10,0);
		setVisibility(self.folie.plane, false);
		setRigidBodyType(getParent(self.silage.plane), "Kinematic");		
	end;	

end;

function MapBGASilo:draw()

	if table.getn(self.trailerInTrigger) > 0 then
		local printTipOverlay = false;
		for i=1, table.getn(self.trailerInTrigger) do	
			if self.siloState == 0 then
				if g_currentMission.controlledVehicle ~= nil then
					if self.trailerInTrigger[i] == g_currentMission.controlledVehicle or self.trailerInTrigger[i].attacherVehicle == g_currentMission.controlledVehicle or Utils.getNoNil(Utils.getNoNil(self.trailerInTrigger[i].attacherVehicle, self).attacherVehicle, self) == g_currentMission.controlledVehicle then
						printTipOverlay = true;
					end;
				end;
			end;			
		end;
		if printTipOverlay then
			g_currentMission.hudTipperOverlay:render();
			g_currentMission:addExtraPrintText("Silo FillLevel: "..math.floor(self.silage.fillLevel));
		end;
	end;
	
	if self.playerInRange then
		if self.siloState == 0 and self.silage.fillLevel > 0 then
			g_currentMission:addExtraPrintText("Silo zudecken: "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.BGASILOSTATE));
		elseif self.siloState == 1 then
			g_currentMission:addExtraPrintText("Silo aufdecken: "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.BGASILOSTATE));
		elseif self.siloState == 2 then
			g_currentMission:addExtraPrintText("Silage einfahren: "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.BGASILOSTATE));
		end;
	end;
	
end;

function MapBGASilo:SiloTipCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
    
	if onEnter then
		local trailer = g_currentMission.nodeToVehicle[otherId];
		local enterTable = false;
		if trailer ~= nil then
			--if trailer.setFillLevel ~= nil and self.silage.allowFillTypes[trailer.currentFillType] and trailer.tipAnimCharSet ~= 0 then			
			if trailer.allowTipDischarge and self.silage.allowFillTypes[trailer.currentFillType] then			
				for i=0, table.getn(self.trailerInTrigger) do
					if self.trailerInTrigger[i] ~= trailer then					
						enterTable = true;
					else
						enterTable = false;
					end;
				end;
			end;
		end;		
		if enterTable then
			table.insert(self.trailerInTrigger, trailer)
		end;	
		if g_currentMission.player ~= nil then
			if otherId == g_currentMission.player.rootNode then
				self.playerInRange = true;
			end;
		end;
	elseif onLeave then
		local trailer = g_currentMission.nodeToVehicle[otherId];
		if trailer ~= nil then
			for i=0, table.getn(self.trailerInTrigger) do
				if self.trailerInTrigger[i] == trailer then
					if self.trailerInTrigger[i].tipState == Trailer.TIPSTATE_OPENING or self.trailerInTrigger[i].tipState == Trailer.TIPSTATE_OPEN then
						self.trailerInTrigger[i]:toggleTipState(self);
					end;
					table.remove(self.trailerInTrigger, i)
					g_currentMission.trailerInTipRange = nil;
				end;
			end;
		end;	
		if g_currentMission.player ~= nil then
			if otherId == g_currentMission.player.rootNode then
				self.playerInRange = false;
			end;
		end;
	end;
	
end;

function MapBGASilo:SiloGetCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)

    if onEnter then
		if otherId ~= nil then	
			local attachable = g_currentMission.nodeToVehicle[otherId];
			if attachable ~= nil then
				if attachable.fillTypes ~= nil and attachable.setFillLevel ~= nil and attachable.fillLevel ~= nil then
					if attachable.fillLevel < attachable.capacity and attachable:allowFillType(FruitUtil.fruitTypeToFillType[FruitUtil.FRUITTYPE_SILO], true) then
						self.attachableID = attachable;	
					end;
				end;
			end;
		end;		
	elseif onLeave then
		if otherId ~= nil then	
			local attachable = g_currentMission.nodeToVehicle[otherId];
			if attachable ~= nil then
				if attachable == self.attachableID then
					self.attachableID = nil;
				end;
			end;
		end;					
	end;	
	
end;

function MapBGASilo:updateSendEvent()	

	if g_server ~= nil then
		g_server:broadcastEvent(MPEvent:new(self));
	else
		g_client:getServerConnection():sendEvent(MPEvent:new(self));
	end

end;


local BaseMissionGetIsTrailerInTipRange = BaseMission.getIsTrailerInTipRange;
BaseMission.getIsTrailerInTipRange = function(self, trailer, tipTrigger)
	if tipTrigger.triggerId == nil then
		return true;
	else
		return BaseMissionGetIsTrailerInTipRange(self, trailer, tipTrigger);
	end;
end;

