--
-- HeapTipTrigger
--
-- M@D Author:  Heady
-- M@D date: 13.06.2011
--
-- > Copyright (C) Heady - www.planet-ls.de < --
--

HeapTipTrigger = {};

function HeapTipTrigger.prerequisitesPresent(specializations)
    return true;
end;

function HeapTipTrigger:load(xmlFile)

	self.setFillLevel = Utils.overwrittenFunction(self.setFillLevel, HeapTipTrigger.setFillLevel);
	self.tipTriggerCallback = HeapTipTrigger.tipTriggerCallback;
	self.updateMoving = HeapTipTrigger.updateMoving;
	self.shovelGetCallback = HeapTipTrigger.shovelGetCallback;

	g_currentMission:addTipTrigger(self);

	self.triggerId = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tipTrigger#index"));
	addTrigger(self.triggerId, "tipTriggerCallback", self);


	
	
	self.acceptedFruitTypes = {}; -- was fillTypes
    self.priceMultipliers = {};
    local fruitTypes = getXMLString(xmlFile, "vehicle.fillTypes#fruitTypes");
    if fruitTypes ~= nil then
        local types = Utils.splitString(" ", fruitTypes);     
        for k,v in pairs(types) do
            local desc = FruitUtil.fruitTypes[v];
            if desc ~= nil then
                self.acceptedFruitTypes[desc.index] = true;
                self.priceMultipliers[desc.index] = 0;                
            end;
        end;
    end;
	
	self.moveNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fillPlanes#moveNode"));
	addTrigger(self.moveNode, "shovelGetCallback", self);
	
	self.attachableID = nil;
	self.trailersInTrigger = {};
	

	self.allowToRemove = false;
	self.removeTime = 2000;
	
	self.setStatic = true;

end;

function HeapTipTrigger:delete()

	g_currentMission:removeTipTrigger(self);
    removeTrigger(self.triggerId);
	
	removeTrigger(self.moveNode);
	
	if g_currentMission ~= nil then	
		for k,v in pairs(g_currentMission.trailerTipTriggers) do
			for key, tipTrigger in pairs(v) do
				if tipTrigger == self then
					v[key] = nil;
				end;
			end;
		end;
	end;
	
end;

function HeapTipTrigger:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)

	if self.fillLevel <= 0 then
		self.allowToRemove = true;
	else
		setRigidBodyType(self.rootNode, "Static"); 
	end;
	
	return BaseMission.VEHICLE_LOAD_OK;
end;

function HeapTipTrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HeapTipTrigger:keyEvent(unicode, sym, modifier, isDown)
end;

function HeapTipTrigger:update(dt)
end;

function HeapTipTrigger:updateTick(dt)

	if self.isServer then
	
		if self.attachableID ~= nil and self.fillLevel > 0 then			
			if self.attachableID.isShovel ~= nil or self.attachableID.getFromSilo ~= nil then
				if self.attachableID.fillLevel < self.attachableID.capacity then
					local m = self.attachableID.capacity * (dt/1000);
					local deltaFillLevel = math.min(m, self.fillLevel);
					self.attachableID:setFillLevel(self.attachableID.fillLevel+deltaFillLevel, self.currentFillType);
					self:setFillLevel(self.fillLevel-deltaFillLevel, self.currentFillType);
					self.allowToRemove = true;	
				end;
			end;
		end;
		
		if self.allowToRemove then			
			if self.fillLevel <= 0 then
				self.removeTime = self.removeTime - dt;
				if self.removeTime <= 0 then
					g_currentMission.vehiclesToDelete[self] = self;
				end;
			end;
		end;
		

		
	end;

end;

function HeapTipTrigger:draw()
end;

function HeapTipTrigger:updateMoving(delta)		


	local fillType = self.currentFillType;
	if self.fillLevel <= 0 then
		fillType = self.trailersInTrigger[1].currentFillType;
	end;
	
	local oldFillLevel = self.fillLevel + delta;
	self.fillLevel = math.min(oldFillLevel, self.capacity);	
	
	self:setFillLevel(self.fillLevel, fillType);
	
	local refill = oldFillLevel - self.fillLevel;
	if refill > 0 then
		for i=1, table.getn(self.trailersInTrigger) do
			local trailer = self.trailersInTrigger[i];
			--trailer:setFillLevel(trailer.fillLevel + refill, trailer.currentFillType);
			trailer:onEndTip();
		end;
	end;

	--self.allowToRemove = false;	
	
	if self.setStatic then
		setRigidBodyType(self.rootNode, "Static"); 
		self.setStatic = false;
	end;

end;


function HeapTipTrigger:tipTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)

	if onEnter then
		local trailer = g_currentMission.objectToTrailer[otherShapeId];
		if trailer ~= nil and trailer.allowTipDischarge then
			if g_currentMission.trailerTipTriggers[trailer] == nil then
				g_currentMission.trailerTipTriggers[trailer] = {};
			end;
			table.insert(g_currentMission.trailerTipTriggers[trailer], self);
			table.insert(self.trailersInTrigger, trailer);
		end;
	elseif onLeave then
		local trailer = g_currentMission.objectToTrailer[otherShapeId];
		if trailer ~= nil and trailer.allowTipDischarge then
			local triggers = g_currentMission.trailerTipTriggers[trailer];
			if triggers ~= nil then
				for i=1, table.getn(triggers) do
					if triggers[i] == self then
						table.remove(triggers, i);
						if table.getn(triggers) == 0 then
							g_currentMission.trailerTipTriggers[trailer] = nil;
						end;
						break;
					end;
				end;
			end;
			for i=1, table.getn(self.trailersInTrigger) do
				if self.trailersInTrigger[i] == trailer then
					table.remove(self.trailersInTrigger, i);
				end;
			end;
		end;
	end;

end;

function HeapTipTrigger:shovelGetCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)

    if onEnter then
		if otherId ~= nil then	
			local attachable = g_currentMission.nodeToVehicle[otherId];
			if attachable ~= nil then
				if attachable.fillTypes ~= nil and attachable.setFillLevel ~= nil and attachable.fillLevel ~= nil then
					if attachable.fillLevel < attachable.capacity and attachable:allowFillType(self.currentFillType, true) then
						self.attachableID = attachable;	
					end;
				end;
			end;
		end;		
	elseif onLeave then
		if otherId ~= nil then	
			local attachable = g_currentMission.nodeToVehicle[otherId];
			if attachable ~= nil then
				if attachable == self.attachableID then
					self.attachableID = nil;
				end;
			end;
		end;					
	end;	
	
end;

function HeapTipTrigger:setFillLevel(superFunc, fillLevel, fillType, force)
    if (force == nil or force == false) and not self:allowFillType(fillType, false) then
        return
    end;

    self.currentFillType = fillType;
    self.fillLevel = fillLevel;
    if self.fillLevel > self.capacity then
        self.fillLevel = self.capacity;
    end;
    if self.fillLevel < 0 then
        self.fillLevel = 0;
        self.currentFillType = Fillable.FILLTYPE_UNKNOWN;
    end;


    if self.isClient then
        if self.currentFillPlane ~= nil then
            for _, node in ipairs(self.currentFillPlane.nodes) do
                setVisibility(node.node, false);
            end;
            self.currentFillPlane = nil;
        end;
        if self.fillPlanes ~= nil and self.defaultFillPlane ~= nil and fillType ~= Fillable.FILLTYPE_UNKNOWN then
            local fillTypeName = Fillable.fillTypeIntToName[fillType];
            local fillPlane = self.fillPlanes[fillTypeName];
            if fillPlane == nil then
                fillPlane = self.defaultFillPlane;
            end;
            local t = self.fillLevel/self.capacity;
            for _, node in ipairs(fillPlane.nodes) do
                local x,y,z, rx,ry,rz, sx,sy,sz = node.animCurve:get(t);

                setTranslation(self.moveNode, x, y, z);
                setRotation(self.moveNode, rx, ry, rz);
                setScale(self.moveNode, sx, sy, sz);
                setVisibility(node.node, self.fillLevel > 0);
            end;
            self.currentFillPlane = fillPlane;
        end;
    end;
end;


if BaseMission.modHeapTipTrigger == nil then
	BaseMission.modHeapTipTrigger = true;
	print("  Register Variable: BaseMission.modHeapTipTrigger");
	
	local TrailerUpdate = Trailer.update;
	Trailer.update = function(self, dt)

		if self.create_HeapTipTrigger == nil then
			self.create_HeapTipTrigger = false;
		end;
		if self.printStrg == nil then
			self.printStrg = false;
		end;

		if self:getIsActive() then
		
			self.printStrg = false;
		
			if g_currentMission.trailerInTipRange == nil and ( self.tipState == Trailer.TIPSTATE_CLOSED or self.tipState == Trailer.TIPSTATE_CLOSING ) and not self.create_HeapTipTrigger then
				if Input.isKeyPressed(Input.KEY_lctrl) and InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT) then
					self.create_HeapTipTrigger = true;
					if g_server == nil then
						g_client:getServerConnection():sendEvent(HeapTipTriggerMPEvent:new(self));
					end;
				end;
				if Input.isKeyPressed(Input.KEY_lctrl) then
					self.printStrg = true;
				else
					self.printStrg = false;
				end;
			end;
			
		end;
		
		if self.create_HeapTipTrigger then
			if self.isServer then
				local x,y,z = getWorldTranslation(self.tipReferencePoint);
				local xr,yr,zr = getWorldRotation(self.tipReferencePoint);
				g_currentMission:loadVehicle(getUserProfileAppPath().."mods/HeapTipTrigger/heapTipTrigger.xml", x, 0.5, z, yr);
			end;
			self.create_HeapTipTrigger = false;
		end;

		TrailerUpdate(self, dt);
	end;

	local TrailerDraw = Trailer.draw;
	Trailer.draw = function(self)

		if self.printStrg then
			g_currentMission:addExtraPrintText("HeapTipTrigger erstellen: STRG+"..InputBinding.getKeyNamesOfDigitalAction(InputBinding.ACTIVATE_OBJECT));
		end;	

		TrailerDraw(self);
	end;
	
end;


HeapTipTriggerMPEvent = {};
HeapTipTriggerMPEvent_mt = Class(HeapTipTriggerMPEvent, Event);

InitEventClass(HeapTipTriggerMPEvent, "HeapTipTriggerMPEvent");

function HeapTipTriggerMPEvent:emptyNew()
    local self = Event:new(HeapTipTriggerMPEvent_mt);
    self.className="HeapTipTriggerMPEvent";
    return self;
end;

function HeapTipTriggerMPEvent:new(object)
    local self = HeapTipTriggerMPEvent:emptyNew()
    self.object = object;
    return self;
end;

function HeapTipTriggerMPEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId)
    self.object = networkGetObject(id);

	self.object.create_HeapTipTrigger = streamReadBool(streamId);
end;

function HeapTipTriggerMPEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	
	streamWriteBool(streamId, self.object.create_HeapTipTrigger);
end;



