KroneZXAreaEvent = {};
KroneZXAreaEvent_mt = Class(KroneZXAreaEvent, Event);

InitEventClass(KroneZXAreaEvent, "KroneZXAreaEvent");

function KroneZXAreaEvent:emptyNew()
    local self = Event:new(KroneZXAreaEvent_mt);
    self.className="KroneZXAreaEvent";
    return self;
end;

function KroneZXAreaEvent:new(cuttingAreas, fruitType)
    local self = KroneZXAreaEvent:emptyNew()
    self.cuttingAreas = cuttingAreas;
	self.fruitType = fruitType;
    return self;
end;

function KroneZXAreaEvent:readStream(streamId, connection)
    local numAreas = streamReadUIntN(streamId, 4);
    
    local refX = streamReadFloat32(streamId);
    local refY = streamReadFloat32(streamId);
    local values = Utils.readCompressed2DVectors(streamId, refX, refY, numAreas*3-1, 0.01, true);
	local fruitType = streamReadFloat32(streamId);
    for i=1,numAreas do
        local vi = i-1;
        local x = values[vi*3+1].x;
        local z = values[vi*3+1].y;
        local x1 = values[vi*3+2].x;
        local z1 = values[vi*3+2].y;
        local x2 = values[vi*3+3].x;
        local z2 = values[vi*3+3].y;
        --Utils.updateCuttedMeadowArea(x, z, x1, z1, x2, z2);
		Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
		Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0);
		
		if fruitType == FruitUtil.FRUITTYPE_DRYGRASS then
			Utils.switchFruitTypeArea(FruitUtil.FRUITTYPE_GRASS, FruitUtil.FRUITTYPE_DRYGRASS, x, z, x1, z1, x2, z2, 1);
		end;

    end;
end;

function KroneZXAreaEvent:writeStream(streamId, connection)
    local numAreas = table.getn(self.cuttingAreas);
    streamWriteUIntN(streamId, numAreas, 4);
    local refX, refY;
    local values = {};
    for i=1, numAreas do
        local d = self.cuttingAreas[i];
        if i==1 then
            refX = d[1];
            refY = d[2];
            streamWriteFloat32(streamId, d[1]);
            streamWriteFloat32(streamId, d[2]);
        else
            table.insert(values, {x=d[1], y=d[2]});
        end;
        table.insert(values, {x=d[3], y=d[4]});
        table.insert(values, {x=d[5], y=d[6]});
    end;
    assert(table.getn(values) == numAreas*3 - 1);
    Utils.writeCompressed2DVectors(streamId, refX, refY, values, 0.01);
	streamWriteFloat32(streamId, self.fruitType);

end;

function KroneZXAreaEvent:run(connection)
    print("Error: Do not run KroneZXAreaEvent locally");
end;

function KroneZXAreaEvent.runLocally(cuttingAreas, fruitType)
    
    local numAreas = table.getn(cuttingAreas);

    local refX, refY;
    local values = {};
    for i=1, numAreas do
        local d = cuttingAreas[i];
        if i==1 then
            refX = d[1];
            refY = d[2];
        else
            table.insert(values, {x=d[1], y=d[2]});
        end;
        table.insert(values, {x=d[3], y=d[4]});
        table.insert(values, {x=d[5], y=d[6]});
    end;
    assert(table.getn(values) == numAreas*3 - 1);

    local values = Utils.simWriteCompressed2DVectors(refX, refY, values, 0.01, true);

    local area = 0;
    for i=1, numAreas do
        local vi = i-1;
        local x = values[vi*3+1].x;
        local z = values[vi*3+1].y;
        local x1 = values[vi*3+2].x;
        local z1 = values[vi*3+2].y;
        local x2 = values[vi*3+3].x;
        local z2 = values[vi*3+3].y;
        --area = area + Utils.updateCuttedMeadowArea(x, z, x1, z1, x2, z2);
		area = Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0)*g_currentMission.windrowCutLongRatio;
		area = area + Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0);
		
		if fruitType == FruitUtil.FRUITTYPE_DRYGRASS then
			Utils.switchFruitTypeArea(FruitUtil.FRUITTYPE_GRASS, FruitUtil.FRUITTYPE_DRYGRASS, x, z, x1, z1, x2, z2, 1);
		end;

    end;
    return area;
end;