--
-- FendtGTA380
-- Specialization for FendtGTA380
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		11/11/10
-- @history:	v1.0 - Initial version
--				v2.0 - converted to 2011 and some bugfixes
--

Vehicle.registerJointType("attachableFrontloader");

Fendt380GTATurbo = {};

function Fendt380GTATurbo.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Fendt380GTATurbo:load(xmlFile)

	self.setFenderVisibility = SpecializationUtil.callSpecializationsFunction("setFenderVisibility");
	
	self.backAttacherJoint = {};
	self.backAttacherJoint.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trailerAttacherJoints#back"));
	self.backAttacherJoint.upYPos = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.trailerAttacherJoints#upY"), 0);
	self.backAttacherJoint.downYPos = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.trailerAttacherJoints#downY"), 0);	
	local x,y,z = getTranslation(self.backAttacherJoint.node);
	self.backAttacherJoint.xPos = x;
	self.backAttacherJoint.zPos = z;	
	self.frontAttacherJoint = {};
	self.frontAttacherJoint.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trailerAttacherJoints#front"));
	setTranslation(self.backAttacherJoint.node, self.backAttacherJoint.xPos, self.backAttacherJoint.upYPos, self.backAttacherJoint.zPos);
	
	-- Defines attributes of backHydraulic
	self.backHydraulic = {};
	self.backHydraulic.rootArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#rootArm"));
	self.backHydraulic.bottomArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#bottomArm"));

	self.fenders = {};
	self.fenders.left = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fenders#index"));
	self.fenders.right = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fenders#index2"));
	
    local wiperAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiper#rootNode"));
    self.wiperAnimCharSet = 0;
    if wiperAnimRootNode ~= nil and wiperAnimRootNode ~= 0 then
        self.wiperAnimCharSet = getAnimCharacterSet(wiperAnimRootNode);
        if self.wiperAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperAnimCharSet, getXMLString(xmlFile, "vehicle.wiper#clip"));
            assignAnimTrackClip(self.wiperAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperAnimCharSet, 0, true);
            local wiperAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wiper#speedScale"), 1);
			setAnimTrackSpeedScale(self.wiperAnimCharSet, 0, wiperAnimSpeedScale);
            self.wiperAnimDuration = getAnimClipDuration(self.wiperAnimCharSet, clip);
        end;
    end;
	self.isWiperActive = false;
	self.finishWiper = true;
	
	self.moveDownIntervall = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.moveDownIntervall#ms"), 1000);
	self.updateJoint = false;
	self.doLowering = false;
	self.loweringDone = false;
	self.nextAction = false;
	self.delay = 0;
	self.implementCount = 0;
end;

function Fendt380GTATurbo:delete()
end;

function Fendt380GTATurbo:readStream(streamId, connection)
end;

function Fendt380GTATurbo:writeStream(streamId, connection)
end;

function Fendt380GTATurbo:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Fendt380GTATurbo:keyEvent(unicode, sym, modifier, isDown)
end;

function Fendt380GTATurbo:update(dt)
	if self:getIsActive() then
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.LOWER_ALL_IMPLEMENTS) then
				if self.implementCount == 2 then			
					self.loweringDone = false;
					self.delay = self.moveDownIntervall;
					self.doLowering = true;
					self.nextAction = not self.attacherJoints[1].moveDown;
					if self.attacherJoints[2].moveDown ~= not self.nextAction then 
						self.nextAction = false;
					end;
				end;
			end;		
		end;
		-- update steeringbar
		Cylindered.updateMovingPart(self, self.movingParts[1]);		
	end;
end;

function Fendt380GTATurbo:updateTick(dt)

	if self:getIsActive() then	
		if self.doLowering then	
			local back = self.attacherJoints[1];
			local front = self.attacherJoints[2];	
			if not self.loweringDone then
				self:setJointMoveDown(2, self.nextAction);
				self.loweringDone = true;
			end;			
			if self.loweringDone then
				self.delay = self.delay - dt;				
				if self.delay <= 0 then
					self:setJointMoveDown(1, self.nextAction);
					self.doLowering = false;
				end;
			end;
		end;

		if not self.finishWiper then
			if getAnimTrackTime(self.wiperAnimCharSet, 0) % self.wiperAnimDuration <= 100 then
				setAnimTrackTime(self.wiperAnimCharSet, 0, 0.0);
				disableAnimTrack(self.wiperAnimCharSet, 0);			
				self.finishWiper = true;
			end;			
		end;
		
		if self.backHydraulic ~= nil then
			-- set correct rotation on rootArm
			local x, y, z = getRotation(self.backHydraulic.bottomArm);
			setRotation(self.backHydraulic.rootArm, x, y, z);			
		end;
		
		if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
			if not self.isWiperActive then
				enableAnimTrack(self.wiperAnimCharSet, 0);
				self.isWiperActive = true;
			end;
		else
			if self.isWiperActive then
				self.isWiperActive = false;
				self.finishWiper = false;
			end;
		end;
		
		for _, part in pairs(self.movingParts) do
			part.isDirty = true;
		end;
	end;
end;

function Fendt380GTATurbo:draw()	
	if self.implementCount == 2 then
		g_currentMission:addHelpButtonText(g_i18n:getText("LOWER_ALL_IMPLEMENTS"), InputBinding.LOWER_ALL_IMPLEMENTS);
	end;
end;

function Fendt380GTATurbo:attachImplement(implement)
	
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;

	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = self.implementCount + 1;
		end;		
		-- index 1 defines back hydraulic
		if jointIndex == 1 then
			setVisibility(self.backAttacherJoint.node, false);
		elseif jointIndex == 2 then
			setVisibility(self.frontAttacherJoint.node, false);
			setVisibility(self.attacherJoints[jointIndex].topArm.rotationNode, true);
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILER then
		if jointIndex == 4 then
			setVisibility(self.backAttacherJoint.node, true);	
			setTranslation(self.backAttacherJoint.node, self.backAttacherJoint.xPos, self.backAttacherJoint.upYPos, self.backAttacherJoint.zPos);	
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		if jointIndex == 6 then
			setVisibility(self.backAttacherJoint.node, true);	
			setTranslation(self.backAttacherJoint.node, self.backAttacherJoint.xPos, self.backAttacherJoint.downYPos, self.backAttacherJoint.zPos);
		end;
	end;
	self.updateJoint = true;
	
end;

function Fendt380GTATurbo:detachImplement(implementIndex)

	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;
	if implement.object.attacherJoint.jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = math.max(self.implementCount - 1, 0);
		end;	
	end;
	if jointIndex == 1 then
		setVisibility(self.backAttacherJoint.node, true);
	elseif jointIndex == 2 then
		setVisibility(self.frontAttacherJoint.node, true);
		setVisibility(self.attacherJoints[jointIndex].topArm.rotationNode, false);
	elseif jointIndex == 6 then
		setTranslation(self.backAttacherJoint.node, self.backAttacherJoint.xPos, self.backAttacherJoint.upYPos, self.backAttacherJoint.zPos);
	end;
end;

function Fendt380GTATurbo:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return false;
end;

function Fendt380GTATurbo:setFenderVisibility(isVisible)
	setVisibility(self.fenders.left, isVisible);
	setVisibility(self.fenders.right, isVisible);
end;

function Fendt380GTATurbo:onLeave()
	if self.isWiperActive then
		disableAnimTrack(self.wiperAnimCharSet, 0);	
	end;
end;

function Fendt380GTATurbo:onEnter()
	if self.isWiperActive then
		enableAnimTrack(self.wiperAnimCharSet, 0);	
	end;
end;