--
-- engineManagement
-- Engine management specialization for IVT transmissions
--
-- @author  Templaer
-- @date  12/06/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--

engineManagement = {};

function engineManagement.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function engineManagement:load(xmlFile)
	self.raiseRPM = SpecializationUtil.callSpecializationsFunction("raiseRPM");
	self.lowerRPM = SpecializationUtil.callSpecializationsFunction("lowerRPM");

	self.backupMinRpm = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motor#minRpm"), 1000);	
    self.origMaxRpm = self.motor.maxRpm[3];
	self.input = 0;
end;

function engineManagement:delete()
end;

function engineManagement:mouseEvent(posX, posY, isDown, isUp, button)
end;

function engineManagement:keyEvent(unicode, sym, modifier, isDown)
end;

function engineManagement:update(dt)
    if self.isEntered then
	
		local maxRpm = self.motor:getMaxRpm();
		local rpmSpeedDiff = math.abs(maxRpm - self.motor.lastMotorRpm);
		
    	self.input = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);
	    if InputBinding.isAxisZero(self.input) then
	    	self.input = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
	    end;
        
		if self.cruiseControl then
		    self.input = 1;
		end;
		
		if not self.handThrottleEnabled or self.handThrottleEnabled == nil then
		

		
			if math.abs(self.input) > 0.9 then
				if self.currentMode == 2 and self.powershiftLevel < self.numLevels then
				    self:raiseRPM();
				elseif self.currentMode == 3 then
				    if self.powershiftLevel < self.numLevels  or self.currentRange < self.numRanges - 1 then
						self:raiseRPM();
					end;
				end;		
			end;
			
			if math.abs(self.input) > 0 then
				if self.currentMode == 1 then
					if self.lastRoundPerMinute < (math.abs(self.input) * self.motor.maxRpm[3]) then
						self:raiseRPM();
					else
						self:lowerRPM();
					end;
				end;
			
				if self.currentMode == 2 and self.powershiftLevel == self.numLevels then
					self:lowerRPM();
				elseif self.currentMode == 3 and self.powershiftLevel == self.numLevels and self.currentRange == self.numRanges - 1 then
					self:lowerRPM();
				end;	
			end;
				
			if self.input == 0 then
			    self.motor.minRpm = self.backupMinRpm;
		    end;
			
		end;
		
	end;
end;

function engineManagement:stopMotor()
    self.motor.minRpm = self.backupMinRpm;    
end;
	
function engineManagement:raiseRPM()
	local roundPerMinute = self.lastRoundPerMinute + (1-1)*(self.motor.lastMotorRpm-self.motor.minRpm);
	local rpmDiff = math.abs(roundPerMinute - ((self.origMaxRpm * 0.9) * 100));
	
	if roundPerMinute < ((self.origMaxRpm * 100) - 50) then
		self.motor.minRpm = self.motor.minRpm - (rpmDiff / 7500);
	end;
end;

function engineManagement:lowerRPM()
	local roundPerMinute = self.lastRoundPerMinute + (1-1)*(self.motor.lastMotorRpm-self.motor.minRpm);
	local rpmDiff = math.abs(roundPerMinute - ((self.origMaxRpm * 0.9) * 100));
	local maxRpm = self.motor:getMaxRpm();
	
	if self.motor.minRpm < (maxRpm / 3.5) then
		self.motor.minRpm = self.motor.minRpm + (rpmDiff / 7500);
	end;
end;
	
function engineManagement:onLeave()
    self.motor.mionRpm = self.backupMinRpm;
end;

function engineManagement:draw()
end;
