RotationEvent3 = {};

RotationEvent3_mt = Class(RotationEvent3, Event);

InitEventClass(RotationEvent3, "RotationEvent3");

function RotationEvent3:emptyNew()
	local self = Event:new(RotationEvent3_mt );
	self.className="RotationEvent3";
	return self;
end;

function RotationEvent3:new(vehicle, direction)
	self.vehicle = vehicle;
	self.direction = direction;
	return self;
end;

function RotationEvent3:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.direction = streamReadBool(streamId);
	self.vehicle = networkGetObject(id);
	self:run(connection);
end;

function RotationEvent3:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.direction );
end;

function RotationEvent3:run(connection)
	self.vehicle:setRotateDirection4(self.direction, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(RotationEvent3:new(self.vehicle, self.direction), nil, connection, self.object);
	end;
end;

function RotationEvent3.sendEvent(vehicle, direction, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(RotationEvent3:new(vehicle, direction), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(RotationEvent3:new(vehicle, direction));
		end;
	end;
end;