RotationEvent = {};
RotationEvent_mt = Class(RotationEvent, Event);

InitEventClass(RotationEvent, "RotationEvent");

function RotationEvent:emptyNew()  -- hoier wir ein leeres Event objekt erzeugt
	local self = Event:new(RotationEvent_mt );
	self.className="RotationEvent";
	return self;
end;

function RotationEvent:new(vehicle, direction) -- Der konsturktor des Events (erzeugt eben ein neues Event). Wir wollen das vehicle (aufrufer) und die neue richtung speichern bzw. übertragen
	self.vehicle = vehicle;
	self.direction = direction;
	return self;
end;

function RotationEvent:readStream(streamId, connection)	 -- wird aufgerufen wenn mich ein Event erreicht
	local id = streamReadInt32(streamId); -- hier lesen wir die übertragene ID des vehicles aus
	self.direction = streamReadBool(streamId); -- hier lesen wir die neue direction aus (es handelt sich hierbei um einen Bool (true/false)
	self.vehicle = networkGetObject(id); -- wir wandeln nunn die ID des vehicles in das passende Objekt um
	self:run(connection);  -- das event wurde komplett empfangen und kann nun "ausgeführt" werden
end;

function RotationEvent:writeStream(streamId, connection)   -- Wird aufgrufen wenn ich ein event verschicke (merke: reihenfolge der Daten muss mit der bei readStream übereinstimmen (z.B. hier: erst die Vehicle-Id und dann die rotation senden, und bei Readstream dann eben erst die vehicleId lesen und dann die rotation)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	-- wir übertragen das Vehicle in form seiner ID
	streamWriteBool(streamId, self.direction );	  -- wir übertragen die neue direction
end;

function RotationEvent:run(connection)	-- wir führen das empfangene event aus
	self.vehicle:setRotateDirection(self.direction, true); -- wir rufen die funktion setRotateDirection auf, damit auch hier bei uns die drehrichtung geändert wird. Das true ist hier wichtig, dann wir haben ein event erhalten, d.h. wir brauchen es nicht mehr versenden, weil es alle anderen mitpsieler schon erreicht hat! Das true also hier nie vergessen!!!!!!
	if not connection:getIsServer() then  -- wenn der Empfänger des Events der Server ist, dann soll er das Event an alle anderen Clients schicken
		g_server:broadcastEvent(RotationEvent:new(self.vehicle, self.direction), nil, connection, self.object);
	end;
end;

function RotationEvent.sendEvent(vehicle, direction, noEventSend)  -- hilfsfunktion, die Events anstößte (wirde von setRotateDirection in der Spezi aufgerufen)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then	  -- wenn wir der Server sind dann schicken wir das event an alle clients
			g_server:broadcastEvent(RotationEvent:new(vehicle, direction), nil, nil, vehicle);
		else -- wenn wir ein Client sind dann schicken wir das event zum server
			g_client:getServerConnection():sendEvent(RotationEvent:new(vehicle, direction));
		end;
	end;
end; 
