TwinWheelsEvent = {};
TwinWheelsEvent_mt = Class(TwinWheelsEvent, Event);

InitEventClass(TwinWheelsEvent, "TwinWheelsEvent");

TwinWheelsEventType = {
	TwinWheels = 1,
}

function TwinWheelsEvent:emptyNew()
    local self = Event:new(TwinWheelsEvent_mt);
    self.className="TwinWheelsEvent";
    return self;
end;

function TwinWheelsEvent:new(object, eventType, data)
    local self = TwinWheelsEvent:emptyNew()
    self.object = object;
	self.eventType = eventType;
	self.data = data;
    return self;
end;

function TwinWheelsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.eventType = streamReadUInt8(streamId);
	if self.eventType == TwinWheelsEventType.TwinWheels then
		self.data = streamReadBool(streamId);
		self.object:settwinWheels(self.data, true);
	end;
    if not connection:getIsServer() then
        g_server:broadcastEvent(TwinWheelsEvent:new(self.object, self.eventType, self.data), nil, connection, self.object);
    end;
end;

function TwinWheelsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteUInt8(streamId, self.eventType);
	streamWriteBool(streamId, self.data);
end;

function TwinWheelsEvent.sendEvent(vehicle, eventType, data)
	if g_server ~= nil then
		g_server:broadcastEvent(TwinWheelsEvent:new(vehicle, eventType, data), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(TwinWheelsEvent:new(vehicle, eventType, data));
	end;
end;

