Odometer = {};

function Odometer.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Odometer:load(xmlFile)
	self.Odometer = {};

	self.Odometer.Trip = 0;
	self.Odometer.Reading = 0;

	self.Odometer.posX = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.odometer#posX"), 0.7543);
	self.Odometer.posY = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.odometer#posY"), 0.2140);
	self.Odometer.HUD = Overlay:new("OdometerOverlay", Utils.getFilename("Textur/odometer_hud.png", self.baseDirectory), self.Odometer.posX, self.Odometer.posY, 0.2371, 0.039525);

	self.Odometer.Divisor = 20; -- Game units to tenths of a mile ratio, currently set to best guess
end;

function Odometer:delete()
end;

function OperatingHours:readStream(streamId, connection)
	self.Odometer.Trip = streamReadFloat32(streamId);
	self.Odometer.Reading = streamReadFloat32(streamId);
end;

function OperatingHours:writeStream(streamId, connection)
	streamWriteFloat32(streamId, self.Odometer.Trip);
	streamWriteFloat32(streamId, self.Odometer.Reading);
end;

function Odometer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Odometer:keyEvent(unicode, sym, modifier, isDown)
end;

function Odometer:update(dt)
end;

function Odometer:updateTick(dt)
	if self:getIsActive() or self.isHired then
		self.Odometer.Trip = self.Odometer.Trip + self.lastMovedDistance;
		self.Odometer.Reading = self.Odometer.Reading + self.lastMovedDistance;
	end;
end;

function Odometer:draw()
	local Trip = math.floor(self.Odometer.Trip / self.Odometer.Divisor);
	local Distance = math.floor(self.Odometer.Reading / self.Odometer.Divisor);

	self.Odometer.HUD:render();

	setTextAlignment(RenderText.ALIGN_RIGHT);
	setTextBold(true);
	setTextColor(1,1,1,1);

	renderText(self.Odometer.posX + 0.0770, self.Odometer.posY + 0.009800, 0.02, tostring(Trip));
	renderText(self.Odometer.posX + 0.2170, self.Odometer.posY + 0.009800, 0.02, tostring(Distance));

	setTextAlignment(RenderText.ALIGN_LEFT);
	setTextBold(false);
end;

function OperatingHours:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local Distance = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#odometer"), self.Odometer.Reading);
		self.Odometer.Reading = Distance;
	end;

	return BaseMission.VEHICLE_LOAD_OK;
end;

function OperatingHours:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'odometer="' .. tostring(self.Odometer.Reading) ..'"';
	return attributes, nil;
end;