LanguageSelector = {};

function LanguageSelector:loadMap(name)
  print("LanguageSelector ...");
  if g_currentMission.defendersModsLanguage == nil then
    self.configFileName = getUserProfileAppPath().."defendersmods.xml";
    local lang;
    local testFile = io.open (self.configFileName, "r");  
    if testFile ~= nil then    
      self.xmlFile = loadXMLFile("configFile", self.configFileName);
      lang = getXMLString(self.xmlFile,"defendersMods#language");
      self.xmlFile = nil;
      testFile:close();
    end;
    if lang == nil then
      self.doIt = true;
    else
      self.doIt = false;
      g_currentMission.defendersModsLanguage = lang;
    end;
    self.running = false;
    if self.doIt then
      self.panelPath = getUserProfileAppPath().."mods/zzz_tipAnywhere/LanguageSelection.png";
      self.layer = Overlay:new("LanguageSelectorOverlay", self.panelPath, 0.15, 0.2, 0.7, 0.6);
      self.selectPath = getUserProfileAppPath().."mods/zzz_tipAnywhere/select.png";
      self.select = Overlay:new("selectOverlay", self.selectPath, 0, 0, 0.3, 0.3);         
      self.predvolba = 3;
      self.x = {};
      self.x[1]= 0.187 + ((self.predvolba-1)*0.123);
      self.volba = 3;
    end;
  else
    self.doIt = false;
    self.running = false;
  end; 
end;

function LanguageSelector:deleteMap()
end;

function LanguageSelector:mouseEvent(posX, posY, isDown, isUp, button)
end;

function LanguageSelector:keyEvent(unicode, sym, modifier, isDown)
end;

function LanguageSelector:update(dt)
  if self.doIt and g_currentMission.missionStats.playTimeSession > 0 then
    self.doIt = false;
    self.running = true;
  end;
  if self.running then
    if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
      self.running = false;
      if self.volba == 1 then
        g_currentMission.defendersModsLanguage = "en";
      elseif self.volba == 2 then
        g_currentMission.defendersModsLanguage = "de";
      elseif self.volba == 3 then
        g_currentMission.defendersModsLanguage = "cz";
      elseif self.volba == 4 then
        g_currentMission.defendersModsLanguage = "hu";
      elseif self.volba == 5 then
        g_currentMission.defendersModsLanguage = "pl";
      end;
      if not self.running and (g_currentMission.defendersModsLanguage ~= nil) then      
        local xmlFile = io.open (self.configFileName, "w");
        if (xmlFile ~= nil) then
          xmlFile:write('<?xml version="1.0" encoding="iso-8859-1" standalone="no" ?>\n');
          xmlFile:write('<defendersMods language="'..tostring(g_currentMission.defendersModsLanguage)..'" />');
          xmlFile:close();
        end;
      end;
    end;
    
    if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
      self.predvolba = self.volba;
      self.volba = self.volba + 1;
      if self.volba > 5 then
        self.volba = 1;
      end;
    end;
    local min = {};
    min[1]=0.187 + ((self.predvolba-1)*0.123);
    local max = {};
    max[1]=0.187 + ((self.volba-1)*0.123);
    local tim = 500;
    if self.predvolba - self.volba > 1 then
      tim = 1000;
    end;
    self.x = Utils.getMovedLimitedValues(self.x, min, max, 1, tim, dt, true);    
  end;    
end;

function LanguageSelector:draw()
  if self.running then
    self.layer:render();
    renderOverlay(self.select.overlayId, self.x[1] , 0.407, 0.135, 0.227);   
  end;
end;

addModEventListener(LanguageSelector);

language = {};
language.verze = 2.0;
language.default = "cz";
language.cz = {};
language.en = {};
language.de = {};
language.hu = {};
language.pl = {};

function language:getText(name)
  local lang = self.default;
  if g_currentMission.defendersModsLanguage ~= nil then
    lang = g_currentMission.defendersModsLanguage;
  end;
  local result;  
  if lang == "en" then
    result = self.en[name];
  elseif lang == "de" then 
    result = self.de[name];
  elseif lang == "cz" then
    result = self.cz[name];
  elseif lang == "hu" then
    result = self.hu[name]; 
  elseif lang == "pl" then
    result = self.pl[name];
  end; 
  if result == nil then
    result = "";
  end;
  return result;
end;

function language:loadTexts(fileName)
  self.xmlFile = loadXMLFile("langFile", fileName);
--  if hasXMLProperty(self.xmlFile, "modDesc.l10n") then
    local i = 0;
    while true do
      local key = string.format("modDesc.l10n.text(%d)",i);
      local name = getXMLString(self.xmlFile, key.."#name");
      if name == nil then
        break;
      end;
      local _en = getXMLString(self.xmlFile, key..".en");
      local _de = Utils.getNoNil(getXMLString(self.xmlFile, key..".de"),_en);
      local _cz = Utils.getNoNil(getXMLString(self.xmlFile, key..".cz"),_en);
      local _hu = Utils.getNoNil(getXMLString(self.xmlFile, key..".hu"),_en);
      local _pl = Utils.getNoNil(getXMLString(self.xmlFile, key..".pl"),_en);      
      self.en[name] = _en;
      self.de[name] = _de;
      self.cz[name] = _cz;
      self.hu[name] = _hu;
      self.pl[name] = _pl;
      i = i + 1;
    end;
--  end;
  self.xmlFile = nil;
end;

if g_i18n.DML == nil or g_i18n.DML.verze<language.verze then
  if g_i18n.DML ~= nil then
    language.en = g_i18n.DML.en;
    language.de = g_i18n.DML.de;
    language.cz = g_i18n.DML.cz;
    language.hu = g_i18n.DML.hu;
    language.pl = g_i18n.DML.pl;
  end; 
  g_i18n.DML = language;
end;