
LiebherrSchaufel = {};

function LiebherrSchaufel.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function LiebherrSchaufel:load(xmlFile)
	self.shovelInRange = SpecializationUtil.callSpecializationsFunction("shovelInRange");	
	
	self.dustParticleSystems = {};
    local dustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems#count"), 0);
    for i=1, dustParticleSystemCount do
        local namei = string.format("vehicle.dustParticleSystems.part%d", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
	self.chargeParticle = {};
    local i = 0;
    while true do
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chargeParticle#index"));
        local key = string.format("vehicle.chargeParticle.chargeParticle(%d)", i);
        local t = getXMLString(xmlFile, key.."#type");
		if t == nil then
            break;
        end
        local currentPS = {};
		local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, nodei, false, "$data/vehicles/particleSystems/trailerDischargeParticleSystem.i3d", self.baseDirectory);
		self.chargeParticle[t] = currentPS;
		i = i +1;
    end;
	
	self.keyType = InputBinding.getButtonKeyName;
	self.keyName = "Taste"; 
	
	self.isShovel = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.isShovel#value"), false);
end;

function LiebherrSchaufel:update(dt)
	if self.attacherVehicle then
		self:shovelInRange();
	end;
end;

function LiebherrSchaufel:shovelInRange()
    local nearestDistance = 4.0;
	self.inRange = false; 
	local px, py, pz = getWorldTranslation(self.rootNode);
	Utils.setEmittingState(self.savePS, false);
	for i=1, table.getn(g_currentMission.attachables) do
		local vx, vy, vz = getWorldTranslation(g_currentMission.attachables[i].rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		local attachable = g_currentMission.attachables[i];	
		if distance < nearestDistance and self.filllevel ~= 0 and self.currentFillType ~= nil and attachable:allowFillType(self.currentFillType, true) and attachable.setFillLevel and self.setFillLevel then
			for fruitType,v in pairs(attachable.fillTypes) do
				if fruitType == self.currentFillType then
					local x,y,z = localDirectionToWorld(self.rootNode, 0,0,1);
					local x,yShovel,z = worldDirectionToLocal(self.attacherVehicle.rootNode, x,y,z);
					if yShovel >= 0.0  then
						if attachable.setFillLevel ~= nil and attachable.rootNode ~= self.rootNode then
							if attachable.fillLevel == attachable.capacity then
								Utils.setEmittingState(self.savePS, false);
							else
								if self.fillLevel ~= 0 and self.setFillLevel ~= nil then
									self.savePS = self.chargeParticle[FruitUtil.fruitIndexToDesc[self.currentFillType].name];
									Utils.setEmittingState(self.savePS, true);
								end; 										
								if self.fillLevel < -0 then
									self.fillLevel = 0; 
									self:setFillLevel(0.0, FruitUtil.FRUITTYPE_UNKNOWN); 
								end;
									
								if self.fillLevel > 0 then
									self.fillLevel = self.fillLevel - yShovel * 100;
									local newLevel = attachable.fillLevel + yShovel * 100;
									attachable:setFillLevel(newLevel, self.currentFillType);	
								end; 
								
								self.inRange = true; 
							end; 
						end; 
					end; 
				end;
			end;
		end; 
    end;
	
	if not self.inRange or self.fillLevel == 0 then
		Utils.setEmittingState(self.savePS, false);
	end; 
end;

function LiebherrSchaufel:delete()
	Utils.setEmittingState(self.savePS, false);
	Utils.setEmittingState(self.chargeParticle, false)
	Utils.deleteParticleSystem(self.chargeParticle)
end;

function LiebherrSchaufel:mouseEvent(posX, posY, isDown, isUp, button)
end;

function LiebherrSchaufel:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym==Input.KEY_8 then
		self.keySet = not self.keySet; 
		if self.keySet then
			self.keyType = InputBinding.getButtonName;
			self.keyName = "Button"; 
		else
			self.keyType = InputBinding.getButtonKeyName;
			self.keyName = "Taste"; 
		end; 
	end; 
end;

function LiebherrSchaufel:draw()
end;