--
-- Body Bagger Working Script
--
-- by Zippo
-- 


LiebherrMMDA = {}

function LiebherrMMDA.prerequisitesPresent(specializations)
	Vehicle.registerJointType("frontloader");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function LiebherrMMDA:load(xmlFile)
    
	local rotationNode1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation1#index"));
    if rotationNode1 ~= nil then
        self.rotation1 = {};
        self.rotation1.node = rotationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#minRot"));
        self.rotation1.minRot = {};
        self.rotation1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#maxRot"));
        self.rotation1.maxRot = {};
        self.rotation1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotation1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#rotTime"), 2)*1000;
        self.rotation1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#touchRotLimit"), 10));
    end;
	
	local rotationNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation2#index"));
    if rotationNode2 ~= nil then
        self.rotation2 = {};
        self.rotation2.node = rotationNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#minRot"));
        self.rotation2.minRot = {};
        self.rotation2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#maxRot"));
        self.rotation2.maxRot = {};
        self.rotation2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotation2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation2#rotTime"), 2)*1000;
        self.rotation2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation2#touchRotLimit"), 10));
    end;
    local rotationNode3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation3#index"));
    if rotationNode3 ~= nil then
        self.rotation3 = {};
        self.rotation3.node = rotationNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#minRot"));
        self.rotation3.minRot = {};
        self.rotation3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#maxRot"));
        self.rotation3.maxRot = {};
        self.rotation3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotation3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation3#rotTime"), 2)*1000;
        self.rotation3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation3#touchRotLimit"), 10));
    end;
    
    local rotationNode4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation4#index"));
    if rotationNode4 ~= nil then
        self.rotation4 = {};
        self.rotation4.node = rotationNode4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation4#minRot"));
        self.rotation4.minRot = {};
        self.rotation4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation4#maxRot"));
        self.rotation4.maxRot = {};
        self.rotation4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotation4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation4#rotTime"), 2)*1000;
        self.rotation4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation4#touchRotLimit"), 10));
    end;
 
    local rotationNode5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation5#index"));
    if rotationNode5 ~= nil then
        self.rotation5 = {};
        self.rotation5.node = rotationNode5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation5#minRot"));
        self.rotation5.minRot = {};
        self.rotation5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation5#maxRot"));
        self.rotation5.maxRot = {};
        self.rotation5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotation5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation5#rotTime"), 2)*1000;
        self.rotation5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation5#touchRotLimit"), 10));
    end;
 
	local rotationNode6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation6#index"));
    if rotationNode6 ~= nil then
        self.rotation6 = {};
        self.rotation6.node = rotationNode6;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation6#minRot"));
        self.rotation6.minRot = {};
        self.rotation6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation6#maxRot"));
        self.rotation6.maxRot = {};
        self.rotation6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotation6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation6#rotTime"), 2)*1000;
        self.rotation6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation6#touchRotLimit"), 10));
    end;	

	local hydraulic = getXMLString(xmlFile, "vehicle.hydraulic#indexHydraulic");
	if hydraulic ~= nil then
		self.hydraulic = {};
		self.hydraulic.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic#indexHydraulic"));
		self.hydraulic.punch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic#indexPunch"));
		self.hydraulic.translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic#translationPunch"));
		local ax, ay, az = getWorldTranslation(self.hydraulic.punch);
		local bx, by, bz = getWorldTranslation(self.hydraulic.translationPunch);
		self.hydraulic.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);

		self.hydraulic2 = {};
		self.hydraulic2.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic2#indexHydraulic"));
		self.hydraulic2.punch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic2#indexPunch"));
		self.hydraulic2.translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic2#translationPunch"));
		local ax, ay, az = getWorldTranslation(self.hydraulic2.punch);
		local bx, by, bz = getWorldTranslation(self.hydraulic2.translationPunch);
		self.hydraulic2.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			
		self.hydraulic3 = {};
		self.hydraulic3.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic3#indexHydraulic"));
		self.hydraulic3.punch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic3#indexPunch"));
		self.hydraulic3.translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic3#translationPunch"));
		local ax, ay, az = getWorldTranslation(self.hydraulic3.punch);
		local bx, by, bz = getWorldTranslation(self.hydraulic3.translationPunch);
		self.hydraulic3.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);

		self.hydraulic4 = {};
		self.hydraulic4.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic4#indexHydraulic"));
		self.hydraulic4.punch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic4#indexPunch"));
		self.hydraulic4.translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic4#translationPunch"));
		local ax, ay, az = getWorldTranslation(self.hydraulic4.punch);
		local bx, by, bz = getWorldTranslation(self.hydraulic4.translationPunch);
		self.hydraulic4.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);

		self.hydraulic5 = {};
		self.hydraulic5.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic5#indexHydraulic"));
		self.hydraulic5.punch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic5#indexPunch"));
		self.hydraulic5.translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic5#translationPunch"));
		local ax, ay, az = getWorldTranslation(self.hydraulic5.punch);
		local bx, by, bz = getWorldTranslation(self.hydraulic5.translationPunch);
		self.hydraulic5.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);

		self.hydraulic6 = {};
		self.hydraulic6.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic6#indexHydraulic"));
		self.hydraulic6.punch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic6#indexPunch"));
		self.hydraulic6.translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic6#translationPunch"));
		local ax, ay, az = getWorldTranslation(self.hydraulic6.punch);
		local bx, by, bz = getWorldTranslation(self.hydraulic6.translationPunch);
		self.hydraulic6.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);

		self.hydraulic7 = {};
		self.hydraulic7.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic7#indexHydraulic"));
		self.hydraulic7.punch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic7#indexPunch"));
		self.hydraulic7.translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic7#translationPunch"));
		local ax, ay, az = getWorldTranslation(self.hydraulic7.punch);
		local bx, by, bz = getWorldTranslation(self.hydraulic7.translationPunch);
		self.hydraulic7.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);

		self.hydraulic8 = {};
		self.hydraulic8.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic8#indexHydraulic"));
		self.hydraulic8.punch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic8#indexPunch"));
		self.hydraulic8.translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic8#translationPunch"));
		local ax, ay, az = getWorldTranslation(self.hydraulic8.punch);
		local bx, by, bz = getWorldTranslation(self.hydraulic8.translationPunch);
		self.hydraulic8.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);		
		
		self.hydraulicPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic#hydraulicPoint"));
		self.hydraulicPoint2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic2#hydraulicPoint2"));
		self.hydraulicPoint3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic3#hydraulicPoint3"));
		self.hydraulicPoint4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic4#hydraulicPoint4"));
		self.hydraulicPoint5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic5#hydraulicPoint5"));
		self.hydraulicPoint6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic6#hydraulicPoint6"));
		self.hydraulicPoint7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic7#hydraulicPoint7"));
		self.hydraulicPoint8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic8#hydraulicPoint8"));	
	end;

	hydraulicSoundFile = Utils.getFilename("Sounds/hydraRot.wav", self.baseDirectory);
    self.hydraulicSoundId = createSample("hydraulicSound");
    loadSample(self.hydraulicSoundId, hydraulicSoundFile, false);
    self.hydraulicPlaying = false;
	self.hydraulicSoundAllow = false;	
end;
      
function LiebherrMMDA:delete()
end;

function LiebherrMMDA:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function LiebherrMMDA:keyEvent(unicode, sym, modifier, isDown)
--[[ Aufbau ]]--
    if sym == Input.KEY_j then
		self.rotation1Max = isDown;
	end;
    if sym == Input.KEY_n then
		self.rotation1Min = isDown;
	end;
	
--[[ Schaufelarm ]]--	
	if sym == Input.KEY_KP_9 then
		self.rotation4Max = isDown;
	end;
	if sym == Input.KEY_KP_3 then
		self.rotation4Min = isDown;
	end;	
	
--[[ Hubarm ]]--	
	if sym == Input.KEY_k then
		self.rotation2Max = isDown;
		self.rotation3Max = isDown;
	end;
	if sym == Input.KEY_m then
		self.rotation2Min = isDown;
		self.rotation3Min = isDown;
	end;
		
--[[ Schaufel ]]--	
	if sym == Input.KEY_KP_7 then
		self.rotation5Max = isDown;
		self.rotation6Max = isDown;
	end;
	if sym == Input.KEY_KP_1 then
		self.rotation5Min = isDown;
		self.rotation6Min = isDown;
	end;
	
	if isDown then
		if sym == Input.KEY_KP_1 or sym == Input.KEY_KP_2 or sym == Input.KEY_KP_3 or sym == Input.KEY_KP_4
		or sym == Input.KEY_KP_5 or sym == Input.KEY_KP_6 or sym == Input.KEY_KP_7 or sym == Input.KEY_KP_8
		or sym == Input.KEY_KP_9 or sym == Input.KEY_j or sym == Input.KEY_k or sym == Input.KEY_n or sym == Input.KEY_m then
			self.hydraulicSoundAllow = true;
		end;
	else
		self.hydraulicSoundAllow = false;
	end;
end;

function LiebherrMMDA:update(dt)
	local doRotate = self.rotation1Max or self.rotation1Min 
	if self.rotation1 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation1.maxRot, self.rotation1.minRot, 3, self.rotation1.rotTime, dt, not self.rotation1Max);
        setRotation(self.rotation1.node, unpack(newRot));
		if self.hydraulicSoundAllow and not self.hydraulicPlaying then
			playSample(self.hydraulicSoundId,0,1,0);
			self.hydraulicPlaying = true;
		end;
	elseif not self.hydraulicSoundAllow and self.hydraulicPlaying then
		stopSample(self.hydraulicSoundId);
		self.hydraulicPlaying = false;
	end;	
	local doRotate = self.rotation2Max or self.rotation2Min 
	if self.rotation2 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation2.maxRot, self.rotation2.minRot, 3, self.rotation2.rotTime, dt, not self.rotation2Max);
        setRotation(self.rotation2.node, unpack(newRot));
		if self.hydraulicSoundAllow and not self.hydraulicPlaying then
			playSample(self.hydraulicSoundId,0,1,0);
			self.hydraulicPlaying = true;
		end;
	elseif not self.hydraulicSoundAllow and self.hydraulicPlaying then
		stopSample(self.hydraulicSoundId);
		self.hydraulicPlaying = false;
	end;	
    local doRotate = self.rotation3Max or self.rotation3Min 
	if self.rotation3 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation3.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation3.maxRot, self.rotation3.minRot, 3, self.rotation3.rotTime, dt, not self.rotation3Max);
        setRotation(self.rotation3.node, unpack(newRot));
		if self.hydraulicSoundAllow and not self.hydraulicPlaying then
			playSample(self.hydraulicSoundId,0,1,0);
			self.hydraulicPlaying = true;
		end;
	elseif not self.hydraulicSoundAllow and self.hydraulicPlaying then
		stopSample(self.hydraulicSoundId);
		self.hydraulicPlaying = false;
	end;	
    local doRotate = self.rotation4Max or self.rotation4Min 
	if self.rotation4 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation4.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation4.maxRot, self.rotation4.minRot, 3, self.rotation4.rotTime, dt, not self.rotation4Max);
        setRotation(self.rotation4.node, unpack(newRot));
		if self.hydraulicSoundAllow and not self.hydraulicPlaying then
			playSample(self.hydraulicSoundId,0,1,0);
			self.hydraulicPlaying = true;
		end;
	elseif not self.hydraulicSoundAllow and self.hydraulicPlaying then
		stopSample(self.hydraulicSoundId);
		self.hydraulicPlaying = false;
	end;	
    local doRotate = self.rotation5Max or self.rotation5Min 
	if self.rotation5 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation5.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation5.maxRot, self.rotation5.minRot, 3, self.rotation5.rotTime, dt, not self.rotation5Max);
        setRotation(self.rotation5.node, unpack(newRot));
		if self.hydraulicSoundAllow and not self.hydraulicPlaying then
			playSample(self.hydraulicSoundId,0,1,0);
			self.hydraulicPlaying = true;
		end;
	elseif not self.hydraulicSoundAllow and self.hydraulicPlaying then
		stopSample(self.hydraulicSoundId);
		self.hydraulicPlaying = false;
	end;	
	local doRotate = self.rotation6Max or self.rotation6Min 
	if self.rotation6 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation6.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation6.maxRot, self.rotation6.minRot, 3, self.rotation6.rotTime, dt, not self.rotation6Max);
        setRotation(self.rotation6.node, unpack(newRot));
		if self.hydraulicSoundAllow and not self.hydraulicPlaying then
			playSample(self.hydraulicSoundId,0,1,0);
			self.hydraulicPlaying = true;
		end;
	elseif not self.hydraulicSoundAllow and self.hydraulicPlaying then
		stopSample(self.hydraulicSoundId);
		self.hydraulicPlaying = false;
	end;	
	
	if self.hydraulic ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulic.node);
		local bx, by, bz = getWorldTranslation(self.hydraulicPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulic.node), bx-ax, by-ay, bz-az);
		setDirection(self.hydraulic.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.hydraulic.punch, 0, 0, (distance-self.hydraulic.punchDistance)*-1);
		end;
	end;
	if self.hydraulic2 ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulic2.node);
		local bx, by, bz = getWorldTranslation(self.hydraulicPoint2);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulic2.node), bx-ax, by-ay, bz-az);
		setDirection(self.hydraulic2.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.hydraulic2.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.hydraulic2.punch, 0, 0, (distance-self.hydraulic2.punchDistance)*-1);
		end;
	end;
	if self.hydraulic3 ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulic3.node);
		local bx, by, bz = getWorldTranslation(self.hydraulicPoint3);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulic3.node), bx-ax, by-ay, bz-az);
		setDirection(self.hydraulic3.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.hydraulic3.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.hydraulic3.punch, 0, 0, (distance-self.hydraulic3.punchDistance)*-1);
		end;
	end;
	if self.hydraulic4 ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulic4.node);
		local bx, by, bz = getWorldTranslation(self.hydraulicPoint4);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulic4.node), bx-ax, by-ay, bz-az);
		setDirection(self.hydraulic4.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.hydraulic4.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.hydraulic4.punch, 0, 0, (distance-self.hydraulic4.punchDistance)*-1);
		end;
	end;
	if self.hydraulic5 ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulic5.node);
		local bx, by, bz = getWorldTranslation(self.hydraulicPoint5);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulic5.node), bx-ax, by-ay, bz-az);
		setDirection(self.hydraulic5.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.hydraulic5.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.hydraulic5.punch, 0, 0, (distance-self.hydraulic5.punchDistance)*-1);
		end;
	end;
	if self.hydraulic6 ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulic6.node);
		local bx, by, bz = getWorldTranslation(self.hydraulicPoint6);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulic6.node), bx-ax, by-ay, bz-az);
		setDirection(self.hydraulic6.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.hydraulic6.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.hydraulic6.punch, 0, 0, (distance-self.hydraulic6.punchDistance)*-1);
		end;
	end;
	if self.hydraulic7 ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulic7.node);
		local bx, by, bz = getWorldTranslation(self.hydraulicPoint7);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulic7.node), bx-ax, by-ay, bz-az);
		setDirection(self.hydraulic7.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.hydraulic7.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.hydraulic7.punch, 0, 0, (distance-self.hydraulic7.punchDistance)*-1);
		end;
	end;
	if self.hydraulic8 ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulic8.node);
		local bx, by, bz = getWorldTranslation(self.hydraulicPoint8);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulic8.node), bx-ax, by-ay, bz-az);
		setDirection(self.hydraulic8.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.hydraulic8.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.hydraulic8.punch, 0, 0, (distance-self.hydraulic8.punchDistance)*-1);
		end;
	end;	
end;

function LiebherrMMDA:draw()
end;

function LiebherrMMDA:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
