-- fergtrailersides
-- Henly20

fergtrailersides = {};

function fergtrailersides.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function fergtrailersides:load(xmlFile)

	self.setRotationMax1 = SpecializationUtil.callSpecializationsFunction("setRotationMax1");
	self.setRotationMax2 = SpecializationUtil.callSpecializationsFunction("setRotationMax2");
	self.setRotationMax3 = SpecializationUtil.callSpecializationsFunction("setRotationMax3");
	self.setCrateVisibility = SpecializationUtil.callSpecializationsFunction("setCrateVisibility");

	local rotationPartNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart1#index"));
		if rotationPartNode1 ~= nil then
        self.rotationPart1 = {};
        self.rotationPart1.node = rotationPartNode1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#minRot"));
        self.rotationPart1.minRot = {};
        self.rotationPart1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#maxRot"));
        self.rotationPart1.maxRot = {};
        self.rotationPart1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#rotTime"), 2)*1000;
        self.rotationPart1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#touchRotLimit"), 10));
    end;
	local rotationPartNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart2#index"));
		if rotationPartNode2 ~= nil then
        self.rotationPart2 = {};
        self.rotationPart2.node = rotationPartNode2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#minRot"));
        self.rotationPart2.minRot = {};
        self.rotationPart2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#maxRot"));
        self.rotationPart2.maxRot = {};
        self.rotationPart2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#rotTime"), 2)*1000;
        self.rotationPart2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#touchRotLimit"), 10));
    end;
		local rotationPartNode3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart3#index"));
		if rotationPartNode3 ~= nil then
        self.rotationPart3 = {};
        self.rotationPart3.node = rotationPartNode3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#minRot"));
        self.rotationPart3.minRot = {};
        self.rotationPart3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#maxRot"));
        self.rotationPart3.maxRot = {};
        self.rotationPart3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#rotTime"), 2)*1000;
        self.rotationPart3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#touchRotLimit"), 10));
    end;

	self.rotationMax1 = false;	
	self.rotationMax2 = false;
	self.rotationMax3 = false;

	self.crate1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.crates#index1"));-- corner posts
	self.crate2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.crates#index2"));-- left crate
	self.crate3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.crates#index3"));-- right crate
	self.crate4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.crates#index4"));-- back frame
	
	setVisibility(self.crate1,true);
	setVisibility(self.crate2,true);
	setVisibility(self.crate3,true);
	setVisibility(self.crate4,false);
end;

function fergtrailersides:readStream(streamId, connection)
     self.rotateMax1 = streamReadBool(streamId);
     self.rotateMax2 = streamReadBool(streamId);
     self.rotateMax3 = streamReadBool(streamId);

      if self.rotationPart1 ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
          setRotation(self.rotationPart1.node, x, y, z);
      end;
      if self.rotationPart2 ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
          setRotation(self.rotationPart2.node, x, y, z);
      end;
      if self.rotationPart3 ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
          setRotation(self.rotationPart3.node, x, y, z);
      end;
	  
	self.isLoading = true;
	local crate = streamReadBool(streamId);
	self:setCrateVisibility(crate, true);
end;

function fergtrailersides:writeStream(streamId, connection)
	streamWriteBool(streamId, self.rotateMax1);
	streamWriteBool(streamId, self.rotateMax2);	
	streamWriteBool(streamId, self.rotateMax3);
	streamWriteBool(streamId, self.crate);		
		if self.rotationPart1 ~= nil then
          local x, y, z = getRotation(self.rotationPart1.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
		if self.rotationPart2 ~= nil then
          local x, y, z = getRotation(self.rotationPart2.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
		if self.rotationPart3 ~= nil then
          local x, y, z = getRotation(self.rotationPart3.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
	streamWriteBool(streamId, self.crate);	
	
end;

function fergtrailersides:delete()


end;

function fergtrailersides:mouseEvent(posX, posY, isDown, isUp, button)
end;

function fergtrailersides:keyEvent(unicode, sym, modifier, isDown)

	

end;
function fergtrailersides:update(dt)
      if self:getIsActiveForInput() then
		if not self.crateId then
			if InputBinding.hasEvent(InputBinding.CRATERIGHT) then
				self:setRotationMax1(not self.rotationMax1);
			end;
			if InputBinding.hasEvent(InputBinding.CRATELEFT) then
				self:setRotationMax2(not self.rotationMax2);
			end;
		end
          if InputBinding.hasEvent(InputBinding.CRATEBACK) then
				self:setRotationMax3(not self.rotationMax3);
          end;
          if InputBinding.hasEvent(InputBinding.CRATEVISIBILITY) then
				self:setCrateVisibility(not self.crateId);
          end;		  
     end;
	
end;	

function fergtrailersides:updateTick(dt)
	if self:getIsActive() and self.isClient then
		if self.rotationPart1 ~= nil then
			local x, y, z = getRotation(self.rotationPart1.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart1.maxRot, self.rotationPart1.minRot, 3, self.rotationPart1.rotTime, dt, not self.rotationMax1);
			setRotation(self.rotationPart1.node, unpack(newRot));
		end;
		if self.rotationPart2 ~= nil then
			local x, y, z = getRotation(self.rotationPart2.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart2.maxRot, self.rotationPart2.minRot, 3, self.rotationPart2.rotTime, dt, not self.rotationMax2);
			setRotation(self.rotationPart2.node, unpack(newRot));
		end;
		if self.rotationPart3 ~= nil then
			local x, y, z = getRotation(self.rotationPart3.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart3.maxRot, self.rotationPart3.minRot, 3, self.rotationPart3.rotTime, dt, not self.rotationMax3);
			setRotation(self.rotationPart3.node, unpack(newRot));
		end;
		
			for i, jointDesc in pairs(self.componentJoints) do
				setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
			end;	

		

	end;
end;

function fergtrailersides:draw()

	g_currentMission:addExtraPrintText("Key 5/6/7:                               (Un)Fold Crates");
	g_currentMission:addExtraPrintText("Key 8:                               Remove Side Crates");
		
	if self.crateId and (InputBinding.isPressed(InputBinding.CRATERIGHT) or InputBinding.isPressed(InputBinding.CRATELEFT))  then
		g_currentMission:addWarning(string.format("Add crates (Key 8) before trying to fold", 0.07+0.022, 0.019+0.029));
	end;	
end;

function fergtrailersides:setRotationMax1(rotationMax1, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
              g_server:broadcastEvent(SetCrateRotationEvent:new(self, rotationMax1), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetCrateRotationEvent:new(self, rotationMax1));
          end;
      end;
      self.rotationMax1 = rotationMax1;
end;

function fergtrailersides:setRotationMax2(rotationMax2, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
              g_server:broadcastEvent(SetCrateRotationoneEvent:new(self, rotationMax2), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetCrateRotationoneEvent:new(self, rotationMax2));
          end;
      end;
      self.rotationMax2 = rotationMax2;

end;

function fergtrailersides:setRotationMax3(rotationMax3, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
              g_server:broadcastEvent(SetCrateRotationtwoEvent:new(self, rotationMax3), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetCrateRotationtwoEvent:new(self, rotationMax3));
          end;
      end;
      self.rotationMax3 = rotationMax3;
	  
	if self.rotationMax3 then
		setVisibility(self.crate4,true);
		setVisibility(self.crate1,false);
	elseif not self.rotationMax3 then
		setVisibility(self.crate4,false);
		setVisibility(self.crate1,true);
	end;		
end;

function fergtrailersides:setCrateVisibility(crate, noEventSend)
	if crate ~= self.crateId then
		 if noEventSend == nil or noEventSend == false then
			  if g_server ~= nil then
				  g_server:broadcastEvent(SetCrateVisibilityEvent:new(self, crate), nil, nil, self);
			  else
				  g_client:getServerConnection():sendEvent(SetCrateVisibilityEvent:new(self, crate));
			  end;
		  end;	
		  
		self.crateId = crate;
		
		if not self.crateId then
			setVisibility(self.crate2,true);
			setVisibility(self.crate3,true);
			self.rotationMax1 = false;
			self.rotationMax2 = false;
		elseif self.crateId then
			setVisibility(self.crate2,false);
			setVisibility(self.crate3,false);
			self.rotationMax1 = true;
			self.rotationMax2 = true;
		end;
	end;
end;
