--
-- fergflatbedattach
-- Class Balle-AttachAble Tippers
--
-- @author  Geri-G
-- @date  13/07/10
--
-- Copyright (C) Geri-G

fergflatbedattach = {};

function fergflatbedattach.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function fergflatbedattach:load(xmlFile)

	self.setAttachBales = SpecializationUtil.callSpecializationsFunction("setAttachBales");
	self.searchBales = fergflatbedattach.searchBales;
	self.attachobjects = fergflatbedattach.attachobjects;
	self.detachobjects = fergflatbedattach.detachobjects;
	self.OrientJoint = fergflatbedattach.OrientJoint;
	self.setWorkState = fergflatbedattach.setWorkState;
	self.isBaleInRange = fergflatbedattach.isBaleInRange;
	self.place = {};
	self.place.node1 = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Baletrailer#castPoint1"));		
	self.place.node2 = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Baletrailer#castPoint2"));
	self.place.attacherNode = Utils.indexToObject(self.components, Utils.getNoNil(getXMLString(xmlFile,"vehicle.Baletrailer#attacherNode"),"0>"));
	self.place.highOffset = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.Baletrailer#highOffset"),4);	
	self.Attachedobjects = {};
	self.attacherMod = 0;
	self.attacherModOld = 0;
	self.allowAttachment = true;
	self.balesAttached = false;
end;
function fergflatbedattach:readStream(streamId, connection)
	      local attachBales = streamReadBool(streamId);
      self:setAttachBales(attachBales, true);	
end;

function fergflatbedattach:writeStream(streamId, connection)
      streamWriteBool(streamId, self.isAttachBales);
end;
function fergflatbedattach:update(dt)
      if self:getIsActiveForInput() then
              if InputBinding.hasEvent(InputBinding.ATTACHBALEFERGTRAILER) then
                  self:setAttachBales(not self.isAttachBales);
              end;
      end;
end;

function fergflatbedattach:updateTick(dt)
	if self:getIsActive() and self.isServer then
		if self.isAttachBales then
			if self.balesAttached == false then
				self:setWorkState(false);
			end;
		else
			if self.balesAttached == true then
				self:setWorkState(true);
			end;
		end;
	end;
end;
function fergflatbedattach:draw()

	if self:getIsActive() then
	if self.isAttachBales then
		g_currentMission:addExtraPrintText("Key O:                                        Unlock Bale");
	else
		g_currentMission:addExtraPrintText("Key O:                                          Lock Bale");
	end;
	end;

end;
function fergflatbedattach:isBaleInRange(node1,node2,Yoffset,Bale)
	local Xmax, Ymax, Zmax = getWorldTranslation(node1);
		  Xmax, Ymax, Zmax = worldToLocal(self.place.attacherNode,Xmax, Ymax, Zmax);
		  
	local Xmin, Ymin, Zmin = getWorldTranslation(node2);	
		  Xmin, Ymin, Zmin = worldToLocal(self.place.attacherNode,Xmin, Ymin, Zmin);
	
	local Xt, Yt, Zt = getWorldTranslation(Bale);
		  Xt, Yt, Zt = worldToLocal(self.place.attacherNode,Xt, Yt, Zt);
		
	if (Xt < math.max(Xmax,Xmin) and Xt > math.min(Xmax,Xmin)) and (Zt < math.max(Zmax,Zmin) and Zt > math.min(Zmax,Zmin)) and (Yt<= ((Ymax+Ymin)/2)+Yoffset and Yt>= (Ymax+Ymin)/2) then
		return true;
	else
		return false;
	end;
end;
function fergflatbedattach:searchBales()
	for index,item in pairs(g_currentMission.itemsToSave) do
		if item.item:isa(Bale) then 

			if item.item.isAttached == nil then--and (getUserAttribute(item.item.nodeId, "isHaybale") == true or getUserAttribute(item.item.nodeId, "isStrawbale") == true or getUserAttribute(item.item.nodeId, "isRoundbale") == true) then

				local isInRange = self:isBaleInRange(self.place.node1,self.place.node2,self.place.highOffset,item.item.nodeId);			

				local is1stAttached = false;
				if isInRange then
					is1stAttached = self:attachobjects(item.item.nodeId,item.item);
				end;
				if is1stAttached then
					self.balesAttached = true;
				end;
			end;
		end;
	end;
	for k,v in pairs(g_currentMission.vehicles) do
		if v ~= self and v ~= self.attacherVehicle then
			local is1stAttached = false;
			for index,components in pairs(v.components) do		
				local isInRange = self:isBaleInRange(self.place.node1,self.place.node2,self.place.highOffset,components.node);	
				if isInRange then	
					is1stAttached = self:attachobjects(components.node);
				end;
			end;
			if is1stAttached then
				self.balesAttached = true;
			end;
		end;
	end;
end;

function fergflatbedattach:setAttachBales(attachBales, noEventSend)
      AttachBaleEvent.sendEvent(self, attachBales, noEventSend)
      self.isAttachBales = attachBales;
end;

function fergflatbedattach:setWorkState(attachBales,noEventSend)
	--setWorkState.sendEvent(self, attachBales, noEventSend);
	if attachBales then
		self:detachobjects();	
	else
		self:searchBales();
	end;
end;
function fergflatbedattach:OrientJoint(Source, Target)	
	local xw, yw, zw = getWorldTranslation(Source);		
	local x,y,z = worldToLocal(getParent(Target), xw, yw, zw);	
	setTranslation(Target, x,y,z);			
	--JointRotation Anpassung an das Objekt
	local zX, zY, zZ = localDirectionToWorld(Source, 0,0,1);
	local zX, zY, zZ = worldDirectionToLocal(getParent(Target), zX, zY, zZ);
	local yX, yY, yZ = localDirectionToWorld(Source, 0,1,0);
	local yX, yY, yZ = worldDirectionToLocal(getParent(Target), yX, yY, yZ);
	setDirection(Target, zX, zY, zZ, yX, yY, yZ);
	return false;
end;

function fergflatbedattach:attachobjects(object,baleT)
	local attachedobject = {};
	attachedobject.object = object;
	if self.isServer then
		attachedobject.AT = createTransformGroup("AT");
		link(self.place.attacherNode,attachedobject.AT);
		
		attachedobject.objectMass = getMass(object);
		setMass(object,attachedobject.objectMass*0.01);
		
		self:OrientJoint(object,attachedobject.AT);

		local constr = JointConstructor:new();					
		constr:setActors(self.place.attacherNode, object);
		constr:setJointTransforms(attachedobject.AT,  object);
		for i=1, 3 do
			constr:setTranslationLimit(i-1, true, 0, 0);
			constr:setRotationLimit(i-1,0,0);
		end;
		attachedobject.JointIndex = constr:finalize();
		
		if baleT ~= nil then
			attachedobject.baleT = baleT;
			baleT.isAttached = true;
		end;
	end;

	table.insert(self.Attachedobjects, attachedobject);
	return true;
end;

function fergflatbedattach:detachobjects()
	if self.isServer then
		for k,v in pairs(self.Attachedobjects) do
			removeJoint(v.JointIndex);
			delete(v.AT);
			v.JointIndex = nil;
			setMass(v.object,v.objectMass);
			if v.baleT ~= nil then
				v.baleT.isAttached = nil;
			end;
		end;
	end;
	
	self.Attachedobjects = nil;
	self.Attachedobjects = {};
	self.balesAttached = false;
end;

function fergflatbedattach:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then

	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function fergflatbedattach:getSaveAttributesAndNodes(nodeIdent)
   -- local attributes = ' side="'..tostring(self.currentSide)..'"';
    local attributes = nil;
    local node = nil;
    return attributes, node;
end;
function fergflatbedattach:delete()

end;

function fergflatbedattach:mouseEvent(posX, posY, isDown, isUp, button)
end;

function fergflatbedattach:keyEvent(unicode, sym, modifier, isDown)
end;

AttachBaleEvent = {};
AttachBaleEvent_mt = Class(AttachBaleEvent, Event);
  
InitEventClass(AttachBaleEvent, "AttachBaleEvent");
  
function AttachBaleEvent:emptyNew()
     local self = Event:new(AttachBaleEvent_mt);
      self.className="AttachBaleEvent";
      return self;
end;
  
function AttachBaleEvent:new(object, attachBales)
      local self = AttachBaleEvent:emptyNew()
      self.object = object;
      self.attachBales = attachBales;
      return self;
end;
  
function AttachBaleEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.attachBales = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function AttachBaleEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.attachBales);
end;
  
function AttachBaleEvent:run(connection)
      if not connection:getIsServer() then
         g_server:broadcastEvent(self, false, connection, self.object);
      end;
      self.object:setAttachBales(self.attachBales, true);
end;
  
function AttachBaleEvent.sendEvent(vehicle, attachBales, noEventSend)
      if attachBales ~= vehicle.isAttachBales then
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(AttachBaleEvent:new(vehicle, attachBales), nil, nil, vehicle);
              else
                  g_client:getServerConnection():sendEvent(AttachBaleEvent:new(vehicle, attachBales));
              end;
          end;
      end;
end;