SetCrateVisibilityEvent = {};
SetCrateVisibilityEvent_mt = Class(SetCrateVisibilityEvent, Event);

InitEventClass(SetCrateVisibilityEvent, "SetCrateVisibilityEvent");

function SetCrateVisibilityEvent:emptyNew()
    local self = Event:new(SetCrateVisibilityEvent_mt);
    self.className="SetCrateVisibilityEvent";
    return self;
end;

function SetCrateVisibilityEvent:new(object, crate)
    local self = SetCrateVisibilityEvent:emptyNew()
    self.object = object;
	self.crate = crate;
    return self;
end;

function SetCrateVisibilityEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.crate = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetCrateVisibilityEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));	
	streamWriteBool(streamId, self.crate);	
end;

function SetCrateVisibilityEvent:run(connection)
	self.object:setCrateVisibility(self.crate, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetCrateVisibilityEvent:new(self.object, self.crate), nil, connection, self.object);
	end;
end;

