SetCrateRotationtwoEvent = {};
SetCrateRotationtwoEvent_mt = Class(SetCrateRotationtwoEvent, Event);
 
InitEventClass(SetCrateRotationtwoEvent, "SetCrateRotationtwoEvent");

function SetCrateRotationtwoEvent:emptyNew()
      local self = Event:new(SetCrateRotationtwoEvent_mt);
      self.className="SetCrateRotationtwoEvent";
      return self;
end;
 
function SetCrateRotationtwoEvent:new(object, rotationMax3)
     local self = SetCrateRotationtwoEvent:emptyNew()
     self.object = object;
     self.rotationMax3 = rotationMax3;
      return self;
end;

function SetCrateRotationtwoEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
     self.rotationMax3 = streamReadBool(streamId);
     self.object = networkGetObject(id);
      self:run(connection);
end;
 
function SetCrateRotationtwoEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.rotationMax3);
end;

function SetCrateRotationtwoEvent:run(connection)
      self.object:setRotationMax3(self.rotationMax3, true);
     if not connection:getIsServer() then
          g_server:broadcastEvent(SetCrateRotationtwoEvent:new(self.object, self.rotationMax3), nil, connection, self.object);
     end;
end;