SetCrateRotationoneEvent = {};
SetCrateRotationoneEvent_mt = Class(SetCrateRotationoneEvent, Event);
 
InitEventClass(SetCrateRotationoneEvent, "SetCrateRotationoneEvent");

function SetCrateRotationoneEvent:emptyNew()
      local self = Event:new(SetCrateRotationoneEvent_mt);
      self.className="SetCrateRotationoneEvent";
      return self;
end;
 
function SetCrateRotationoneEvent:new(object, rotationMax2)
     local self = SetCrateRotationoneEvent:emptyNew()
     self.object = object;
     self.rotationMax2 = rotationMax2;
      return self;
end;

function SetCrateRotationoneEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
     self.rotationMax2 = streamReadBool(streamId);
     self.object = networkGetObject(id);
     self:run(connection);
end;
 
function SetCrateRotationoneEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.rotationMax2);

end;

function SetCrateRotationoneEvent:run(connection)
     self.object:setRotationMax2(self.rotationMax2, true);
     if not connection:getIsServer() then
          g_server:broadcastEvent(SetCrateRotationoneEvent:new(self.object, self.rotationMax2), nil, connection, self.object);
     end;
end;